/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.lib.cloud.annotations.CommandMethod;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.events.SBAPlayerPartyLeaveEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Service
public class PartyLeaveCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (init) {
            return;
        }
        CommandManager.getInstance().getAnnotationParser().parse(this);
        init = true;
    }

    @CommandMethod(value="party|p leave")
    private void commandLeave(@NotNull Player playerArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        if (!player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_IN_PARTY).send(player);
            return;
        }
        SBA.getInstance().getPartyManager().getPartyOf(player).ifPresentOrElse(party -> {
            SBAPlayerPartyLeaveEvent event = new SBAPlayerPartyLeaveEvent(player, (IParty)party);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            player.getSettings().disable(PlayerSetting.IN_PARTY);
            party.removePlayer(player);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_OFFLINE_QUIT).replace("%player%", player.getName()).send(party.getMembers().toArray(new SBAPlayerWrapper[0]));
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_LEFT).send(player);
            if (party.getMembers().size() == 1) {
                SBA.getInstance().getPartyManager().disband(party.getUUID());
                return;
            }
            if (party.getPartyLeader().equals(player)) {
                party.getMembers().stream().findAny().ifPresentOrElse(member -> {
                    party.setPartyLeader((SBAPlayerWrapper)member);
                    LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_PROMOTED_LEADER).replace("%player%", member.getName()).send(player);
                }, () -> SBA.getInstance().getPartyManager().disband(party.getUUID()));
            }
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_OFFLINE_LEFT).replace("%player%", player.getName()).send((CommandSenderWrapper[])party.getMembers().stream().filter(member -> !player.equals(member)).toArray(SBAPlayerWrapper[]::new));
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR));
    }
}

