/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.data;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ToggleableSetting<T extends Enum<T>> {
    private final Set<T> settingSet = new HashSet<T>();

    public static <T extends Enum<T>> ToggleableSetting<T> of(Class<T> settingClass) {
        return new ToggleableSetting<T>();
    }

    public ToggleableSetting<T> enable(@NotNull T setting) {
        this.settingSet.add(setting);
        return this;
    }

    public ToggleableSetting<T> disable(@NotNull T setting) {
        this.settingSet.remove(setting);
        return this;
    }

    public ToggleableSetting<T> toggle(@NotNull T setting) {
        if (this.settingSet.contains(setting)) {
            this.disable(setting);
        } else {
            this.enable(setting);
        }
        return this;
    }

    public Set<T> getAll() {
        return Set.copyOf(this.settingSet);
    }

    public boolean isToggled(@NotNull T status) {
        return this.settingSet.contains(status);
    }

    private ToggleableSetting() {
    }
}

