/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.screaminglib.npc.NPC;
import io.github.pronze.lib.screaminglib.npc.skin.NPCSkin;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.lib.screaminglib.visuals.LocatableVisual;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.data.GamePlayerData;
import io.github.pronze.sba.game.GameStorage;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.game.IGameStorage;
import io.github.pronze.sba.game.IRotatingGenerator;
import io.github.pronze.sba.game.InvisiblePlayer;
import io.github.pronze.sba.game.InvisiblePlayerImpl;
import io.github.pronze.sba.game.RotatingGenerator;
import io.github.pronze.sba.game.tasks.BaseGameTask;
import io.github.pronze.sba.game.tasks.GameTaskManager;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.manager.ScoreboardManager;
import io.github.pronze.sba.service.NPCStoreService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.visuals.GameScoreboardManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.events.BedwarsGameEndingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPostRebuildingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsTargetBlockDestroyedEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.game.GameStore;
import org.screamingsandals.bedwars.game.ItemSpawner;
import org.screamingsandals.bedwars.game.TeamColor;

public class Arena
implements IArena {
    private static LivingEntity mockEntity = null;
    private final List<IRotatingGenerator> rotatingGenerators;
    private final Map<UUID, InvisiblePlayer> invisiblePlayers;
    private final Map<UUID, GamePlayerData> playerDataMap;
    private final List<BaseGameTask> gameTasks;
    private final List<NPC> storeNPCS;
    private final List<NPC> upgradeStoreNPCS;
    private final GameScoreboardManager scoreboardManager;
    private final Game game;
    private final IGameStorage storage;

    public Arena(@NotNull Game game) {
        this.game = game;
        this.rotatingGenerators = new ArrayList<IRotatingGenerator>();
        this.invisiblePlayers = new HashMap<UUID, InvisiblePlayer>();
        this.playerDataMap = new HashMap<UUID, GamePlayerData>();
        this.gameTasks = new ArrayList<BaseGameTask>();
        this.storeNPCS = new ArrayList<NPC>();
        this.upgradeStoreNPCS = new ArrayList<NPC>();
        this.storage = new GameStorage(game);
        this.gameTasks.addAll(GameTaskManager.getInstance().startTasks(this));
        this.scoreboardManager = new GameScoreboardManager(this);
        this.game.getConnectedPlayers().forEach(player -> this.registerPlayerData(player.getUniqueId(), GamePlayerData.of(player)));
    }

    @Override
    @NotNull
    public List<Player> getInvisiblePlayers() {
        return this.invisiblePlayers.values().stream().map(InvisiblePlayer::getHiddenPlayer).collect(Collectors.toList());
    }

    @Override
    public void addHiddenPlayer(@NotNull Player player) {
        if (this.invisiblePlayers.containsKey(player.getUniqueId())) {
            return;
        }
        InvisiblePlayerImpl invisiblePlayer = new InvisiblePlayerImpl(player, this);
        this.invisiblePlayers.put(player.getUniqueId(), invisiblePlayer);
        Tasker.build(() -> invisiblePlayer.vanish()).afterOneTick().start();
    }

    @Override
    public void removeHiddenPlayer(@NotNull Player player) {
        InvisiblePlayer invisiblePlayer = this.invisiblePlayers.get(player.getUniqueId());
        if (invisiblePlayer != null) {
            invisiblePlayer.setHidden(false);
            this.invisiblePlayers.remove(player.getUniqueId());
        }
    }

    @Override
    public void registerPlayerData(@NotNull UUID uuid, @NotNull GamePlayerData data) {
        if (this.playerDataMap.containsKey(uuid)) {
            throw new UnsupportedOperationException("PlayerData of uuid: " + uuid + " is already registered!");
        }
        this.playerDataMap.put(uuid, data);
    }

    @Override
    public void unregisterPlayerData(@NotNull UUID uuid) {
        if (!this.playerDataMap.containsKey(uuid)) {
            throw new UnsupportedOperationException("PlayerData of uuid: " + uuid + " is not registered!");
        }
        this.playerDataMap.remove(uuid);
    }

    @Override
    public Optional<GamePlayerData> getPlayerData(@NotNull UUID uuid) {
        return Optional.ofNullable(this.playerDataMap.get(uuid));
    }

    @Override
    @NotNull
    public IGameStorage getStorage() {
        return this.storage;
    }

    @Override
    @NotNull
    public Game getGame() {
        return this.game;
    }

    @Override
    @NotNull
    public ScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    @Override
    public boolean isPlayerHidden(@NotNull Player player) {
        return this.invisiblePlayers.containsKey(player.getUniqueId());
    }

    public void onGameStarted() {
        LanguageService.getInstance().get(MessageKeys.GAME_START_MESSAGE).send((CommandSenderWrapper[])this.game.getConnectedPlayers().stream().map(PlayerMapper::wrapPlayer).toArray(PlayerWrapper[]::new));
        if (SBAConfig.getInstance().node("floating-generator", "enabled").getBoolean()) {
            this.game.getItemSpawners().forEach(itemSpawner -> {
                for (Map.Entry<Object, ? extends ConfigurationNode> entry : SBAConfig.getInstance().node("floating-generator", "mapping").childrenMap().entrySet()) {
                    if (!itemSpawner.getItemSpawnerType().getMaterial().name().equalsIgnoreCase(((String)entry.getKey()).toUpperCase())) continue;
                    Material material = Material.valueOf((String)entry.getValue().getString("AIR"));
                    Logger.trace("createRotatingGenerator({},{})", itemSpawner, material);
                    this.createRotatingGenerator((ItemSpawner)itemSpawner, material);
                }
            });
        }
        if (SBAConfig.getInstance().node("replace-stores-with-npc").getBoolean(true)) {
            this.game.getGameStores().forEach(store -> {
                GameStore nonAPIStore = (GameStore)store;
                LivingEntity villager = nonAPIStore.kill();
                if (villager != null) {
                    Main.unregisterGameEntity((Entity)villager);
                }
                if (mockEntity == null) {
                    mockEntity = (Bat)this.game.getGameWorld().spawnEntity(this.game.getSpectatorSpawn().clone().add(0.0, 300.0, 0.0), EntityType.BAT);
                    mockEntity.setAI(false);
                }
                Reflect.setField((Object)nonAPIStore, "entity", (Object)mockEntity);
                String file = store.getShopFile();
                List<Object> name = new ArrayList();
                NPCSkin skin = null;
                try {
                    if (file != null && file.equalsIgnoreCase("upgradeShop.yml")) {
                        skin = NPCStoreService.getInstance().getUpgradeShopSkin();
                        name = NPCStoreService.getInstance().getUpgradeShopText();
                    } else {
                        skin = NPCStoreService.getInstance().getShopSkin();
                        name = NPCStoreService.getInstance().getShopText();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                NPC npc = (NPC)NPC.of(LocationMapper.wrapLocation(store.getStoreLocation())).setDisplayName(name).setShouldLookAtPlayer(true).setSkin(skin).setTouchable(true);
                if (file != null && file.equals("upgradeShop.yml")) {
                    this.upgradeStoreNPCS.add(npc);
                } else {
                    this.storeNPCS.add(npc);
                }
                this.game.getConnectedPlayers().stream().map(PlayerMapper::wrapPlayer).forEach(npc::addViewer);
                npc.show();
            });
        }
    }

    public void onTargetBlockDestroyed(BedwarsTargetBlockDestroyedEvent e) {
        RunningTeam team = e.getTeam();
        String title = LanguageService.getInstance().get(MessageKeys.BED_DESTROYED_TITLE).toString();
        String subtitle = LanguageService.getInstance().get(MessageKeys.BED_DESTROYED_SUBTITLE).toString();
        team.getConnectedPlayers().forEach(player -> SBAUtil.sendTitle(PlayerMapper.wrapPlayer(player), title, subtitle, 0, 40, 20));
        Player destroyer = e.getPlayer();
        if (destroyer != null) {
            this.getPlayerData(destroyer.getUniqueId()).ifPresent(destroyerData -> destroyerData.setBedDestroys(destroyerData.getBedDestroys() + 1));
        }
    }

    public void onOver(BedwarsPostRebuildingEvent e) {
        this.scoreboardManager.destroy();
        this.gameTasks.forEach(BaseGameTask::stop);
        this.gameTasks.clear();
        this.rotatingGenerators.forEach(IRotatingGenerator::destroy);
        this.rotatingGenerators.clear();
        this.storeNPCS.forEach(LocatableVisual::destroy);
        this.upgradeStoreNPCS.forEach(LocatableVisual::destroy);
        this.storeNPCS.clear();
        this.upgradeStoreNPCS.clear();
        this.getInvisiblePlayers().forEach(this::removeHiddenPlayer);
    }

    @Override
    public void removeVisualsForPlayer(Player player) {
        this.rotatingGenerators.forEach(gen -> gen.removeViewer(player));
        this.storeNPCS.forEach(npc -> npc.removeViewer(PlayerMapper.wrapPlayer(player)));
        this.upgradeStoreNPCS.forEach(npc -> npc.removeViewer(PlayerMapper.wrapPlayer(player)));
    }

    @Override
    public void addVisualsForPlayer(Player player) {
        this.rotatingGenerators.forEach(gen -> gen.addViewer(player));
        this.storeNPCS.forEach(npc -> npc.addViewer(PlayerMapper.wrapPlayer(player)));
        this.upgradeStoreNPCS.forEach(npc -> npc.addViewer(PlayerMapper.wrapPlayer(player)));
    }

    @Override
    public void removePlayerFromGame(Player player) {
        this.scoreboardManager.removeScoreboard(player);
        this.removeVisualsForPlayer(player);
    }

    public void onOver(BedwarsGameEndingEvent e) {
        RunningTeam winner = e.getWinningTeam();
        if (winner != null) {
            int n;
            String nullStr;
            String firstKillerName = nullStr = LanguageService.getInstance().get(MessageKeys.NONE).toString();
            int firstKillerScore = 0;
            for (Map.Entry<UUID, GamePlayerData> entry : this.playerDataMap.entrySet()) {
                GamePlayerData playerData = this.playerDataMap.get(entry.getKey());
                int n2 = playerData.getKills();
                if (n2 <= 0 || n2 <= firstKillerScore) continue;
                firstKillerScore = n2;
                firstKillerName = playerData.getName();
            }
            String secondKillerName = nullStr;
            int secondKillerScore = 0;
            for (Map.Entry entry : this.playerDataMap.entrySet()) {
                GamePlayerData playerData = this.playerDataMap.get(entry.getKey());
                int n3 = playerData.getKills();
                String name = playerData.getName();
                if (n3 <= 0 || n3 <= secondKillerScore || name.equalsIgnoreCase(firstKillerName)) continue;
                secondKillerName = name;
                secondKillerScore = n3;
            }
            String thirdKillerName = nullStr;
            boolean bl = false;
            for (Map.Entry entry : this.playerDataMap.entrySet()) {
                GamePlayerData playerData = this.playerDataMap.get(entry.getKey());
                int kills = playerData.getKills();
                String name = playerData.getName();
                if (kills <= 0 || kills <= n || name.equalsIgnoreCase(firstKillerName) || name.equalsIgnoreCase(secondKillerName)) continue;
                thirdKillerName = name;
                n = kills;
            }
            String victoryTitle = LanguageService.getInstance().get(MessageKeys.VICTORY_TITLE).toString();
            ArrayList arrayList = new ArrayList();
            winner.getConnectedPlayers().forEach(player -> WinTeamPlayers.add(player.getDisplayName()));
            winner.getConnectedPlayers().forEach(pl -> SBAUtil.sendTitle(PlayerMapper.wrapPlayer(pl), victoryTitle, "", 0, 90, 0));
            LanguageService.getInstance().get(MessageKeys.OVERSTATS_MESSAGE).replace("%color%", TeamColor.valueOf((String)winner.getColor().name()).chatColor.toString()).replace("%win_team%", winner.getName()).replace("%winners%", arrayList.toString()).replace("%first_killer_name%", firstKillerName).replace("%second_killer_name%", secondKillerName).replace("%third_killer_name%", thirdKillerName).replace("%first_killer_score%", String.valueOf(firstKillerScore)).replace("%second_killer_score%", String.valueOf(secondKillerScore)).replace("%third_killer_score%", String.valueOf(n)).send((CommandSenderWrapper[])this.game.getConnectedPlayers().stream().map(PlayerMapper::wrapPlayer).toArray(PlayerWrapper[]::new));
        }
    }

    @Override
    public void createRotatingGenerator(@NotNull ItemSpawner itemSpawner, @NotNull Material rotationMaterial) {
        RotatingGenerator generator = new RotatingGenerator(itemSpawner, new ItemStack(rotationMaterial), itemSpawner.getLocation());
        generator.spawn(this.game.getConnectedPlayers());
        this.rotatingGenerators.add(generator);
    }

    @Override
    @NotNull
    public List<NPC> getStoreNPCS() {
        return List.copyOf(this.storeNPCS);
    }

    @Override
    @NotNull
    public List<NPC> getUpgradeStoreNPCS() {
        return List.copyOf(this.upgradeStoreNPCS);
    }

    @Override
    public <T extends BaseGameTask> Optional<T> getTask(@NotNull Class<T> taskClass) {
        return this.getGameTasks().stream().filter(gameTask -> gameTask.getClass().isAssignableFrom(taskClass)).findAny();
    }

    @Override
    public List<BaseGameTask> getGameTasks() {
        return List.copyOf(this.gameTasks);
    }

    @Override
    public List<IRotatingGenerator> getRotatingGenerators() {
        return List.copyOf(this.rotatingGenerators);
    }

    @Override
    public Optional<InvisiblePlayer> getHiddenPlayer(UUID playerUUID) {
        return Optional.ofNullable(this.invisiblePlayers.get(playerUUID));
    }
}

