/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public enum GameMode {
    SOLOS,
    DOUBLES,
    TRIPLES,
    SQUADS;


    public String strVal() {
        return this.toString().substring(0, 1).toUpperCase() + this.toString().substring(1).toLowerCase();
    }

    public int intVal() {
        switch (this) {
            case SOLOS: {
                return 1;
            }
            case DOUBLES: {
                return 2;
            }
            case TRIPLES: {
                return 3;
            }
            case SQUADS: {
                return 4;
            }
        }
        return 1;
    }

    public static GameMode fromName(@NotNull String name) {
        return Arrays.stream(GameMode.values()).filter(value -> value.toString().equals(name.toUpperCase())).findAny().orElse(SOLOS);
    }

    public static GameMode fromInt(@NotNull int value) {
        switch (value) {
            case 1: {
                return SOLOS;
            }
            case 2: {
                return DOUBLES;
            }
            case 3: {
                return TRIPLES;
            }
            case 4: {
                return SQUADS;
            }
        }
        return SOLOS;
    }
}

