/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game.tasks;

import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.tasker.task.TaskerTask;
import io.github.pronze.sba.game.IArena;
import java.util.UUID;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;

public abstract class BaseGameTask {
    private final UUID uuid = UUID.randomUUID();
    protected IArena arena;
    protected Game game;
    private long duration = 1L;
    private TaskerTime timeUnit = TaskerTime.SECONDS;
    private TaskerTask task;
    private boolean started;

    public BaseGameTask start(IArena arena) {
        this.arena = arena;
        this.game = arena.getGame();
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = Tasker.build(this::loopLogic).repeat(this.duration, this.timeUnit).start();
        return this;
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
    }

    public void loopLogic() {
        if (this.game.getStatus() != GameStatus.RUNNING) {
            this.task.cancel();
            this.task = null;
            return;
        }
        this.run();
    }

    public abstract void run();

    public UUID getUuid() {
        return this.uuid;
    }

    public IArena getArena() {
        return this.arena;
    }

    public Game getGame() {
        return this.game;
    }

    public long getDuration() {
        return this.duration;
    }

    public TaskerTime getTimeUnit() {
        return this.timeUnit;
    }

    public TaskerTask getTask() {
        return this.task;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setArena(IArena arena) {
        this.arena = arena;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setTimeUnit(TaskerTime timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setTask(TaskerTask task) {
        this.task = task;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseGameTask)) {
            return false;
        }
        BaseGameTask other = (BaseGameTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.isStarted() != other.isStarted()) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        IArena this$arena = this.getArena();
        IArena other$arena = other.getArena();
        if (this$arena == null ? other$arena != null : !this$arena.equals(other$arena)) {
            return false;
        }
        Game this$game = this.getGame();
        Game other$game = other.getGame();
        if (this$game == null ? other$game != null : !this$game.equals(other$game)) {
            return false;
        }
        TaskerTime this$timeUnit = this.getTimeUnit();
        TaskerTime other$timeUnit = other.getTimeUnit();
        if (this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit)) {
            return false;
        }
        TaskerTask this$task = this.getTask();
        TaskerTask other$task = other.getTask();
        return !(this$task == null ? other$task != null : !this$task.equals(other$task));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseGameTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        result = result * 59 + (this.isStarted() ? 79 : 97);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        IArena $arena = this.getArena();
        result = result * 59 + ($arena == null ? 43 : $arena.hashCode());
        Game $game = this.getGame();
        result = result * 59 + ($game == null ? 43 : $game.hashCode());
        TaskerTime $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        TaskerTask $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        return result;
    }

    public String toString() {
        return "BaseGameTask(uuid=" + this.getUuid() + ", arena=" + this.getArena() + ", game=" + this.getGame() + ", duration=" + this.getDuration() + ", timeUnit=" + this.getTimeUnit() + ", task=" + this.getTask() + ", started=" + this.isStarted() + ")";
    }
}

