/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game.tasks;

import io.github.pronze.lib.screaminglib.plugin.ServiceManager;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.game.tasks.BaseGameTask;
import io.github.pronze.sba.game.tasks.GeneratorTask;
import io.github.pronze.sba.game.tasks.HealPoolTask;
import io.github.pronze.sba.game.tasks.MinerTrapTask;
import io.github.pronze.sba.game.tasks.TrapTask;
import io.github.pronze.sba.manager.IGameTaskManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@Service
public class GameTaskManager
implements IGameTaskManager {
    private final List<BaseGameTask> tasks = new ArrayList<BaseGameTask>();

    public static GameTaskManager getInstance() {
        return ServiceManager.get(GameTaskManager.class);
    }

    public GameTaskManager() {
        this.addTask(new GeneratorTask());
        this.addTask(new HealPoolTask());
        this.addTask(new TrapTask());
        this.addTask(new MinerTrapTask());
    }

    @Override
    public void addTask(@NotNull BaseGameTask task) {
        if (this.tasks.contains(task)) {
            throw new UnsupportedOperationException("TaskManager already contains task: " + task.getClass().getSimpleName());
        }
        this.tasks.add(task);
    }

    @Override
    public void removeTask(@NotNull BaseGameTask task) {
        if (!this.tasks.contains(task)) {
            return;
        }
        this.tasks.remove(task);
    }

    @Override
    public List<BaseGameTask> startTasks(@NotNull IArena arena) {
        ArrayList<BaseGameTask> l = new ArrayList<BaseGameTask>(4);
        l.add(new GeneratorTask());
        l.add(new HealPoolTask());
        l.add(new TrapTask());
        l.add(new MinerTrapTask());
        return l.stream().map(task -> task.start(arena)).collect(Collectors.toList());
    }
}

