/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.lang;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.TextComponent;
import io.github.pronze.lib.kyori.adventure.text.minimessage.MiniMessage;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.sba.AddonAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Message {
    private List<String> original = new ArrayList<String>();
    private boolean prefix;

    public static Message of(List<String> text) {
        return new Message(text);
    }

    private Message(List<String> text) {
        this.original.addAll(text);
    }

    public Message replace(String key, String value) {
        this.original = this.original.stream().map(str -> str.replaceAll(key, value)).collect(Collectors.toList());
        return this;
    }

    public Message withPrefix() {
        this.prefix = true;
        return this;
    }

    public Component toComponent() {
        TextComponent.Builder component = Component.text();
        this.original.forEach(str -> {
            if (this.prefix) {
                str = AddonAPI.getInstance().getConfigurator().getString("prefix", "[SBA]") + ": " + (String)str;
            }
            component.append(MiniMessage.get().parse((String)str));
            if (this.original.indexOf(str) + 1 != this.original.size()) {
                component.append((Component)Component.text("\n"));
            }
        });
        return component.build();
    }

    public String toString() {
        Object string = this.original.get(0);
        if (this.prefix) {
            string = AddonAPI.getInstance().getConfigurator().getString("prefix", "[SBA]") + ": ";
        }
        return AdventureHelper.toLegacy(MiniMessage.get().parse((String)string));
    }

    public List<String> toStringList() {
        return this.toComponentList().stream().map(AdventureHelper::toLegacy).collect(Collectors.toList());
    }

    public List<Component> toComponentList() {
        return this.original.stream().map(str -> {
            if (this.prefix) {
                str = AddonAPI.getInstance().getConfigurator().getString("prefix", "[SBA]") + ": " + (String)str;
            }
            return str;
        }).map(MiniMessage.get()::parse).collect(Collectors.toList());
    }

    public void send(CommandSenderWrapper ... wrapper) {
        List<Component> message = this.toComponentList();
        for (CommandSenderWrapper sender : wrapper) {
            message.forEach(sender::sendMessage);
        }
    }

    public void send(List<CommandSenderWrapper> wrapperList) {
        List<Component> message = this.toComponentList();
        wrapperList.forEach(wrapper -> message.forEach(wrapper::sendMessage));
    }

    private Message() {
    }

    private static Message of() {
        return new Message();
    }
}

