/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.listener;

import io.github.pronze.lib.screaminglib.event.OnEvent;
import io.github.pronze.lib.screaminglib.nms.accessors.ClientboundSetEquipmentPacketAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.ClientboundUpdateMobEffectPacketAccessor;
import io.github.pronze.lib.screaminglib.packet.event.SPacketEvent;
import io.github.pronze.lib.screaminglib.utils.PacketMethod;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.game.InvisiblePlayer;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.Game;

@Service
public class PacketListener {
    @OnEvent
    public void onEffects(SPacketEvent event) {
        if (event.getMethod() != PacketMethod.OUTBOUND) {
            return;
        }
        Player player = event.getPlayer().as(Player.class);
        Object packet = event.getPacket();
        if (ClientboundUpdateMobEffectPacketAccessor.getType().isInstance(packet)) {
            int entityId = (Integer)Reflect.getField(packet, ClientboundUpdateMobEffectPacketAccessor.getFieldEntityId());
            Game playerGame = Main.getInstance().getGameOfPlayer(player);
            if (playerGame == null) {
                return;
            }
            Player equipper = null;
            for (Player gamePlayer : playerGame.getConnectedPlayers()) {
                if (gamePlayer.getEntityId() != entityId) continue;
                equipper = gamePlayer;
                break;
            }
            if (equipper == null) {
                return;
            }
            Optional<IArena> maybeArena = ArenaManager.getInstance().get(playerGame.getName());
            if (maybeArena.isEmpty()) {
                return;
            }
            IArena arena = maybeArena.get();
            if (arena.isPlayerHidden(equipper) && playerGame.getTeamOfPlayer(equipper) != playerGame.getTeamOfPlayer(player)) {
                event.setCancelled(true);
            }
        }
    }

    @OnEvent
    public void onEquipped(SPacketEvent event) {
        if (event.getMethod() != PacketMethod.OUTBOUND) {
            return;
        }
        Player player = event.getPlayer().as(Player.class);
        Object packet = event.getPacket();
        if (ClientboundSetEquipmentPacketAccessor.getType().isInstance(packet)) {
            int entityId = (Integer)Reflect.getField(packet, ClientboundSetEquipmentPacketAccessor.getFieldEntity());
            Player equipper = null;
            Game playerGame = Main.getInstance().getGameOfPlayer(player);
            if (playerGame == null) {
                return;
            }
            for (Player gamePlayer : playerGame.getConnectedPlayers()) {
                if (gamePlayer.getEntityId() != entityId) continue;
                equipper = gamePlayer;
                break;
            }
            if (equipper == null) {
                return;
            }
            Optional<IArena> maybeArena = ArenaManager.getInstance().get(playerGame.getName());
            if (maybeArena.isEmpty()) {
                return;
            }
            IArena arena = maybeArena.get();
            if (arena.isPlayerHidden(equipper) && playerGame.getTeamOfPlayer(equipper) != playerGame.getTeamOfPlayer(player)) {
                InvisiblePlayer hiddenEquipper = arena.getHiddenPlayer(equipper.getUniqueId()).orElseThrow();
                if (hiddenEquipper.isJustEquipped()) {
                    hiddenEquipper.setJustEquipped(false);
                    return;
                }
                event.setCancelled(true);
            }
        }
    }
}

