/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.listener;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.events.SBAPlayerPartyChatEvent;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@Service
public class PartyListener
implements Listener {
    @OnPostEnable
    public void registerListener() {
        SBA.getInstance().registerListener(this);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(event.getPlayer());
        if (player.getSettings().isToggled(PlayerSetting.PARTY_CHAT_ENABLED) && player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            event.setCancelled(true);
            SBA.getInstance().getPartyManager().getPartyOf(player).ifPresent(party -> {
                SBAPlayerPartyChatEvent chatEvent = new SBAPlayerPartyChatEvent(player, (IParty)party);
                chatEvent.setMessage(Component.text(event.getMessage()));
                SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)chatEvent);
                if (chatEvent.isCancelled()) {
                    return;
                }
                party.sendMessage(AdventureHelper.toComponent(event.getMessage()), player);
            });
        }
    }
}

