/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.listener;

import io.github.pronze.lib.pronzelib.scoreboards.Scoreboard;
import io.github.pronze.lib.pronzelib.scoreboards.ScoreboardManager;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.Permissions;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.data.DegradableItem;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.utils.ShopUtil;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.GamePlayer;

@Service
public class PlayerListener
implements Listener {
    private final List<Material> allowedDropItems = new ArrayList<Material>();
    private final List<Material> generatorDropItems = new ArrayList<Material>();

    @OnPostEnable
    public void registerListener() {
        SBA.getInstance().registerListener(this);
        this.allowedDropItems.clear();
        this.generatorDropItems.clear();
        this.allowedDropItems.addAll(SBAUtil.parseMaterialFromConfig("allowed-item-drops"));
        this.generatorDropItems.addAll(SBAUtil.parseMaterialFromConfig("running-generator-drops"));
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player killer;
        Player player = e.getEntity();
        if (!Main.getInstance().isPlayerPlayingAnyGame(player)) {
            return;
        }
        final Game game = Main.getInstance().getGameOfPlayer(player);
        if (game.getStatus() != GameStatus.RUNNING) {
            return;
        }
        IArena arena = ArenaManager.getInstance().get(game.getName()).orElseThrow();
        final ArrayList<ItemStack> itemArr = new ArrayList<ItemStack>();
        ItemStack sword = Main.isLegacy() ? new ItemStack(Material.valueOf((String)"WOOD_SWORD")) : new ItemStack(Material.WOODEN_SWORD);
        Arrays.stream((ItemStack[])player.getInventory().getContents().clone()).filter(Objects::nonNull).forEach(stack -> {
            String name;
            String endStr;
            switch (endStr = name.substring((name = stack.getType().name()).contains("_") ? name.indexOf("_") + 1 : 0)) {
                case "SWORD": {
                    itemArr.add(ShopUtil.downgradeItem(stack, DegradableItem.WEAPONARY));
                    break;
                }
                case "PICKAXE": 
                case "AXE": {
                    itemArr.add(ShopUtil.downgradeItem(stack, DegradableItem.TOOLS));
                    break;
                }
                case "LEGGINGS": 
                case "BOOTS": 
                case "CHESTPLATE": 
                case "HELMET": {
                    itemArr.add(ShopUtil.downgradeItem(stack, DegradableItem.ARMOR));
                    break;
                }
                case "SHEARS": {
                    itemArr.add((ItemStack)stack);
                }
            }
        });
        itemArr.add(sword);
        arena.getPlayerData(player.getUniqueId()).ifPresent(playerData -> playerData.setInventory(itemArr));
        if (SBAConfig.getInstance().getBoolean("give-killer-resources", true).booleanValue() && (killer = e.getEntity().getKiller()) != null && Main.getInstance().isPlayerPlayingAnyGame(killer) && killer.getGameMode() == GameMode.SURVIVAL) {
            Arrays.stream(player.getInventory().getContents()).filter(Objects::nonNull).forEach(drop -> {
                if (this.generatorDropItems.contains(drop.getType())) {
                    killer.sendMessage("+" + drop.getAmount() + " " + drop.getType().name().toLowerCase().replace("_", " "));
                    killer.getInventory().addItem(new ItemStack[]{drop});
                }
            });
        }
        final GamePlayer gVictim = Main.getPlayerGameProfile((Player)player);
        RunningTeam victimTeam = game.getTeamOfPlayer(player);
        if (SBAConfig.getInstance().getBoolean("respawn-cooldown.enabled", true).booleanValue() && victimTeam.isAlive() && game.isPlayerInAnyTeam(player) && game.getTeamOfPlayer(player).isTargetBlockExists()) {
            new BukkitRunnable(){
                final GamePlayer gamePlayer;
                final Player player;
                final String respawnTitle;
                final String respawnSubtitle;
                final SBAPlayerWrapper wrappedPlayer;
                int livingTime;
                byte buffer;
                {
                    this.gamePlayer = gVictim;
                    this.player = this.gamePlayer.player;
                    this.respawnTitle = LanguageService.getInstance().get(MessageKeys.RESPAWN_COUNTDOWN_TITLE).toString();
                    this.respawnSubtitle = LanguageService.getInstance().get(MessageKeys.RESPAWN_COUNTDOWN_SUBTITLE).toString();
                    this.wrappedPlayer = PlayerMapper.wrapPlayer(this.player).as(SBAPlayerWrapper.class);
                    this.livingTime = SBAConfig.getInstance().getInt("respawn-cooldown.time", 5);
                    this.buffer = (byte)2;
                }

                public void run() {
                    if (!Main.isPlayerInGame((Player)this.player)) {
                        this.cancel();
                        return;
                    }
                    if (this.livingTime > 0) {
                        SBAUtil.sendTitle(this.wrappedPlayer, this.respawnTitle, this.respawnSubtitle.replace("%time%", String.valueOf(this.livingTime)), 0, 20, 0);
                        LanguageService.getInstance().get(MessageKeys.RESPAWN_COUNTDOWN_MESSAGE).replace("%time%", String.valueOf(this.livingTime)).send(this.wrappedPlayer);
                        --this.livingTime;
                    }
                    if (this.livingTime == 0) {
                        if (gVictim.isSpectator && this.buffer > 0) {
                            this.buffer = (byte)(this.buffer - 1);
                        } else {
                            LanguageService.getInstance().get(MessageKeys.RESPAWNED_MESSAGE).send(this.wrappedPlayer);
                            String respawnedTitle = LanguageService.getInstance().get(MessageKeys.RESPAWNED_TITLE).toString();
                            SBAUtil.sendTitle(this.wrappedPlayer, respawnedTitle, "", 5, 40, 5);
                            ShopUtil.giveItemToPlayer(itemArr, this.player, Main.getInstance().getGameByName(game.getName()).getTeamOfPlayer(this.player).getColor());
                            this.cancel();
                        }
                    }
                }
            }.runTaskTimer((Plugin)SBA.getPluginInstance(), 0L, 20L);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onClick(InventoryClickEvent event) {
        if (event.getCurrentItem() == null) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!Main.isPlayerInGame((Player)player)) {
            return;
        }
        if (SBAConfig.getInstance().getBoolean("disable-armor-inventory-movement", true).booleanValue() && event.getSlotType() == InventoryType.SlotType.ARMOR) {
            event.setCancelled(true);
        }
        Inventory topSlot = event.getView().getTopInventory();
        Inventory bottomSlot = event.getView().getBottomInventory();
        Inventory clickedInventory = event.getClickedInventory();
        String typeName = event.getCurrentItem().getType().name();
        if (clickedInventory == null) {
            return;
        }
        if (clickedInventory.equals(bottomSlot) && SBAConfig.getInstance().getBoolean("block-players-putting-certain-items-onto-chest", true).booleanValue() && (topSlot.getType() == InventoryType.CHEST || topSlot.getType() == InventoryType.ENDER_CHEST) && bottomSlot.getType() == InventoryType.PLAYER && (typeName.endsWith("AXE") || typeName.endsWith("SWORD"))) {
            event.setResult(Event.Result.DENY);
            LanguageService.getInstance().get(MessageKeys.CANNOT_PUT_ITEM_IN_CHEST).send(PlayerMapper.wrapPlayer(player));
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent evt) {
        Player player = evt.getPlayer();
        if (!Main.isPlayerInGame((Player)player)) {
            return;
        }
        if (!SBAConfig.getInstance().getBoolean("block-item-drops", true).booleanValue()) {
            return;
        }
        ItemStack ItemDrop = evt.getItemDrop().getItemStack();
        Material type = ItemDrop.getType();
        if (!this.allowedDropItems.contains(type) && !type.name().endsWith("WOOL")) {
            evt.setCancelled(true);
            player.getInventory().remove(ItemDrop);
        }
    }

    @EventHandler
    public void itemDamage(PlayerItemDamageEvent event) {
        if (!Main.isPlayerInGame((Player)event.getPlayer())) {
            return;
        }
        if (SBAConfig.getInstance().node("disable-item-damage").getBoolean(true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        ScoreboardManager.getInstance().fromCache(uuid).ifPresent(Scoreboard::destroy);
        SBAPlayerWrapper wrappedPlayer = PlayerMapper.wrapPlayer(player).as(SBAPlayerWrapper.class);
        SBA.getInstance().getPartyManager().getPartyOf(wrappedPlayer).ifPresent(party -> {
            party.removePlayer(wrappedPlayer);
            if (party.getMembers().size() == 1) {
                SBA.getInstance().getPartyManager().disband(party.getUUID());
                return;
            }
            if (party.getPartyLeader().equals(wrappedPlayer)) {
                party.getMembers().stream().findAny().ifPresentOrElse(member -> {
                    party.setPartyLeader((SBAPlayerWrapper)member);
                    LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_PROMOTED_LEADER).replace("%player%", member.getName()).send(party.getMembers().toArray(new SBAPlayerWrapper[0]));
                }, () -> SBA.getInstance().getPartyManager().disband(party.getUUID()));
            }
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_OFFLINE_LEFT).replace("%player%", player.getName()).send((CommandSenderWrapper[])party.getMembers().stream().filter(member -> !wrappedPlayer.equals(member)).toArray(SBAPlayerWrapper[]::new));
        });
        SBA.getInstance().getPlayerWrapperService().unregister(player);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && Main.isPlayerInGame((Player)(player = (Player)entity))) {
            Game game = Main.getInstance().getGameOfPlayer(player);
            ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> arena.removeHiddenPlayer(player));
            if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
                event.setDamage(SBAConfig.getInstance().node("explosion-damage").getDouble(1.0));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        ItemStack item = event.getItem();
        Player player = event.getPlayer();
        if (!Main.isPlayerInGame((Player)player)) {
            return;
        }
        if (item.getType() == Material.POTION) {
            PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
            boolean isInvis = false;
            if (potionMeta.getBasePotionData().getType() == PotionType.INVISIBILITY) {
                isInvis = true;
            } else if (potionMeta.hasCustomEffects()) {
                isInvis = potionMeta.getCustomEffects().stream().anyMatch(potionEffect -> potionEffect.getType().getName().equalsIgnoreCase(PotionEffectType.INVISIBILITY.getName()));
            }
            if (isInvis) {
                Game playerGame = Main.getInstance().getGameOfPlayer(player);
                ArenaManager.getInstance().get(playerGame.getName()).ifPresent(arena -> arena.addHiddenPlayer(player));
            }
            event.setReplacement(new ItemStack(Material.AIR));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        SBA.getInstance().getPlayerWrapperService().register(player);
        if (player.hasPermission(Permissions.UPGRADE.getKey()) && SBA.getInstance().isPendingUpgrade()) {
            Bukkit.getScheduler().runTaskLater((Plugin)SBA.getPluginInstance(), () -> {
                player.sendMessage("\u00a76[SBA]: Plugin has detected a version change, do you want to upgrade internal files?");
                player.sendMessage("Type /sba upgrade to upgrade file");
                player.sendMessage("\u00a7cif you want to cancel the upgrade files do /sba cancel");
            }, 40L);
        }
    }
}

