/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.service;

import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBASpawnerTierUpgradeEvent;
import io.github.pronze.sba.game.Arena;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.game.RotatingGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.screamingsandals.bedwars.api.events.BedwarsGameStartedEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.game.ItemSpawner;

@Service
public class DynamicSpawnerLimiterService
implements Listener {
    private final Map<Integer, Integer> diamondLimiter = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> emeraldLimiter = new HashMap<Integer, Integer>();

    @OnPostEnable
    public void onPostEnable() {
        SBA.getInstance().registerListener(this);
        this.diamondLimiter.put(1, SBAConfig.getInstance().node("upgrades", "limit", "Diamond-I").getInt(4));
        this.diamondLimiter.put(2, SBAConfig.getInstance().node("upgrades", "limit", "Diamond-II").getInt(6));
        this.diamondLimiter.put(3, SBAConfig.getInstance().node("upgrades", "limit", "Diamond-III").getInt(8));
        this.diamondLimiter.put(4, SBAConfig.getInstance().node("upgrades", "limit", "Diamond-IV").getInt(12));
        this.emeraldLimiter.put(1, SBAConfig.getInstance().node("upgrades", "limit", "Emerald-I").getInt(4));
        this.emeraldLimiter.put(2, SBAConfig.getInstance().node("upgrades", "limit", "Emerald-II").getInt(6));
        this.emeraldLimiter.put(3, SBAConfig.getInstance().node("upgrades", "limit", "Emerald-III").getInt(8));
        this.emeraldLimiter.put(4, SBAConfig.getInstance().node("upgrades", "limit", "Emerald-IV").getInt(12));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGameStart(BedwarsGameStartedEvent event) {
        Game game = event.getGame();
        this.setAccordingly(game, false);
        game.getItemSpawners().forEach(itemSpawner -> {
            if (Material.IRON_INGOT == itemSpawner.getItemSpawnerType().getMaterial()) {
                Reflect.setField(itemSpawner, "maxSpawnedResources", (Object)SBAConfig.getInstance().node("upgrades", "limit", "Iron").getInt(48));
            }
            if (Material.GOLD_INGOT == itemSpawner.getItemSpawnerType().getMaterial()) {
                Reflect.setField(itemSpawner, "maxSpawnedResources", (Object)SBAConfig.getInstance().node("upgrades", "limit", "Gold").getInt(8));
            }
        });
    }

    @EventHandler
    public void onSpawnerUpgrade(SBASpawnerTierUpgradeEvent event) {
        this.setAccordingly(event.getGame(), true);
    }

    private void setAccordingly(Game game, boolean isUpgraded) {
        IArena arena = ArenaManager.getInstance().get(game.getName()).orElseThrow();
        ((Arena)arena).getRotatingGenerators().stream().map(iRotatingGenerator -> (RotatingGenerator)iRotatingGenerator).filter(rotatingGenerator -> List.of(Material.DIAMOND_BLOCK, Material.EMERALD_BLOCK).contains(rotatingGenerator.getStack().getType())).forEach(generator -> {
            int limit = 4;
            switch (generator.getStack().getType()) {
                case EMERALD_BLOCK: {
                    limit = this.emeraldLimiter.getOrDefault(generator.getTierLevel(), 4);
                    break;
                }
                case DIAMOND_BLOCK: {
                    limit = this.diamondLimiter.getOrDefault(generator.getTierLevel(), 4);
                }
            }
            limit = isUpgraded ? limit + 1 : limit;
            ItemSpawner spawner = generator.getItemSpawner();
            Reflect.setField((Object)spawner, "maxSpawnedResources", (Object)limit);
        });
    }
}

