/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.service;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.event.EventManager;
import io.github.pronze.lib.screaminglib.npc.NPC;
import io.github.pronze.lib.screaminglib.npc.NPCManager;
import io.github.pronze.lib.screaminglib.npc.event.NPCInteractEvent;
import io.github.pronze.lib.screaminglib.npc.skin.NPCSkin;
import io.github.pronze.lib.screaminglib.plugin.ServiceManager;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.game.ArenaManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.events.BedwarsOpenShopEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStore;

@Service(dependsOn={NPCManager.class})
public class NPCStoreService
implements Listener {
    private final org.screamingsandals.bedwars.game.GameStore shopStore;
    private final org.screamingsandals.bedwars.game.GameStore upgradeStore;
    private NPCSkin shopSkin;
    private NPCSkin upgradeShopSkin;
    private final List<Component> shopText = new ArrayList<Component>();
    private final List<Component> upgradeShopText = new ArrayList<Component>();

    public static NPCStoreService getInstance() {
        return ServiceManager.get(NPCStoreService.class);
    }

    public NPCStoreService() {
        this.shopStore = new org.screamingsandals.bedwars.game.GameStore(null, "shop.yml", false, SBAConfig.getInstance().node("shop", "normal-shop", "name").getString(), false, false);
        this.upgradeStore = new org.screamingsandals.bedwars.game.GameStore(null, "upgradeShop.yml", false, SBAConfig.getInstance().node("shop", "upgrade-shop", "name").getString(), false, false);
        this.shopText.clear();
        this.shopText.addAll(Objects.requireNonNull(SBAConfig.getInstance().node("shop", "normal-shop", "entity-name").getList(String.class)).stream().map(AdventureHelper::toComponent).collect(Collectors.toList()));
        this.upgradeShopText.clear();
        this.upgradeShopText.addAll(Objects.requireNonNull(SBAConfig.getInstance().node("shop", "upgrade-shop", "entity-name").getList(String.class)).stream().map(AdventureHelper::toComponent).collect(Collectors.toList()));
    }

    @OnPostEnable
    public void onPostEnabled() {
        SBA.getInstance().registerListener(this);
        EventManager.getDefaultEventManager().register(NPCInteractEvent.class, this::onNPCTouched);
        this.shopSkin = new NPCSkin(SBAConfig.getInstance().node("shop", "normal-shop", "skin", "value").getString(), SBAConfig.getInstance().node("shop", "normal-shop", "skin", "signature").getString());
        this.upgradeShopSkin = new NPCSkin(SBAConfig.getInstance().node("shop", "upgrade-shop", "skin", "value").getString(), SBAConfig.getInstance().node("shop", "upgrade-shop", "skin", "signature").getString());
    }

    public void onNPCTouched(NPCInteractEvent event) {
        Player player = event.getPlayer().as(Player.class);
        if (!Main.getInstance().isPlayerPlayingAnyGame(player)) {
            return;
        }
        Game game = Main.getInstance().getGameOfPlayer(player);
        NPC npc = (NPC)event.getVisual();
        ArenaManager.getInstance().getArenaMap().values().stream().filter(iArena -> iArena.getStoreNPCS().contains(npc) || iArena.getUpgradeStoreNPCS().contains(npc)).forEach(arena -> {
            org.screamingsandals.bedwars.game.GameStore store = arena.getStoreNPCS().contains(npc) ? this.shopStore : this.upgradeStore;
            final BedwarsOpenShopEvent openShopEvent = new BedwarsOpenShopEvent(game, player, (GameStore)store, null);
            BukkitRunnable bukkitRunnable = new BukkitRunnable(){

                public void run() {
                    Bukkit.getServer().getPluginManager().callEvent((Event)openShopEvent);
                }
            };
            SBA.getInstance();
            bukkitRunnable.runTask((Plugin)SBA.getPluginInstance());
        });
    }

    public org.screamingsandals.bedwars.game.GameStore getShopStore() {
        return this.shopStore;
    }

    public org.screamingsandals.bedwars.game.GameStore getUpgradeStore() {
        return this.upgradeStore;
    }

    public NPCSkin getShopSkin() {
        return this.shopSkin;
    }

    public NPCSkin getUpgradeShopSkin() {
        return this.upgradeShopSkin;
    }

    public List<Component> getShopText() {
        return this.shopText;
    }

    public List<Component> getUpgradeShopText() {
        return this.upgradeShopText;
    }
}

