/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.specials.listener;

import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.specials.runners.BridgeEggRunnable;
import io.github.pronze.sba.utils.SBAUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.APIUtils;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.events.BedwarsApplyPropertyToBoughtItem;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.GamePlayer;

@Service
public class BridgeEggListener
implements Listener {
    private static final String BRIDGE_EGG_PREFIX = "Module:BridgeEgg:";
    private final Map<Egg, BridgeEggRunnable> bridgeTasks = new HashMap<Egg, BridgeEggRunnable>();

    @OnPostEnable
    public void onPostEnable() {
        SBA.getInstance().registerListener(this);
    }

    @EventHandler
    public void onEggRegistration(BedwarsApplyPropertyToBoughtItem event) {
        if (event.getPropertyName().equalsIgnoreCase("bridgeegg")) {
            ItemStack stack = event.getStack();
            APIUtils.hashIntoInvisibleString((ItemStack)stack, (String)this.applyProperty(event));
        }
    }

    @EventHandler
    public void onEggUse(PlayerInteractEvent event) {
        ItemStack stack;
        String unhidden;
        Player player = event.getPlayer();
        if (!Main.isPlayerInGame((Player)player)) {
            return;
        }
        GamePlayer gamePlayer = Main.getPlayerGameProfile((Player)player);
        org.screamingsandals.bedwars.game.Game game = gamePlayer.getGame();
        if (!(event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK || game.getStatus() != GameStatus.RUNNING || gamePlayer.isSpectator || event.getItem() == null || (unhidden = APIUtils.unhashFromInvisibleStringStartsWith((ItemStack)(stack = event.getItem()), (String)BRIDGE_EGG_PREFIX)) == null)) {
            event.setCancelled(true);
            stack.setAmount(stack.getAmount() - 1);
            player.updateInventory();
            Egg egg = (Egg)player.launchProjectile(Egg.class);
            RunningTeam playerTeam = game.getTeamOfPlayer(player);
            this.bridgeTasks.put(egg, new BridgeEggRunnable(egg, playerTeam, player, (Game)game));
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (!(event.getEntity() instanceof Egg)) {
            return;
        }
        Egg egg = (Egg)event.getEntity();
        if (this.bridgeTasks.containsKey(egg)) {
            egg.remove();
            SBAUtil.cancelTask(this.bridgeTasks.get(egg).getTask());
            this.bridgeTasks.remove(egg);
        }
    }

    private String applyProperty(BedwarsApplyPropertyToBoughtItem event) {
        return BRIDGE_EGG_PREFIX;
    }
}

