/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.utils;

import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.bukkit.plugin.java.JavaPlugin;

@Service
public class Logger {
    private static Logger instance;
    private Level level;
    private java.util.logging.Logger logger;
    private boolean testMode;

    public static void mockMode() {
        instance = new Logger();
        Logger.instance.testMode = true;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static void init(JavaPlugin plugin) {
        instance = new Logger();
        Logger.instance.level = Level.ALL;
        Logger.instance.logger = plugin.getLogger();
    }

    protected static void mockDebug(String message, Object ... params) {
        System.out.println(Logger.getMessage(message, params));
    }

    public static void trace(@NonNull String message, Object ... params) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (Logger.instance.testMode) {
            Logger.mockDebug(message, params);
            return;
        }
        if (Logger.instance.level.getLevel() >= Level.TRACE.getLevel()) {
            Logger.instance.logger.info(Logger.getMessage(message, params));
        }
    }

    public static void warn(@NonNull String message, Object ... params) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (Logger.instance.testMode) {
            Logger.mockDebug(message, params);
            return;
        }
        if (Logger.instance.level.getLevel() >= Level.WARNING.getLevel()) {
            Logger.instance.logger.warning(Logger.getMessage(message, params));
        }
    }

    public static void error(@NonNull String message, Object ... params) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (Logger.instance.testMode) {
            Logger.mockDebug(message, params);
            return;
        }
        if (Logger.instance.level.getLevel() >= Level.ERROR.getLevel()) {
            Logger.instance.logger.warning(Logger.getMessage(message, params));
        }
    }

    private static String getMessage(String message, Object ... params) {
        for (Object param : params) {
            if (param == null) {
                param = "NULL";
            }
            if (!(param instanceof String)) {
                param = param.toString();
            }
            message = message.replaceFirst(Pattern.quote("{}"), Matcher.quoteReplacement((String)param));
        }
        return message;
    }

    public static void setMode(Level level) {
        if (instance != null) {
            Logger.instance.level = level;
        }
    }

    public static enum Level {
        DISABLED(0),
        TRACE(1),
        WARNING(2),
        ERROR(3),
        ALL(4);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

