/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.utils;

import io.github.pronze.lib.kyori.adventure.title.Title;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.Logger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class SBAUtil {
    private static final BlockFace[] axis = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    private static final BlockFace[] radial = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};

    public static List<Material> parseMaterialFromConfig(String key) {
        ArrayList<Material> materialList = new ArrayList<Material>();
        List<String> materialNames = SBAConfig.getInstance().getStringList(key);
        materialNames.stream().filter(mat -> mat != null && !mat.isEmpty()).forEach(material -> {
            try {
                Material mat = Material.valueOf((String)material.toUpperCase().replace(" ", "_"));
                materialList.add(mat);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        return materialList;
    }

    public static Optional<Location> readLocationFromConfig(String section) {
        try {
            return Optional.of(new Location(Bukkit.getWorld((String)Objects.requireNonNull(SBAConfig.getInstance().getString(section + ".world"))), SBAConfig.getInstance().getDouble(section + ".x", 0.0), SBAConfig.getInstance().getDouble(section + ".y", 0.0), SBAConfig.getInstance().getDouble(section + ".z", 0.0), (float)SBAConfig.getInstance().getDouble(section + ".yaw", 0.0), (float)SBAConfig.getInstance().getDouble(section + ".pitch", 0.0)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static void cancelTask(BukkitTask task) {
        if (task != null && (Bukkit.getScheduler().isCurrentlyRunning(task.getTaskId()) || Bukkit.getScheduler().isQueued(task.getTaskId()))) {
            task.cancel();
            Logger.trace("cancelTask {}", task);
        }
    }

    public static List<String> translateColors(List<String> toTranslate) {
        return toTranslate.stream().map(string -> ChatColor.translateAlternateColorCodes((char)'&', (String)string)).collect(Collectors.toList());
    }

    public static String translateColors(String toTranslate) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)toTranslate);
    }

    public static Optional<Player> getPlayer(UUID uuid) {
        return Optional.ofNullable(Bukkit.getPlayer((UUID)uuid));
    }

    public static void disablePlugin(@NotNull JavaPlugin plugin) {
        try {
            String message = String.format("Disabling %s", plugin.getDescription().getFullName());
            plugin.getLogger().info(message);
            Bukkit.getPluginManager().callEvent((Event)new PluginDisableEvent((Plugin)plugin));
            Reflect.setField((Object)plugin, "isEnabled", (Object)false);
        }
        catch (Throwable ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while disabling " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
        }
        try {
            Bukkit.getScheduler().cancelTasks((Plugin)plugin);
        }
        catch (Throwable ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while cancelling tasks for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
        }
        try {
            ArrayList handlers = HandlerList.getRegisteredListeners((Plugin)plugin);
            Logger.trace("-----------------------{}-----------------", handlers.size());
            for (RegisteredListener handler : handlers) {
                if (handler.getListener().toString().contains("io.github.pronze.sba") || handler.getListener().toString().contains("io.github.pronze.lib.screaming") || handler.getListener().toString().contains("io.github.pronze.lib.simpleinventories") || handler.getListener().toString().contains("org.screamingsandals.bedwars.lib.sgui") || handler.getListener().toString().contains("io.github.pronze.lib.bedwars")) {
                    HandlerList.unregisterAll((Listener)handler.getListener());
                }
                Logger.trace("handler {}", handler.getListener().toString());
            }
            Logger.trace("-----------------------{}-----------------", handlers.size());
        }
        catch (Throwable ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while unregistering events for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
        }
        try {
            Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)plugin);
            Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)plugin);
        }
        catch (Throwable ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while unregistering plugin channels for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
        }
        try {
            for (World world : Bukkit.getWorlds()) {
                world.removePluginChunkTickets((Plugin)plugin);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void reloadPlugin(@NonNull JavaPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        SBAUtil.disablePlugin(plugin);
        Bukkit.getServer().getPluginManager().enablePlugin((Plugin)plugin);
        if (plugin == SBA.getPluginInstance()) {
            SBAConfig.getInstance().forceReload();
            LanguageService.getInstance().load(plugin);
        }
        Bukkit.getLogger().info("Plugin reloaded! Keep in mind that restarting the server is safer!");
    }

    public static void sendTitle(PlayerWrapper player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        Title titleComponent = Title.title(AdventureHelper.toComponent(title), AdventureHelper.toComponent(subtitle), Title.Times.of(Duration.ofMillis((long)fadeIn * 50L), Duration.ofMillis((long)stay * 50L), Duration.ofMillis((long)fadeOut * 50L)));
        player.showTitle(titleComponent);
    }

    public static String capitalizeFirstLetter(@NotNull String toCap) {
        return toCap.substring(0, 1).toUpperCase() + toCap.substring(1).toLowerCase();
    }

    public static BlockFace yawToFace(float yaw, boolean useSubCardinalDirections) {
        if (useSubCardinalDirections) {
            return radial[Math.round(yaw / 45.0f) & 7].getOppositeFace();
        }
        return axis[Math.round(yaw / 90.0f) & 3].getOppositeFace();
    }
}

