/*
 * Decompiled with CFR 0.152.
 */
package com.iamceph.resulter.core;

import com.iamceph.resulter.core.Resultable;
import com.iamceph.resulter.core.model.Resulters;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

public interface DataResultable<T>
extends Resultable {
    public static <T> DataResultable<T> ok(@NotNull T data) {
        return Resulters.dataResulter().ok(data);
    }

    public static <T> DataResultable<T> ok(@NotNull T data, @NotNull String message) {
        return Resulters.dataResulter().ok(data, message);
    }

    public static <T> DataResultable<T> fail(@NotNull String message) {
        return Resulters.dataResulter().fail(message);
    }

    public static <T> DataResultable<T> fail(@NotNull Throwable throwable) {
        return Resulters.dataResulter().fail(throwable);
    }

    public static <T> DataResultable<T> fail(@NotNull T data, @NotNull String message) {
        return Resulters.dataResulter().fail(data, message);
    }

    public static <T> DataResultable<T> fail(@NotNull T data, @NotNull String message, @NotNull Throwable throwable) {
        return Resulters.dataResulter().fail(data, message, throwable);
    }

    public static <T> DataResultable<T> fail(@Nullable String message, @NotNull Throwable throwable) {
        return Resulters.dataResulter().fail(message, throwable);
    }

    public static <T> DataResultable<T> warning(@NotNull String message) {
        return Resulters.dataResulter().warning(message);
    }

    public static <T> DataResultable<T> warning(@NotNull Throwable throwable) {
        return Resulters.dataResulter().warning(throwable);
    }

    public static <T> DataResultable<T> warning(@NotNull T data, @NotNull String message) {
        return Resulters.dataResulter().warning(data, message);
    }

    public static <T> DataResultable<T> warning(@NotNull T data, @NotNull String message, @NotNull Throwable throwable) {
        return Resulters.dataResulter().warning(data, message, throwable);
    }

    public static <T> DataResultable<T> warning(@NotNull String message, @NotNull Throwable throwable) {
        return Resulters.dataResulter().warning(message, throwable);
    }

    public static <T> DataResultable<T> failIfNull(@Nullable T data) {
        return DataResultable.failIfNull(data, "No data provided.");
    }

    public static <T> DataResultable<T> failIfNull(@Nullable T data, @NotNull String failMessage) {
        if (data == null) {
            return DataResultable.fail(failMessage);
        }
        return DataResultable.ok(data);
    }

    public static <T> Mono<DataResultable<T>> mono(@NotNull Mono<T> input) {
        return DataResultable.mono(() -> input);
    }

    public static <T> Mono<DataResultable<T>> mono(@NotNull Supplier<Mono<T>> input) {
        return Mono.defer(input).map(DataResultable::ok).onErrorResume(ex -> Mono.just(DataResultable.fail(ex))).switchIfEmpty(Mono.just(DataResultable.fail("Mono ended empty.")));
    }

    public static <T> DataResultable<T> from(Object input, T data) {
        Resultable result = Resulters.resulter().convert(input);
        return result.transform(data);
    }

    public static <T> DataResultable<T> fromOptional(Optional<T> input) {
        if (input.isPresent()) {
            return DataResultable.ok(input.get());
        }
        return DataResultable.fail("No data present.");
    }

    default public DataResultable<T> filter(Predicate<T> predicate, String errorMessage) {
        if (this.isFail()) {
            return this;
        }
        try {
            if (!predicate.test(this.data())) {
                return DataResultable.fail(errorMessage);
            }
        }
        catch (Throwable t) {
            return DataResultable.fail("filter() failed because of Throwable.", t);
        }
        return this;
    }

    default public DataResultable<T> filter(Predicate<T> predicate) {
        return this.filter(predicate, "No data found.");
    }

    default public DataResultable<T> orElse(Supplier<T> data) {
        if (this.isFail() || !this.hasData()) {
            return DataResultable.ok(data.get());
        }
        return this;
    }

    default public DataResultable<T> orElse(T data) {
        return this.orElse((T)((Supplier<Object>)() -> data));
    }

    default public DataResultable<T> ifOk(Consumer<T> provider) {
        if (this.isOk() && this.hasData()) {
            provider.accept(this.data());
        }
        return this;
    }

    default public DataResultable<T> ifOk(Consumer<T> provider, Consumer<Resultable> fallback) {
        if (this.isOk() && this.hasData()) {
            provider.accept(this.data());
            return this;
        }
        fallback.accept(this);
        return this;
    }

    default public <K> DataResultable<K> map(Function<T, K> mapper) {
        if (this.isFail()) {
            return this.transform();
        }
        try {
            return Resulters.dataResulter().ok(mapper.apply(this.data()), this.message());
        }
        catch (Throwable t) {
            return DataResultable.fail("map() failed because of Throwable.", t);
        }
    }

    default public <K> DataResultable<K> flatMap(Function<T, DataResultable<K>> mapper) {
        if (this.isFail()) {
            return this.transform();
        }
        try {
            return mapper.apply(this.data());
        }
        catch (Throwable t) {
            return DataResultable.fail("flatMap() failed because of Throwable.", t);
        }
    }

    default public Optional<T> asOptional() {
        return Optional.ofNullable(this.data());
    }

    public boolean hasData();

    public T data();
}

