/*
 * Decompiled with CFR 0.152.
 */
package com.iamceph.resulter.core;

import com.iamceph.resulter.core.GroupedResultable;
import com.iamceph.resulter.core.Resultable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

final class GroupedResultableBuilder
implements GroupedResultable.Builder {
    private final List<Resultable> resultables;

    public GroupedResultableBuilder() {
        this.resultables = new CopyOnWriteArrayList<Resultable>();
    }

    public GroupedResultableBuilder(List<Resultable> from) {
        this.resultables = new CopyOnWriteArrayList<Resultable>(from);
    }

    @Override
    public GroupedResultable.Builder with(Resultable ... resultable) {
        this.resultables.addAll(Arrays.asList(resultable));
        return this;
    }

    @Override
    public GroupedResultable.Builder with(Collection<Resultable> resultable) {
        this.resultables.addAll(resultable);
        return this;
    }

    @Override
    public GroupedResultable build() {
        return GroupedResultable.of(this.resultables);
    }
}

