/*
 * Decompiled with CFR 0.152.
 */
package com.iamceph.resulter.core;

import com.iamceph.resulter.core.DataResultable;
import com.iamceph.resulter.core.api.ResultStatus;
import com.iamceph.resulter.core.model.ProtoResultable;
import com.iamceph.resulter.core.model.Resulters;
import java.io.Serializable;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

public interface Resultable
extends Serializable,
Cloneable {
    public static Resultable ok() {
        return Resulters.resulter().ok();
    }

    public static Resultable ok(@NotNull String message) {
        return Resulters.resulter().ok(message);
    }

    public static Resultable fail(@NotNull String message) {
        return Resulters.resulter().fail(message);
    }

    public static Resultable fail(@NotNull String message, @NotNull Throwable throwable) {
        return Resulters.resulter().fail(message, throwable);
    }

    public static Resultable fail(@NotNull Throwable throwable) {
        return Resulters.resulter().fail(throwable);
    }

    public static Resultable warning(@NotNull String message) {
        return Resulters.resulter().warning(message);
    }

    public static Resultable warning(@NotNull String message, @NotNull Throwable throwable) {
        return Resulters.resulter().warning(message, throwable);
    }

    public static Resultable warning(@NotNull Throwable throwable) {
        return Resulters.resulter().warning(throwable);
    }

    public static Mono<Resultable> mono(@NotNull Mono<?> input) {
        return Resultable.mono(() -> input);
    }

    public static Mono<Resultable> mono(@NotNull Supplier<Mono<?>> input) {
        return Mono.defer(input).map(next -> Resultable.ok()).onErrorResume(t -> Mono.just((Object)Resultable.fail(t))).switchIfEmpty(Mono.just((Object)Resultable.fail("Mono ended empty.")));
    }

    public static Resultable from(ResultStatus status, String message, Throwable throwable) {
        return Resulters.resulter().from(status, message, throwable);
    }

    public static Resultable convert(Object input) {
        return Resulters.resulter().convert(input);
    }

    default public <T> DataResultable<T> transform(@Nullable T data) {
        if (data == null && this.isOk()) {
            return DataResultable.fail("No data provided.");
        }
        switch (this.status()) {
            case OK: {
                return Resulters.dataResulter().ok(data, this.message());
            }
            case WARNING: {
                return Resulters.dataResulter().warning(data, this.message(), this.error());
            }
        }
        return Resulters.dataResulter().fail(data, this.message(), this.error());
    }

    default public <T> DataResultable<T> transform() {
        if (this instanceof DataResultable) {
            try {
                return (DataResultable)this;
            }
            catch (Exception t) {
                return DataResultable.fail("transform() failed because of Throwable.", t);
            }
        }
        return this.transform(null);
    }

    @ApiStatus.Internal
    default public String getMessage() {
        return this.message();
    }

    @NotNull
    public ResultStatus status();

    @NotNull
    public String message();

    @Nullable
    public Throwable error();

    public boolean isOk();

    public boolean isFail();

    public boolean isWarning();

    public Convertor convertor();

    public static interface Convertor {
        public String json();

        public <K> K convert(Class<K> var1);

        default public ProtoResultable grpc() {
            return this.convert(ProtoResultable.class);
        }
    }
}

