/*
 * Decompiled with CFR 0.152.
 */
package com.iamceph.resulter.core.extension;

import com.iamceph.resulter.core.Resultable;
import com.iamceph.resulter.core.api.ResultStatus;
import com.iamceph.resulter.core.extension.ConvertorExtension;
import com.iamceph.resulter.core.model.ProtoResultable;
import com.iamceph.resulter.core.model.ProtoThrowable;
import com.iamceph.resulter.core.model.Resulters;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ConvertorExtensionImpl
implements ConvertorExtension {
    private static final ConvertorExtension INSTANCE = new ConvertorExtensionImpl();

    protected ConvertorExtensionImpl() {
    }

    public static ConvertorExtension get() {
        return INSTANCE;
    }

    @Override
    public Resultable convert(Object input) {
        if (input instanceof ProtoResultable) {
            ProtoResultable casted = (ProtoResultable)input;
            String message = casted.getMessage();
            ResultStatus status = ResultStatus.fromNumber(casted.getStatus().getNumber());
            ProtoThrowable error = casted.getError();
            if (!error.equals(ProtoThrowable.getDefaultInstance())) {
                Throwable buildError = new Throwable(error.getErrorMessage());
                buildError.setStackTrace(this.toStackTrace(error.getStackTraceList()).toArray(new StackTraceElement[0]));
                return Resulters.resulter().from(status, message, buildError);
            }
            return Resulters.resulter().from(status, message, null);
        }
        return Resultable.fail("Cannot convert input[" + input.getClass().getSimpleName() + "] to Resultable!");
    }

    @Override
    public <T> T convert(Resultable resultable, Class<T> target) {
        if (target.isAssignableFrom(ProtoResultable.class)) {
            ProtoResultable.Builder message = ProtoResultable.newBuilder();
            Throwable error = resultable.error();
            if (error != null) {
                message.setError(ProtoThrowable.newBuilder().setErrorMessage(error.getMessage()).addAllStackTrace(this.fromStackTrace(Arrays.asList(error.getStackTrace()))).build()).build();
            }
            message.setMessage(resultable.message());
            message.setStatus(ProtoResultable.Status.forNumber(resultable.status().getNumberValue()));
            return (T)message.build();
        }
        if (target.isAssignableFrom(String.class)) {
            return (T)this.json(resultable);
        }
        throw new UnsupportedOperationException("Cannot convert Resultable to [" + target.getSimpleName() + "]!");
    }

    @Override
    public String json(Resultable resultable) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private List<ProtoThrowable.ProtoStackTrace> fromStackTrace(List<StackTraceElement> elements) {
        return elements.stream().map(next -> ProtoThrowable.ProtoStackTrace.newBuilder().setDeclaringClass(next.getClassName()).setMethodName(next.getMethodName()).setFileName(next.getFileName()).setLineNumber(next.getLineNumber()).build()).collect(Collectors.toList());
    }

    private List<StackTraceElement> toStackTrace(List<ProtoThrowable.ProtoStackTrace> elements) {
        return elements.stream().map(next -> new StackTraceElement(next.getDeclaringClass(), next.getMethodName(), next.getFileName(), next.getLineNumber())).collect(Collectors.toList());
    }
}

