/*
 * Decompiled with CFR 0.152.
 */
package com.iamceph.resulter.core.model;

import com.iamceph.resulter.core.DataResultable;
import com.iamceph.resulter.core.api.ResultStatus;
import com.iamceph.resulter.core.model.ResultableImpl;

final class DataResultableImpl<T>
extends ResultableImpl
implements DataResultable<T> {
    private final T data;

    DataResultableImpl(ResultStatus status, String message, Throwable error, T data) {
        super(status, message, error);
        this.data = data;
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    public boolean isOk() {
        return this.status == ResultStatus.OK && this.hasData();
    }

    @Override
    public boolean isFail() {
        return this.status == ResultStatus.FAIL;
    }

    @Override
    public boolean isWarning() {
        return this.status == ResultStatus.WARNING;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataResultableImpl)) {
            return false;
        }
        DataResultableImpl other = (DataResultableImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$data = this.data();
        T other$data = other.data();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DataResultableImpl;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $data = this.data();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    @Override
    public T data() {
        return this.data;
    }

    @Override
    public String toString() {
        return "DataResultableImpl(super=" + super.toString() + ", data=" + this.data() + ")";
    }
}

