/*
 * Decompiled with CFR 0.152.
 */
package com.iamceph.resulter.core.model;

import com.iamceph.resulter.core.GroupedResultable;
import com.iamceph.resulter.core.Resultable;
import com.iamceph.resulter.core.api.GroupedThrowable;
import com.iamceph.resulter.core.api.ResultStatus;
import com.iamceph.resulter.core.model.Resulters;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GroupedResulImpl
implements GroupedResultable {
    private final List<Resultable> resultables;
    private final Long failResultables;
    private final Long warningResultables;

    GroupedResulImpl(Collection<Resultable> resultables) {
        this.resultables = new LinkedList<Resultable>(resultables);
        this.failResultables = this.resultables.stream().filter(result -> result.status() == ResultStatus.FAIL).count();
        this.warningResultables = this.resultables.stream().filter(result -> result.status() == ResultStatus.WARNING).count();
    }

    @Override
    @NotNull
    public String message() {
        return this.toLineMessage();
    }

    @Override
    @Nullable
    public GroupedThrowable error() {
        if (this.failResultables == 0L && this.warningResultables == 0L) {
            return null;
        }
        return new GroupedThrowable(this.resultables.stream().filter(next -> !next.isOk()).map(Resultable::error).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public GroupedResultable merge(Resultable ... resultables) {
        return this.merge(Arrays.stream(resultables).collect(Collectors.toList()));
    }

    @Override
    public GroupedResultable merge(Collection<Resultable> resultables) {
        return new GroupedResulImpl(Stream.concat(resultables.stream(), this.resultables.stream()).collect(Collectors.toList()));
    }

    @Override
    public List<String> messages() {
        return this.resultables.stream().map(Resultable::message).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public ResultStatus status() {
        if (this.failResultables == 0L && this.warningResultables == 0L) {
            return ResultStatus.OK;
        }
        if (this.failResultables > 0L) {
            return ResultStatus.FAIL;
        }
        return ResultStatus.WARNING;
    }

    @Override
    public boolean isOk() {
        return this.status() == ResultStatus.OK;
    }

    @Override
    public boolean isFail() {
        return this.status() == ResultStatus.FAIL;
    }

    @Override
    public boolean isWarning() {
        return this.status() == ResultStatus.WARNING;
    }

    @Override
    public Resultable.Convertor convertor() {
        return new Resultable.Convertor(){

            @Override
            public String json() {
                return Resulters.convertor().json(GroupedResulImpl.this);
            }

            @Override
            public <K> K convert(Class<K> target) {
                return Resulters.convertor().convert(GroupedResulImpl.this, target);
            }
        };
    }

    @Override
    public List<Resultable> resultables() {
        return Collections.unmodifiableList(this.resultables);
    }

    private String toLineMessage() {
        StringBuilder builder = new StringBuilder();
        this.resultables.forEach(result -> {
            if (result.isFail()) {
                builder.append(result.message());
                builder.append(System.getProperty("line.separator"));
            }
        });
        return builder.toString();
    }
}

