/*
 * Decompiled with CFR 0.152.
 */
package com.iamceph.resulter.core.pack;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.iamceph.resulter.core.DataResultable;
import com.iamceph.resulter.core.Resultable;
import com.iamceph.resulter.core.model.ResultableData;
import com.iamceph.resulter.core.pack.ProtoWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Packeto {
    @NotNull
    public static ResultableData pack(@NotNull DataResultable<?> input) {
        if (input.isFail()) {
            return ResultableData.newBuilder().setResult(input.convertor().grpc()).build();
        }
        Object data = input.data();
        if (data instanceof ProtoWrapper) {
            ProtoWrapper wrapped = (ProtoWrapper)data;
            Object message = wrapped.asProto();
            if (message instanceof Message) {
                return ResultableData.newBuilder().setResult(input.convertor().grpc()).setData(Any.pack((Message)((Message)message))).build();
            }
            return ResultableData.newBuilder().setResult(DataResultable.fail("Cannot convert data - not proto message - " + data.getClass().getSimpleName()).convertor().grpc()).build();
        }
        return ResultableData.newBuilder().setResult(DataResultable.fail("Cannot convert data - " + data.getClass().getSimpleName()).convertor().grpc()).build();
    }

    @NotNull
    public static <K extends Message> DataResultable<K> unpack(@NotNull ResultableData input, @NotNull Class<K> type) {
        Resultable result = Resultable.convert(input.getResult());
        if (result.isFail()) {
            return result.transform();
        }
        return Packeto.unpack(input.getData(), type);
    }

    @NotNull
    public static <K extends Message> DataResultable<K> unpack(@NotNull Any input, @NotNull Class<K> type) {
        try {
            return DataResultable.failIfNull(input.unpack(type));
        }
        catch (Exception e) {
            return DataResultable.fail(e);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static <K extends Message> K unpackUnsafe(@NotNull Any input, @NotNull Class<K> type) {
        try {
            return (K)input.unpack(type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Packeto() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

