/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.cloud.annotations;

import io.github.pronze.lib.cloud.ArgumentDescription;
import io.github.pronze.lib.cloud.CommandManager;
import io.github.pronze.lib.cloud.annotations.Flag;
import io.github.pronze.lib.cloud.arguments.CommandArgument;
import io.github.pronze.lib.cloud.arguments.flags.CommandFlag;
import io.github.pronze.lib.cloud.arguments.parser.ArgumentParser;
import io.github.pronze.lib.cloud.arguments.parser.ParserRegistry;
import io.github.pronze.lib.cloud.permission.Permission;
import io.leangen.geantyref.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

final class FlagExtractor
implements Function<Method, Collection<CommandFlag<?>>> {
    private final CommandManager<?> commandManager;

    FlagExtractor(@NonNull CommandManager<?> commandManager) {
        this.commandManager = commandManager;
    }

    @Override
    public @NonNull Collection<@NonNull CommandFlag<?>> apply(@NonNull Method method) {
        LinkedList flags = new LinkedList();
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.isAnnotationPresent(Flag.class)) continue;
            Flag flag = parameter.getAnnotation(Flag.class);
            CommandFlag.Builder<Void> builder = this.commandManager.flagBuilder(flag.value()).withDescription(ArgumentDescription.of(flag.description())).withAliases(flag.aliases()).withPermission(Permission.of(flag.permission()));
            if (parameter.getType().equals(Boolean.TYPE)) {
                flags.add(builder.build());
                continue;
            }
            TypeToken<?> token = TypeToken.get(parameter.getType());
            List<Annotation> annotations = Arrays.asList(parameter.getAnnotations());
            ParserRegistry<?> registry = this.commandManager.getParserRegistry();
            ArgumentParser parser = flag.parserName().isEmpty() ? (ArgumentParser)registry.createParser(token, registry.parseAnnotations(token, annotations)).orElse(null) : (ArgumentParser)registry.createParser(flag.parserName(), registry.parseAnnotations(token, annotations)).orElse(null);
            if (parser == null) {
                throw new IllegalArgumentException(String.format("Cannot find parser for type '%s' for flag '%s' in method '%s'", parameter.getType().getCanonicalName(), flag.value(), method.getName()));
            }
            BiFunction suggestionProvider = !flag.suggestions().isEmpty() ? (BiFunction)registry.getSuggestionProvider(flag.suggestions()).orElse(null) : null;
            CommandArgument.Builder argumentBuilder0 = CommandArgument.ofType(parameter.getType(), flag.value());
            CommandArgument.Builder argumentBuilder = argumentBuilder0.asRequired().manager(this.commandManager).withParser(parser);
            CommandArgument argument = suggestionProvider != null ? argumentBuilder.withSuggestionsProvider(suggestionProvider).build() : argumentBuilder.build();
            flags.add(builder.withArgument(argument).build());
        }
        return flags;
    }
}

