/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.cloud.arguments;

import io.github.pronze.lib.cloud.arguments.CommandArgument;
import io.github.pronze.lib.cloud.arguments.parser.ArgumentParseResult;
import io.github.pronze.lib.cloud.arguments.parser.ArgumentParser;
import io.github.pronze.lib.cloud.context.CommandContext;
import io.github.pronze.lib.cloud.exceptions.parsing.NoInputProvidedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class StaticArgument<C>
extends CommandArgument<C, String> {
    private StaticArgument(boolean required, @NonNull String name, String ... aliases) {
        super(required, name, new StaticArgumentParser(name, aliases), String.class);
    }

    public static <C> @NonNull StaticArgument<C> of(@NonNull String name, String ... aliases) {
        return new StaticArgument<C>(true, name, aliases);
    }

    public void registerAlias(@NonNull String alias) {
        ((StaticArgumentParser)this.getParser()).insertAlias(alias);
    }

    public @NonNull Set<@NonNull String> getAliases() {
        return Collections.unmodifiableSet(((StaticArgumentParser)this.getParser()).getAcceptedStrings());
    }

    public @NonNull List<@NonNull String> getAlternativeAliases() {
        return Collections.unmodifiableList(new ArrayList(((StaticArgumentParser)this.getParser()).alternativeAliases));
    }

    private static final class StaticArgumentParser<C>
    implements ArgumentParser<C, String> {
        private final Set<String> allAcceptedAliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        private final Set<String> alternativeAliases = new HashSet<String>();
        private final String name;

        private StaticArgumentParser(@NonNull String name, String ... aliases) {
            this.name = name;
            this.allAcceptedAliases.add(this.name);
            this.allAcceptedAliases.addAll(Arrays.asList(aliases));
            this.alternativeAliases.addAll(Arrays.asList(aliases));
        }

        @Override
        public @NonNull ArgumentParseResult<String> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String string = inputQueue.peek();
            if (string == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(StaticArgumentParser.class, commandContext));
            }
            if (this.allAcceptedAliases.contains(string)) {
                inputQueue.remove();
                return ArgumentParseResult.success(this.name);
            }
            return ArgumentParseResult.failure(new IllegalArgumentException(string));
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return Collections.singletonList(this.name);
        }

        public @NonNull Set<@NonNull String> getAcceptedStrings() {
            return this.allAcceptedAliases;
        }

        public void insertAlias(@NonNull String alias) {
            this.allAcceptedAliases.add(alias);
            this.alternativeAliases.add(alias);
        }
    }
}

