/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.cloud.arguments.parser;

import io.github.pronze.lib.cloud.arguments.parser.ArgumentParseResult;
import io.github.pronze.lib.cloud.arguments.parser.MappedArgumentParser;
import io.github.pronze.lib.cloud.context.CommandContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
public interface ArgumentParser<C, T> {
    public static final int DEFAULT_ARGUMENT_COUNT = 1;

    public @NonNull ArgumentParseResult<@NonNull T> parse(@NonNull CommandContext<@NonNull C> var1, @NonNull Queue<@NonNull String> var2);

    default public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
        return Collections.emptyList();
    }

    default public <O> @NonNull ArgumentParser<C, O> map(BiFunction<CommandContext<C>, T, ArgumentParseResult<O>> mapper) {
        return new MappedArgumentParser<C, T, O>(this, Objects.requireNonNull(mapper, "mapper"));
    }

    default public boolean isContextFree() {
        return false;
    }

    default public int getRequestedArgumentCount() {
        return 1;
    }
}

