/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.cloud.bukkit;

import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.pronze.lib.cloud.Command;
import io.github.pronze.lib.cloud.brigadier.CloudBrigadierManager;
import io.github.pronze.lib.cloud.bukkit.BukkitBrigadierMapper;
import io.github.pronze.lib.cloud.bukkit.BukkitCommand;
import io.github.pronze.lib.cloud.bukkit.BukkitCommandManager;
import io.github.pronze.lib.cloud.bukkit.BukkitPluginRegistrationHandler;
import io.github.pronze.lib.cloud.bukkit.internal.BukkitBackwardsBrigadierSenderMapper;
import io.github.pronze.lib.cloud.context.CommandContext;
import io.github.pronze.lib.cloud.permission.CommandPermission;
import io.github.pronze.lib.commodore.Commodore;
import io.github.pronze.lib.commodore.CommodoreProvider;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class CloudCommodoreManager<C>
extends BukkitPluginRegistrationHandler<C> {
    private final BukkitCommandManager<C> commandManager;
    private final CloudBrigadierManager<C, Object> brigadierManager;
    private final Commodore commodore;

    CloudCommodoreManager(@NonNull BukkitCommandManager<C> commandManager) throws BukkitCommandManager.BrigadierFailureException {
        if (!CommodoreProvider.isSupported()) {
            throw new BukkitCommandManager.BrigadierFailureException(BukkitCommandManager.BrigadierFailureReason.COMMODORE_NOT_PRESENT);
        }
        this.commandManager = commandManager;
        this.commodore = CommodoreProvider.getCommodore(commandManager.getOwningPlugin());
        this.brigadierManager = new CloudBrigadierManager(commandManager, () -> new CommandContext(commandManager.getCommandSenderMapper().apply((CommandSender)Bukkit.getConsoleSender()), commandManager));
        this.brigadierManager.brigadierSenderMapper(sender -> this.commandManager.getCommandSenderMapper().apply(this.commodore.getBukkitSender(sender)));
        new BukkitBrigadierMapper<C>(this.commandManager, this.brigadierManager);
        this.brigadierManager.backwardsBrigadierSenderMapper(new BukkitBackwardsBrigadierSenderMapper(this.commandManager));
    }

    @Override
    protected void registerExternal(@NonNull String label, @NonNull Command<?> command, @NonNull BukkitCommand<C> bukkitCommand) {
        this.registerWithCommodore(label, command);
    }

    protected @NonNull CloudBrigadierManager brigadierManager() {
        return this.brigadierManager;
    }

    private void registerWithCommodore(@NonNull String label, @NonNull Command<C> command) {
        LiteralCommandNode<Object> literalCommandNode = this.brigadierManager.createLiteralCommandNode(label, command, (o, p) -> {
            CommandSender sender = this.commodore.getBukkitSender(o);
            return this.commandManager.hasPermission(this.commandManager.getCommandSenderMapper().apply(sender), (CommandPermission)p);
        }, false, (com.mojang.brigadier.Command<Object>)((com.mojang.brigadier.Command)o -> 1));
        CommandNode existingNode = this.commodore.getDispatcher().findNode(Collections.singletonList(label));
        if (existingNode != null) {
            this.mergeChildren((CommandNode<?>)existingNode, (CommandNode<?>)literalCommandNode);
        } else {
            this.commodore.register(literalCommandNode);
        }
    }

    private void mergeChildren(@Nullable CommandNode<?> existingNode, @Nullable CommandNode<?> node) {
        for (CommandNode child : node.getChildren()) {
            CommandNode existingChild = existingNode.getChild(child.getName());
            if (existingChild == null) {
                existingNode.addChild(child);
                continue;
            }
            this.mergeChildren(existingChild, child);
        }
    }
}

