/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.cloud.bukkit.parsers.selector;

import io.github.pronze.lib.cloud.ArgumentDescription;
import io.github.pronze.lib.cloud.arguments.CommandArgument;
import io.github.pronze.lib.cloud.arguments.parser.ArgumentParseResult;
import io.github.pronze.lib.cloud.arguments.parser.ArgumentParser;
import io.github.pronze.lib.cloud.bukkit.BukkitCommandContextKeys;
import io.github.pronze.lib.cloud.bukkit.CloudBukkitCapabilities;
import io.github.pronze.lib.cloud.bukkit.arguments.selector.SingleEntitySelector;
import io.github.pronze.lib.cloud.bukkit.parsers.selector.SelectorParseException;
import io.github.pronze.lib.cloud.context.CommandContext;
import io.github.pronze.lib.cloud.exceptions.parsing.NoInputProvidedException;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SingleEntitySelectorArgument<C>
extends CommandArgument<C, SingleEntitySelector> {
    private SingleEntitySelectorArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new SingleEntitySelectorParser(), defaultValue, SingleEntitySelector.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, SingleEntitySelector> of(@NonNull String name) {
        return SingleEntitySelectorArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, SingleEntitySelector> optional(@NonNull String name) {
        return SingleEntitySelectorArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, SingleEntitySelector> optional(@NonNull String name, @NonNull String defaultEntitySelector) {
        return SingleEntitySelectorArgument.newBuilder(name).asOptionalWithDefault(defaultEntitySelector).build();
    }

    public static final class SingleEntitySelectorParser<C>
    implements ArgumentParser<C, SingleEntitySelector> {
        @Override
        public @NonNull ArgumentParseResult<SingleEntitySelector> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            List entities;
            if (!commandContext.get(BukkitCommandContextKeys.CLOUD_BUKKIT_CAPABILITIES).contains((Object)CloudBukkitCapabilities.BRIGADIER)) {
                return ArgumentParseResult.failure(new SelectorParseException("", commandContext, SelectorParseException.FailureReason.UNSUPPORTED_VERSION, SingleEntitySelectorParser.class));
            }
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(SingleEntitySelectorParser.class, commandContext));
            }
            inputQueue.remove();
            try {
                entities = Bukkit.selectEntities((CommandSender)commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER), (String)input);
            }
            catch (IllegalArgumentException e) {
                return ArgumentParseResult.failure(new SelectorParseException(input, commandContext, SelectorParseException.FailureReason.MALFORMED_SELECTOR, SingleEntitySelectorParser.class));
            }
            if (entities.size() > 1) {
                return ArgumentParseResult.failure(new SelectorParseException(input, commandContext, SelectorParseException.FailureReason.TOO_MANY_ENTITIES, SingleEntitySelectorParser.class));
            }
            return ArgumentParseResult.success(new SingleEntitySelector(input, entities));
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, SingleEntitySelector> {
        private Builder(@NonNull String name) {
            super(SingleEntitySelector.class, name);
        }

        public @NonNull SingleEntitySelectorArgument<C> build() {
            return new SingleEntitySelectorArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

