/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.cloud.minecraft.extras;

import io.github.pronze.lib.cloud.ArgumentDescription;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import io.github.pronze.lib.kyori.adventure.translation.GlobalTranslator;
import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class RichDescription
implements ArgumentDescription {
    private static final RichDescription EMPTY = new RichDescription(Component.empty());
    private final Component contents;

    RichDescription(Component contents) {
        this.contents = contents;
    }

    public static @NonNull RichDescription empty() {
        return EMPTY;
    }

    public static @NonNull RichDescription of(@NonNull ComponentLike contents) {
        Component componentContents = Objects.requireNonNull(contents, "contents").asComponent();
        if (Component.empty().equals(componentContents)) {
            return EMPTY;
        }
        return new RichDescription(componentContents);
    }

    public static @NonNull RichDescription translatable(@NonNull String key) {
        Objects.requireNonNull(key, "key");
        return new RichDescription(Component.translatable(key));
    }

    public static @NonNull RichDescription translatable(@NonNull String key, ComponentLike ... args) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(args, "args");
        return new RichDescription(Component.translatable(key, args));
    }

    @Override
    @Deprecated
    public @NonNull String getDescription() {
        return PlainComponentSerializer.plain().serialize(GlobalTranslator.render(this.contents, Locale.getDefault()));
    }

    public @NonNull Component getContents() {
        return this.contents;
    }

    @Override
    public boolean isEmpty() {
        return Component.empty().equals(this.contents);
    }
}

