/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.commodore;

import com.mojang.brigadier.arguments.ArgumentType;
import io.github.pronze.lib.commodore.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import org.bukkit.NamespacedKey;

public final class MinecraftArgumentTypes {
    private static final Constructor<?> MINECRAFT_KEY_CONSTRUCTOR;
    private static final Method ARGUMENT_REGISTRY_GET_BY_KEY_METHOD;
    private static final Field BY_CLASS_MAP_FIELD;

    private MinecraftArgumentTypes() {
    }

    public static boolean isRegistered(NamespacedKey key) {
        try {
            Object minecraftKey = MINECRAFT_KEY_CONSTRUCTOR.newInstance(key.getNamespace(), key.getKey());
            Object entry = ARGUMENT_REGISTRY_GET_BY_KEY_METHOD.invoke(null, minecraftKey);
            return entry != null;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<? extends ArgumentType<?>> getClassByKey(NamespacedKey key) throws IllegalArgumentException {
        try {
            Object minecraftKey = MINECRAFT_KEY_CONSTRUCTOR.newInstance(key.getNamespace(), key.getKey());
            Object entry = ARGUMENT_REGISTRY_GET_BY_KEY_METHOD.invoke(null, minecraftKey);
            if (entry == null) {
                throw new IllegalArgumentException(key.toString());
            }
            Map map = (Map)BY_CLASS_MAP_FIELD.get(null);
            for (Map.Entry mapEntry : map.entrySet()) {
                if (mapEntry.getValue() != entry) continue;
                return (Class)mapEntry.getKey();
            }
            throw new IllegalArgumentException(key.toString());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static ArgumentType<?> getByKey(NamespacedKey key) throws IllegalArgumentException {
        try {
            Constructor<ArgumentType<?>> constructor = MinecraftArgumentTypes.getClassByKey(key).getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static void ensureSetup() {
    }

    static {
        try {
            Class<?> argumentRegistry;
            Class<?> minecraftKey;
            if (ReflectionUtil.minecraftVersion() > 16) {
                minecraftKey = ReflectionUtil.mcClass("resources.MinecraftKey");
                argumentRegistry = ReflectionUtil.mcClass("commands.synchronization.ArgumentRegistry");
            } else {
                minecraftKey = ReflectionUtil.nmsClass("MinecraftKey");
                argumentRegistry = ReflectionUtil.nmsClass("ArgumentRegistry");
            }
            MINECRAFT_KEY_CONSTRUCTOR = minecraftKey.getConstructor(String.class, String.class);
            MINECRAFT_KEY_CONSTRUCTOR.setAccessible(true);
            ARGUMENT_REGISTRY_GET_BY_KEY_METHOD = Arrays.stream(argumentRegistry.getDeclaredMethods()).filter(method -> method.getParameterCount() == 1).filter(method -> minecraftKey.equals(method.getParameterTypes()[0])).findFirst().orElseThrow(NoSuchMethodException::new);
            ARGUMENT_REGISTRY_GET_BY_KEY_METHOD.setAccessible(true);
            BY_CLASS_MAP_FIELD = Arrays.stream(argumentRegistry.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getType().equals(Map.class)).filter(field -> {
                ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
                Type param = parameterizedType.getActualTypeArguments()[0];
                if (!(param instanceof ParameterizedType)) {
                    return false;
                }
                return ((ParameterizedType)param).getRawType().equals(Class.class);
            }).findFirst().orElseThrow(NoSuchFieldException::new);
            BY_CLASS_MAP_FIELD.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

