/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.configurate.xml;

import io.github.pronze.lib.configurate.AttributedConfigurationNode;
import io.github.pronze.lib.configurate.CommentedConfigurationNodeIntermediary;
import io.github.pronze.lib.configurate.ConfigurateException;
import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.ConfigurationOptions;
import io.github.pronze.lib.configurate.loader.AbstractConfigurationLoader;
import io.github.pronze.lib.configurate.loader.CommentHandler;
import io.github.pronze.lib.configurate.loader.CommentHandlers;
import io.github.pronze.lib.configurate.loader.ParsingException;
import io.github.pronze.lib.configurate.util.UnmodifiableCollections;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XmlConfigurationLoader
extends AbstractConfigurationLoader<AttributedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet(Double.class, Long.class, Integer.class, Boolean.class, String.class, Number.class);
    private static final String HEADER_PREFIX = "~";
    private static final String ATTRIBUTE_TYPE = "configurate-type";
    private static final String USER_DATA_COMMENT = "configurate-comment";
    private static final String INDENT_PROPERTY = "{http://xml.apache.org/xslt}indent-amount";
    private static final String FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String FEATURE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private final @Nullable Schema schema;
    private final String defaultTagName;
    private final int indent;
    private final boolean writeExplicitType;
    private final boolean includeXmlDeclaration;
    private final boolean resolvesExternalContent;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    private XmlConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{CommentHandlers.XML_STYLE});
        this.schema = builder.schema();
        this.defaultTagName = builder.defaultTagName();
        this.indent = builder.indent();
        this.writeExplicitType = builder.writesExplicitType();
        this.includeXmlDeclaration = builder.includesXmlDeclaration();
        this.resolvesExternalContent = builder.resolvesExternalContent();
    }

    private DocumentBuilder newDocumentBuilder() throws ConfigurateException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        if (this.schema != null) {
            builderFactory.setSchema(this.schema);
        }
        if (!this.resolvesExternalContent) {
            try {
                builderFactory.setFeature(FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
                builderFactory.setFeature(FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
                builderFactory.setFeature(FEATURE_LOAD_EXTERNAL_DTD, false);
            }
            catch (ParserConfigurationException e) {
                throw new ConfigurateException(e);
            }
            builderFactory.setXIncludeAware(false);
            builderFactory.setExpandEntityReferences(false);
        }
        try {
            return builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurateException(e);
        }
    }

    private Transformer newTransformer() throws ConfigurateException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (!this.resolvesExternalContent) {
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            if (this.indent > 0) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty(INDENT_PROPERTY, Integer.toString(this.indent));
            }
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new ConfigurateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @NonNull AttributedConfigurationNode load(@NonNull ConfigurationOptions options) throws ParsingException {
        if (this.source == null) {
            throw new ParsingException(-1, -1, "", "No source present to read from!", null);
        }
        try (BufferedReader reader2 = (BufferedReader)this.source.call();){
            Document document;
            DocumentBuilder documentBuilder = this.newDocumentBuilder();
            try {
                document = documentBuilder.parse(new InputSource(reader2));
            }
            catch (SAXParseException ex) {
                throw new ParsingException(ex.getLineNumber(), ex.getColumnNumber(), "", ex.getMessage(), ex.getCause());
            }
            catch (SAXException e) {
                throw new ParsingException(-1, -1, null, null, e);
            }
            NodeList children = document.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 8) {
                    options = options.header(this.unwrapHeader(child.getTextContent().trim()));
                } else if (child.getNodeType() == 1) {
                    AttributedConfigurationNode node = this.createNode(options);
                    this.readElement(child, node);
                    AttributedConfigurationNode attributedConfigurationNode = node;
                    return attributedConfigurationNode;
                }
                ++i;
            }
            return this.createNode(options);
        }
        catch (FileNotFoundException | NoSuchFileException reader2) {
            return this.createNode(options);
        }
        catch (ParsingException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ParsingException(-1, -1, "", null, e);
        }
    }

    private String unwrapHeader(String headerContent) {
        if (headerContent.isEmpty()) {
            return headerContent;
        }
        return CONFIGURATE_LINE_PATTERN.splitAsStream(headerContent).map(line -> {
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith(HEADER_PREFIX)) {
                line = line.substring(line.indexOf(HEADER_PREFIX) + 1);
            }
            if (line.length() > 0 && line.charAt(0) == ' ') {
                line = line.substring(1);
            }
            return line;
        }).filter(line -> !line.isEmpty()).collect(Collectors.joining("\n"));
    }

    @Override
    protected void loadInternal(AttributedConfigurationNode node, BufferedReader reader) {
        throw new UnsupportedOperationException("XMLConfigurationLoader provides custom loading logic to handle headers");
    }

    private void readElement(Node from, AttributedConfigurationNode to) {
        @Nullable NodeType type = null;
        to.tagName(from.getNodeName());
        String potentialComment = (String)from.getUserData(USER_DATA_COMMENT);
        if (potentialComment != null) {
            to.comment(potentialComment);
        }
        if (from.hasAttributes()) {
            NamedNodeMap attributes = from.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                String key = attribute.getNodeName();
                String value = attribute.getNodeValue();
                if (key.equals(ATTRIBUTE_TYPE)) {
                    if (value.equals("map")) {
                        type = NodeType.MAP;
                        continue;
                    }
                    if (!value.equals("list")) continue;
                    type = NodeType.LIST;
                    continue;
                }
                to.addAttribute(key, value);
            }
        }
        LinkedHashMap<String, Collection> children = new LinkedHashMap<String, Collection>();
        if (from.hasChildNodes()) {
            StringBuilder comment = new StringBuilder();
            NodeList childNodes = from.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() == 1) {
                    children.computeIfAbsent(child.getNodeName(), $ -> new ArrayList()).add(child);
                    if (comment.length() <= 0) continue;
                    child.setUserData(USER_DATA_COMMENT, comment.toString(), null);
                    comment.setLength(0);
                    continue;
                }
                if (child.getNodeType() != 8) continue;
                if (comment.length() > 0) {
                    comment.append('\n');
                }
                comment.append(child.getTextContent().trim());
            }
        }
        if (children.isEmpty()) {
            to.raw(XmlConfigurationLoader.parseValue(from.getTextContent()));
            return;
        }
        if (type == null) {
            type = NodeType.MAP;
            for (Collection child : children.values()) {
                if (child.size() <= 1) continue;
                type = NodeType.LIST;
                break;
            }
        }
        if (type == NodeType.MAP) {
            to.raw(Collections.emptyMap());
        } else {
            to.raw(Collections.emptyList());
        }
        for (Map.Entry entry : children.entrySet()) {
            if (type == NodeType.MAP) {
                AttributedConfigurationNode child = (AttributedConfigurationNode)to.node(new Object[]{entry.getKey()});
                this.readElement((Node)((Collection)entry.getValue()).iterator().next(), child);
                continue;
            }
            for (Node element : (Collection)entry.getValue()) {
                AttributedConfigurationNode child = (AttributedConfigurationNode)to.appendListNode();
                this.readElement(element, child);
            }
        }
    }

    @Override
    protected void writeHeaderInternal(Writer writer) throws IOException {
        if (this.includeXmlDeclaration) {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write(SYSTEM_LINE_SEPARATOR);
        }
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) throws ConfigurateException {
        DocumentBuilder documentBuilder = this.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        @Nullable Node comment = this.createCommentNode(document, node);
        if (comment != null) {
            document.appendChild(comment);
        }
        document.appendChild(this.writeNode(document, node, null));
        Transformer transformer = this.newTransformer();
        DOMSource source = new DOMSource(document);
        try {
            transformer.transform(source, new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new ConfigurateException(node, (Throwable)e);
        }
    }

    private void appendCommentIfNecessary(Element parent, ConfigurationNode node) {
        @Nullable Node possibleComment = this.createCommentNode(parent.getOwnerDocument(), node);
        if (possibleComment != null) {
            parent.appendChild(possibleComment);
        }
    }

    private @Nullable Node createCommentNode(Document doc, ConfigurationNode node) {
        String comment;
        if (node instanceof CommentedConfigurationNodeIntermediary && (comment = ((CommentedConfigurationNodeIntermediary)node).comment()) != null) {
            return doc.createComment(" " + comment.trim() + " ");
        }
        return null;
    }

    private Element writeNode(Document document, ConfigurationNode node, @Nullable String forcedTag) {
        String tag = this.defaultTagName;
        Map<Object, Object> attributes = Collections.emptyMap();
        if (node instanceof AttributedConfigurationNode) {
            AttributedConfigurationNode attributedNode = (AttributedConfigurationNode)node;
            tag = attributedNode.tagName();
            attributes = attributedNode.attributes();
        }
        Element element = document.createElement(forcedTag == null ? tag : forcedTag);
        for (Map.Entry entry : attributes.entrySet()) {
            element.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        if (node.isMap()) {
            for (Map.Entry<Object, Object> entry : node.childrenMap().entrySet()) {
                this.appendCommentIfNecessary(element, (ConfigurationNode)entry.getValue());
                element.appendChild(this.writeNode(document, (ConfigurationNode)entry.getValue(), entry.getKey().toString()));
            }
        } else if (node.isList()) {
            if (this.writeExplicitType) {
                element.setAttribute(ATTRIBUTE_TYPE, "list");
            }
            for (ConfigurationNode configurationNode : node.childrenList()) {
                this.appendCommentIfNecessary(element, configurationNode);
                element.appendChild(this.writeNode(document, configurationNode, null));
            }
        } else {
            element.appendChild(document.createTextNode(Objects.toString(node.rawScalar())));
        }
        return element;
    }

    @Override
    public AttributedConfigurationNode createNode(ConfigurationOptions options) {
        options = options.nativeTypes(NATIVE_TYPES);
        return AttributedConfigurationNode.root("root", options);
    }

    private static Object parseValue(String value) {
        if (value.equals("true") || value.equals("false")) {
            return Boolean.parseBoolean(value);
        }
        try {
            double doubleValue = Double.parseDouble(value);
            if (XmlConfigurationLoader.isInteger(doubleValue)) {
                int intValue;
                long longValue = Long.parseLong(value);
                if (longValue == (long)(intValue = (int)longValue)) {
                    return intValue;
                }
                return longValue;
            }
            return doubleValue;
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    private static boolean isInteger(double value) {
        return !Double.isNaN(value) && Double.isFinite(value) && value == Math.rint(value);
    }

    private static enum NodeType {
        MAP,
        LIST;

    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, XmlConfigurationLoader> {
        private @Nullable Schema schema;
        private String defaultTagName = "element";
        private int indent = 2;
        private boolean writeExplicitType = true;
        private boolean resolvesExternalContent;
        private boolean includeXmlDeclaration = true;

        Builder() {
        }

        public @NonNull Builder indent(int indent) {
            this.indent = indent;
            return this;
        }

        public int indent() {
            return this.indent;
        }

        public Builder schema(@Nullable Schema schema) {
            this.schema = schema;
            return this;
        }

        public @Nullable Schema schema() {
            return this.schema;
        }

        public Builder defaultTagName(String defaultTagName) {
            this.defaultTagName = defaultTagName;
            return this;
        }

        public @NonNull String defaultTagName() {
            return this.defaultTagName;
        }

        public Builder writesExplicitType(boolean writeExplicitType) {
            this.writeExplicitType = writeExplicitType;
            return this;
        }

        public boolean writesExplicitType() {
            return this.writeExplicitType;
        }

        public Builder includesXmlDeclaration(boolean includeXmlDeclaration) {
            this.includeXmlDeclaration = includeXmlDeclaration;
            return this;
        }

        public boolean includesXmlDeclaration() {
            return this.includeXmlDeclaration;
        }

        public Builder resolvesExternalContent(boolean resolvesExternalContent) {
            this.resolvesExternalContent = resolvesExternalContent;
            return this;
        }

        public boolean resolvesExternalContent() {
            return this.resolvesExternalContent;
        }

        @Override
        public XmlConfigurationLoader build() {
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
            return new XmlConfigurationLoader(this);
        }
    }
}

