/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.platform.bukkit;

import io.github.pronze.lib.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import io.github.pronze.lib.kyori.adventure.platform.bukkit.MinecraftReflection;
import io.github.pronze.lib.kyori.adventure.platform.nms.accessors.ComponentAccessor;
import io.github.pronze.lib.kyori.adventure.platform.nms.accessors.Component_i_SerializerAccessor;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.serializer.ComponentSerializer;
import io.github.pronze.lib.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class MinecraftComponentSerializer
implements ComponentSerializer<Component, Component, Object> {
    private static final MinecraftComponentSerializer INSTANCE = new MinecraftComponentSerializer();
    @Nullable
    private static final Class<?> CLASS_CHAT_COMPONENT = ComponentAccessor.getType();
    private static final AtomicReference<RuntimeException> INITIALIZATION_ERROR = new AtomicReference<UnsupportedOperationException>(new UnsupportedOperationException());
    private static final Object MC_TEXT_GSON;
    private static final MethodHandle TEXT_SERIALIZER_DESERIALIZE;
    private static final MethodHandle TEXT_SERIALIZER_SERIALIZE;
    private static final boolean SUPPORTED;

    public static boolean isSupported() {
        return SUPPORTED;
    }

    @NotNull
    public static MinecraftComponentSerializer get() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull Object input) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        try {
            if (MC_TEXT_GSON != null) {
                String element = MC_TEXT_GSON.getClass().getMethod("toJson", Object.class).invoke(MC_TEXT_GSON, input).toString();
                return BukkitComponentSerializer.gson().serializer().fromJson(element, Component.class);
            }
            return GsonComponentSerializer.gson().deserialize(TEXT_SERIALIZER_SERIALIZE.invoke(input));
        }
        catch (Throwable error) {
            throw new UnsupportedOperationException(error);
        }
    }

    @Override
    @NotNull
    public Object serialize(@NotNull Component component) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        if (MC_TEXT_GSON != null) {
            String json = BukkitComponentSerializer.gson().serializer().toJson(component);
            try {
                return MC_TEXT_GSON.getClass().getMethod("fromJson", String.class, Class.class).invoke(MC_TEXT_GSON, json, CLASS_CHAT_COMPONENT);
            }
            catch (Throwable error) {
                throw new UnsupportedOperationException(error);
            }
        }
        try {
            return TEXT_SERIALIZER_DESERIALIZE.invoke((String)BukkitComponentSerializer.gson().serialize(component));
        }
        catch (Throwable error) {
            throw new UnsupportedOperationException(error);
        }
    }

    static {
        Object gson = null;
        MethodHandle textSerializerDeserialize = null;
        MethodHandle textSerializerSerialize = null;
        try {
            Class<?> chatSerializerClass;
            if (CLASS_CHAT_COMPONENT != null && (chatSerializerClass = Component_i_SerializerAccessor.getType()) != null) {
                Field gsonField = Component_i_SerializerAccessor.getFieldGSON();
                if (gsonField != null) {
                    gsonField.setAccessible(true);
                    gson = gsonField.get(null);
                } else {
                    Method[] declaredMethods = chatSerializerClass.getDeclaredMethods();
                    Method deserialize = Arrays.stream(declaredMethods).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> CLASS_CHAT_COMPONENT.isAssignableFrom(m.getReturnType())).filter(m -> m.getParameterCount() == 1 && m.getParameterTypes()[0].equals(String.class)).min(Comparator.comparing(Method::getName)).orElse(null);
                    Method serialize = Arrays.stream(declaredMethods).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.getReturnType().equals(String.class)).filter(m -> m.getParameterCount() == 1 && CLASS_CHAT_COMPONENT.isAssignableFrom(m.getParameterTypes()[0])).findFirst().orElse(null);
                    if (deserialize != null) {
                        textSerializerDeserialize = MinecraftReflection.lookup().unreflect(deserialize);
                    }
                    if (serialize != null) {
                        textSerializerSerialize = MinecraftReflection.lookup().unreflect(serialize);
                    }
                }
            }
        }
        catch (Throwable error) {
            INITIALIZATION_ERROR.set(new UnsupportedOperationException("Error occurred during initialization", error));
        }
        MC_TEXT_GSON = gson;
        TEXT_SERIALIZER_DESERIALIZE = textSerializerDeserialize;
        TEXT_SERIALIZER_SERIALIZE = textSerializerSerialize;
        SUPPORTED = MC_TEXT_GSON != null || TEXT_SERIALIZER_DESERIALIZE != null && TEXT_SERIALIZER_SERIALIZE != null;
    }
}

