/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.platform.nms.accessors;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AccessorUtils {
    private static final Map<Class<?>, Class<?>> classCache = new HashMap();
    private static final Map<Map.Entry<Class<?>, String>, Field> fieldCache = new HashMap();
    private static final Map<Map.Entry<Class<?>, String>, Object> enumCache = new HashMap();
    private static final Map<Map.Entry<Class<?>, String>, Method> methodCache = new HashMap();
    private static final Map<Map.Entry<Class<?>, Integer>, Constructor<?>> constructorCache = new HashMap();
    private static int MAJOR_VERSION;
    private static int MINOR_VERSION;
    private static int PATCH_VERSION;
    private static String craftBukkitImpl;
    private static boolean craftBukkitBased;
    private static boolean mcpBased;

    public static Class<?> getType(Class<?> accessor, Consumer<AccessorMapper> mapper) {
        String res;
        Class<?> cache = classCache.get(accessor);
        if (cache != null) {
            return cache;
        }
        AccessorMapper accessorMapper = new AccessorMapper();
        mapper.accept(accessorMapper);
        Map map = accessorMapper.map;
        if (mcpBased && (res = AccessorUtils.reduceMapping(map, "mcp")) != null) {
            try {
                Class<?> clazz = Class.forName(res);
                classCache.put(accessor, clazz);
                return clazz;
            }
            catch (Throwable clazz) {
                // empty catch block
            }
        }
        if (craftBukkitBased && (res = AccessorUtils.reduceMapping(map, "spigot")) != null) {
            try {
                Class<?> clazz = Class.forName(res);
                classCache.put(accessor, clazz);
                return clazz;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        classCache.put(accessor, null);
        return null;
    }

    public static Field getField(Class<?> accessor, String field, Consumer<AccessorMapper> mapper) {
        Class clazz1;
        Class clazz2;
        String res;
        AbstractMap.SimpleEntry kvholder = new AbstractMap.SimpleEntry(accessor, field);
        if (fieldCache.containsKey(kvholder)) {
            return fieldCache.get(kvholder);
        }
        AccessorMapper accessorMapper = new AccessorMapper();
        mapper.accept(accessorMapper);
        Map map = accessorMapper.map;
        if (mcpBased && (res = AccessorUtils.reduceMapping(map, "mcp")) != null) {
            try {
                clazz1 = clazz2 = (Class)accessor.getMethod("getType", new Class[0]).invoke(null, new Object[0]);
                while (true) {
                    try {
                        Field fieldC = clazz1.getDeclaredField(res);
                        fieldC.setAccessible(true);
                        fieldCache.put(kvholder, fieldC);
                        return fieldC;
                    }
                    catch (Throwable fieldC) {
                        if ((clazz1 = clazz1.getSuperclass()) != null && clazz1 != Object.class) continue;
                    }
                    break;
                }
            }
            catch (Throwable clazz2) {
                // empty catch block
            }
        }
        if (craftBukkitBased && (res = AccessorUtils.reduceMapping(map, "spigot")) != null) {
            try {
                clazz1 = clazz2 = (Class)accessor.getMethod("getType", new Class[0]).invoke(null, new Object[0]);
                while (true) {
                    try {
                        Field fieldC = clazz1.getDeclaredField(res);
                        fieldC.setAccessible(true);
                        fieldCache.put(kvholder, fieldC);
                        return fieldC;
                    }
                    catch (Throwable throwable) {
                        if ((clazz1 = clazz1.getSuperclass()) != null && clazz1 != Object.class) continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        fieldCache.put(kvholder, null);
        return null;
    }

    public static Object getEnumField(Class<?> accessor, String field, Consumer<AccessorMapper> mapper) {
        Class clazz2;
        String res;
        AbstractMap.SimpleEntry kvholder = new AbstractMap.SimpleEntry(accessor, field);
        if (enumCache.containsKey(kvholder)) {
            return enumCache.get(kvholder);
        }
        AccessorMapper accessorMapper = new AccessorMapper();
        mapper.accept(accessorMapper);
        Map map = accessorMapper.map;
        if (mcpBased) {
            res = AccessorUtils.reduceMapping(map, "mcp");
            try {
                clazz2 = (Class)accessor.getMethod("getType", new Class[0]).invoke(null, new Object[0]);
                try {
                    Field fieldC = clazz2.getDeclaredField(res);
                    fieldC.setAccessible(true);
                    Object enumeration = fieldC.get(null);
                    enumCache.put(kvholder, enumeration);
                    return enumeration;
                }
                catch (Throwable fieldC) {
                }
            }
            catch (Throwable clazz2) {
                // empty catch block
            }
        }
        if (craftBukkitBased) {
            res = AccessorUtils.reduceMapping(map, "spigot");
            try {
                clazz2 = (Class)accessor.getMethod("getType", new Class[0]).invoke(null, new Object[0]);
                try {
                    Field fieldC = clazz2.getDeclaredField(res);
                    fieldC.setAccessible(true);
                    Object enumeration = fieldC.get(null);
                    enumCache.put(kvholder, enumeration);
                    return enumeration;
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        enumCache.put(kvholder, null);
        return null;
    }

    public static Method getMethod(Class<?> accessor, String method, Consumer<AccessorMapper> mapper, Class<?> ... params) {
        Class clazz2;
        Class clazz3;
        String res;
        AbstractMap.SimpleEntry kvholder = new AbstractMap.SimpleEntry(accessor, method);
        if (methodCache.containsKey(kvholder)) {
            return methodCache.get(kvholder);
        }
        AccessorMapper accessorMapper = new AccessorMapper();
        mapper.accept(accessorMapper);
        Map map = accessorMapper.map;
        if (mcpBased && (res = AccessorUtils.reduceMapping(map, "mcp")) != null) {
            try {
                clazz2 = clazz3 = (Class)accessor.getMethod("getType", new Class[0]).invoke(null, new Object[0]);
                while (true) {
                    try {
                        Method methodC = clazz2.getDeclaredMethod(res, params);
                        methodC.setAccessible(true);
                        methodCache.put(kvholder, methodC);
                        return methodC;
                    }
                    catch (Throwable methodC) {
                        if ((clazz2 = clazz2.getSuperclass()) != null && clazz2 != Object.class) continue;
                    }
                    break;
                }
            }
            catch (Throwable clazz3) {
                // empty catch block
            }
        }
        if (craftBukkitBased && (res = AccessorUtils.reduceMapping(map, "spigot")) != null) {
            try {
                clazz2 = clazz3 = (Class)accessor.getMethod("getType", new Class[0]).invoke(null, new Object[0]);
                while (true) {
                    try {
                        Method methodC = clazz2.getDeclaredMethod(res, params);
                        methodC.setAccessible(true);
                        methodCache.put(kvholder, methodC);
                        return methodC;
                    }
                    catch (Throwable throwable) {
                        if ((clazz2 = clazz2.getSuperclass()) != null && clazz2 != Object.class) continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        methodCache.put(kvholder, null);
        return null;
    }

    public static Constructor<?> getConstructor(Class<?> accessor, int constructor, Class<?> ... params) {
        AbstractMap.SimpleEntry kvholder = new AbstractMap.SimpleEntry(accessor, constructor);
        if (constructorCache.containsKey(kvholder)) {
            return constructorCache.get(kvholder);
        }
        try {
            Class clazz = (Class)accessor.getMethod("getType", new Class[0]).invoke(null, new Object[0]);
            Constructor constructorC = clazz.getConstructor(params);
            constructorCache.put(kvholder, constructorC);
            return constructorC;
        }
        catch (Throwable throwable) {
            constructorCache.put(kvholder, null);
            return null;
        }
    }

    public static boolean isVersion(int[] ver) {
        return AccessorUtils.isVersion(ver[0], ver[1], ver[2]);
    }

    public static boolean isVersion(int major, int minor, int patch) {
        return MAJOR_VERSION > major || MAJOR_VERSION >= major && (MINOR_VERSION > minor || MINOR_VERSION >= minor && PATCH_VERSION >= patch);
    }

    public static int compare(int[] ver, int[] ver2) {
        if (ver[0] != ver2[0]) {
            return ver[0] - ver2[0];
        }
        if (ver[1] != ver2[1]) {
            return ver[1] - ver2[1];
        }
        return ver[2] - ver2[2];
    }

    public static int[] convertVersion(String version) {
        int[] result = new int[3];
        if (version != null) {
            String[] split = version.split("\\.");
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    result[0] = Integer.parseInt(split[i]);
                    continue;
                }
                if (i == 1) {
                    result[1] = Integer.parseInt(split[i]);
                    continue;
                }
                if (i != 2) continue;
                result[2] = Integer.parseInt(split[i]);
            }
        }
        return result;
    }

    public static String reduceMapping(Map<String, Map<int[], String>> map, String mapping) {
        return Optional.ofNullable(map.get(mapping)).flatMap(m -> m.entrySet().stream().filter(entry -> AccessorUtils.isVersion((int[])entry.getKey())).sorted((o1, o2) -> AccessorUtils.compare((int[])o1.getKey(), (int[])o2.getKey())).reduce((first, second) -> second).map(Map.Entry::getValue)).orElse(null);
    }

    public static Class<?> getOrCatch(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    static {
        craftBukkitImpl = "v1_99_R9";
        craftBukkitBased = false;
        mcpBased = false;
        try {
            String str;
            Class<?> mcForgeClass = Class.forName("net.minecraftforge.common.MinecraftForge");
            mcpBased = true;
            try {
                Class<?> mcpVersionClass = Class.forName("net.minecraftforge.versions.mcp.MCPVersion");
                str = mcpVersionClass.getMethod("getMCVersion", new Class[0]).invoke(null, new Object[0]).toString();
            }
            catch (Throwable ignored) {
                str = mcForgeClass.getField("MC_VERSION").get(null).toString();
            }
            if (str != null) {
                int[] res = AccessorUtils.convertVersion(str);
                MAJOR_VERSION = res[0];
                MINOR_VERSION = res[1];
                PATCH_VERSION = res[2];
            }
        }
        catch (Throwable mcForgeClass) {
            // empty catch block
        }
        try {
            Class<?> bukkitClass = Class.forName("org.bukkit.Bukkit");
            Method method = bukkitClass.getMethod("getServer", new Class[0]);
            if (MAJOR_VERSION == 0) {
                Pattern versionPattern = Pattern.compile("\\(MC: (\\d+)\\.(\\d+)\\.?(\\d+?)?");
                Matcher matcher = versionPattern.matcher(bukkitClass.getMethod("getVersion", new Class[0]).invoke(null, new Object[0]).toString());
                int majorVersion = 1;
                int minorVersion = 0;
                int patchVersion = 0;
                if (matcher.find()) {
                    MatchResult matchResult = matcher.toMatchResult();
                    try {
                        majorVersion = Integer.parseInt(matchResult.group(1), 10);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        minorVersion = Integer.parseInt(matchResult.group(2), 10);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (matchResult.groupCount() >= 3) {
                        try {
                            patchVersion = Integer.parseInt(matchResult.group(3), 10);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                MAJOR_VERSION = majorVersion;
                MINOR_VERSION = minorVersion;
                PATCH_VERSION = patchVersion;
            }
            String packName = method.invoke(null, new Object[0]).getClass().getPackage().getName();
            craftBukkitImpl = packName.substring(packName.lastIndexOf(46) + 1);
            craftBukkitBased = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class AccessorMapper {
        private final Map<String, Map<int[], String>> map = new HashMap<String, Map<int[], String>>();

        public AccessorMapper map(String mappingType, String minVersion, String symbol) {
            if (!this.map.containsKey(mappingType)) {
                this.map.put(mappingType, new HashMap());
            }
            if (mappingType.equals("spigot")) {
                symbol = symbol.replace("${V}", craftBukkitImpl);
            }
            Map<int[], String> map2 = this.map.get(mappingType);
            map2.put(AccessorUtils.convertVersion(minVersion), symbol);
            return this;
        }
    }
}

