/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.serializer.configurate4;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.serialize.TypeSerializer;
import io.github.pronze.lib.kyori.adventure.key.Key;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.BlockNBTPosSerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.KeySerializer;
import io.github.pronze.lib.kyori.adventure.text.BlockNBTComponent;
import io.github.pronze.lib.kyori.adventure.text.BuildableComponent;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.EntityNBTComponent;
import io.github.pronze.lib.kyori.adventure.text.KeybindComponent;
import io.github.pronze.lib.kyori.adventure.text.NBTComponent;
import io.github.pronze.lib.kyori.adventure.text.NBTComponentBuilder;
import io.github.pronze.lib.kyori.adventure.text.ScoreComponent;
import io.github.pronze.lib.kyori.adventure.text.SelectorComponent;
import io.github.pronze.lib.kyori.adventure.text.StorageNBTComponent;
import io.github.pronze.lib.kyori.adventure.text.TextComponent;
import io.github.pronze.lib.kyori.adventure.text.TranslatableComponent;
import io.github.pronze.lib.kyori.adventure.text.format.Style;
import io.github.pronze.lib.kyori.adventure.text.serializer.ComponentSerializer;
import io.github.pronze.lib.kyori.adventure.util.Buildable;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ComponentTypeSerializer
implements TypeSerializer<Component> {
    static final TypeToken<List<Component>> LIST_TYPE = new TypeToken<List<Component>>(){};
    static final String TEXT = "text";
    static final String TRANSLATE = "translate";
    static final String TRANSLATE_WITH = "with";
    static final String SCORE = "score";
    static final String SCORE_NAME = "name";
    static final String SCORE_OBJECTIVE = "objective";
    static final String SCORE_VALUE = "value";
    static final String SELECTOR = "selector";
    static final String KEYBIND = "keybind";
    static final String EXTRA = "extra";
    static final String NBT = "nbt";
    static final String NBT_INTERPRET = "interpret";
    static final String NBT_BLOCK = "block";
    static final String NBT_ENTITY = "entity";
    static final String NBT_STORAGE = "storage";
    @Nullable
    private final ComponentSerializer<Component, ? extends Component, String> stringSerial;
    private final boolean preferString;

    ComponentTypeSerializer(@Nullable ComponentSerializer<Component, ? extends Component, String> stringSerial, boolean preferString) {
        this.stringSerial = stringSerial;
        this.preferString = preferString;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        return this.deserialize0(type, value);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private BuildableComponent<?, ?> deserialize0(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        Style style;
        void var3_20;
        Map<Object, ? extends ConfigurationNode> children;
        if (!value.isList() && !value.isMap()) {
            String string = value.getString();
            if (string != null) {
                if (this.stringSerial == null) return Component.text(string);
                Component ret = this.stringSerial.deserialize(string);
                if (ret instanceof BuildableComponent) return (BuildableComponent)ret;
                throw new SerializationException("Result " + ret + " is not builable");
            }
        } else {
            if (value.isList()) {
                void var3_5;
                Object var3_4 = null;
                for (ConfigurationNode configurationNode : value.childrenList()) {
                    BuildableComponent<?, ?> child = this.deserialize0((Type)((Object)Component.class), configurationNode);
                    if (var3_5 == null) {
                        Buildable.Builder builder = child.toBuilder();
                        continue;
                    }
                    var3_5.append((Component)child);
                }
                if (var3_5 != null) return var3_5.build();
                throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            }
            if (!value.isMap()) {
                throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            }
        }
        if ((children = value.childrenMap()).containsKey(TEXT)) {
            TextComponent.Builder builder = Component.text().content(children.get(TEXT).getString());
        } else if (children.containsKey(TRANSLATE)) {
            String string = children.get(TRANSLATE).getString();
            if (!children.containsKey(TRANSLATE_WITH)) {
                TranslatableComponent.Builder builder = Component.translatable().key(string);
            } else {
                ConfigurationNode with = children.get(TRANSLATE_WITH);
                if (!with.isList()) {
                    throw new SerializationException("Expected with to be a list");
                }
                List<Component> list = with.get(LIST_TYPE);
                TranslatableComponent.Builder builder = Component.translatable().key(string).args(list);
            }
        } else if (children.containsKey(SCORE)) {
            ConfigurationNode configurationNode = children.get(SCORE);
            ConfigurationNode name = configurationNode.node(SCORE_NAME);
            ConfigurationNode configurationNode2 = configurationNode.node(SCORE_OBJECTIVE);
            if (name.virtual() || configurationNode2.virtual()) {
                throw new SerializationException("A score component requires a name and objective");
            }
            ScoreComponent.Builder builder = Component.score().name(name.getString()).objective(configurationNode2.getString());
            ConfigurationNode scoreValue = configurationNode.node(SCORE_VALUE);
            if (!scoreValue.virtual()) {
                ScoreComponent.Builder builder2 = builder.value(scoreValue.getString());
            } else {
                ScoreComponent.Builder builder3 = builder;
            }
        } else if (children.containsKey(SELECTOR)) {
            SelectorComponent.Builder builder = Component.selector().pattern(children.get(SELECTOR).getString());
        } else if (children.containsKey(KEYBIND)) {
            KeybindComponent.Builder builder = Component.keybind().keybind(children.get(KEYBIND).getString());
        } else {
            boolean interpret;
            if (!children.containsKey(NBT)) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            String string = children.get(NBT).getString();
            boolean bl = interpret = children.containsKey(NBT_INTERPRET) && children.get(NBT_INTERPRET).getBoolean();
            if (children.containsKey(NBT_BLOCK)) {
                BlockNBTComponent.Pos pos = (BlockNBTComponent.Pos)children.get(NBT_BLOCK).get(BlockNBTPosSerializer.INSTANCE.type());
                BlockNBTComponent.Builder builder = ComponentTypeSerializer.nbt(Component.blockNBT(), string, interpret).pos(pos);
            } else if (children.containsKey(NBT_ENTITY)) {
                EntityNBTComponent.Builder builder = ComponentTypeSerializer.nbt(Component.entityNBT(), string, interpret).selector(children.get(NBT_ENTITY).getString());
            } else {
                if (!children.containsKey(NBT_STORAGE)) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
                StorageNBTComponent.Builder builder = ComponentTypeSerializer.nbt(Component.storageNBT(), string, interpret).storage((Key)children.get(NBT_STORAGE).get(KeySerializer.INSTANCE.type()));
            }
        }
        if (children.containsKey(EXTRA)) {
            ConfigurationNode configurationNode = children.get(EXTRA);
            for (ConfigurationNode configurationNode3 : configurationNode.childrenList()) {
                var3_20.append((Component)this.deserialize0((Type)((Object)Component.class), configurationNode3));
            }
        }
        if ((style = value.get(Style.class, Style.empty())).isEmpty()) return var3_20.build();
        var3_20.style(style);
        return var3_20.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void serialize(@NotNull Type type, @Nullable Component src, @NotNull ConfigurationNode value) throws SerializationException {
        value.set(null);
        if (src == null) {
            return;
        }
        if (this.stringSerial != null && this.preferString) {
            try {
                value.set(this.stringSerial.serialize(src));
                return;
            }
            catch (Exception ex) {
                throw new SerializationException(ex);
            }
        }
        if (src instanceof TextComponent) {
            value.node(TEXT).set(((TextComponent)src).content());
        } else if (src instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)src;
            value.node(TRANSLATE).set(tc.key());
            if (!tc.args().isEmpty()) {
                ConfigurationNode with = value.node(TRANSLATE_WITH);
                for (Component arg : tc.args()) {
                    with.appendListNode().set(Component.class, arg);
                }
            }
        } else if (src instanceof ScoreComponent) {
            ScoreComponent sc = (ScoreComponent)src;
            ConfigurationNode score = value.node(SCORE);
            score.node(SCORE_NAME).set(sc.name());
            score.node(SCORE_OBJECTIVE).set(sc.objective());
            @Nullable String scoreValue = sc.value();
            if (scoreValue != null) {
                score.node(SCORE_VALUE).set(scoreValue);
            }
        } else if (src instanceof SelectorComponent) {
            value.node(SELECTOR).set(((SelectorComponent)src).pattern());
        } else if (src instanceof KeybindComponent) {
            value.node(KEYBIND).set(((KeybindComponent)src).keybind());
        } else {
            if (!(src instanceof NBTComponent)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
            NBTComponent nc = (NBTComponent)src;
            value.node(NBT).set(nc.nbtPath());
            value.node(NBT_INTERPRET).set(nc.interpret());
            if (src instanceof BlockNBTComponent) {
                value.node(NBT_BLOCK).set(BlockNBTPosSerializer.INSTANCE.type(), ((BlockNBTComponent)nc).pos());
            } else if (src instanceof EntityNBTComponent) {
                value.node(NBT_ENTITY).set(((EntityNBTComponent)nc).selector());
            } else {
                if (!(src instanceof StorageNBTComponent)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
                value.node(NBT_STORAGE).set(KeySerializer.INSTANCE.type(), ((StorageNBTComponent)nc).storage());
            }
        }
        List<Component> children = src.children();
        if (!children.isEmpty()) {
            value.node(EXTRA).set(LIST_TYPE, children);
        }
        if (!src.hasStyling()) return;
        value.set(Style.class, src.style());
    }

    private static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B builder, String nbt, boolean interpret) {
        return builder.nbtPath(nbt).interpret(interpret);
    }

    private static SerializationException notSureHowToDeserialize(ConfigurationNode element) {
        return new SerializationException("Don't know how to turn " + element + " into a Component");
    }

    private static SerializationException notSureHowToSerialize(Component component) {
        return new SerializationException("Don't know how to serialize " + component + " as a Component");
    }
}

