/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.serializer.configurate4;

import io.github.pronze.lib.configurate.BasicConfigurationNode;
import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.ConfigurationOptions;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.serialize.TypeSerializerCollection;
import io.github.pronze.lib.configurate.util.UnmodifiableCollections;
import io.github.pronze.lib.kyori.adventure.inventory.Book;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.BlockNBTPosSerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.BookTypeSerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.ComponentTypeSerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.ConfigurateComponentSerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.DurationSerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.HoverEventShowEntitySerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.HoverEventShowItemSerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.IndexSerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.KeySerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.SoundSerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.SoundStopSerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.StyleSerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.TextColorSerializer;
import io.github.pronze.lib.kyori.adventure.serializer.configurate4.TitleSerializer;
import io.github.pronze.lib.kyori.adventure.sound.Sound;
import io.github.pronze.lib.kyori.adventure.sound.SoundStop;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.event.ClickEvent;
import io.github.pronze.lib.kyori.adventure.text.event.HoverEvent;
import io.github.pronze.lib.kyori.adventure.text.format.Style;
import io.github.pronze.lib.kyori.adventure.text.format.TextDecoration;
import io.github.pronze.lib.kyori.adventure.text.serializer.ComponentSerializer;
import io.github.pronze.lib.kyori.adventure.title.Title;
import io.leangen.geantyref.TypeToken;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConfigurateComponentSerializerImpl
implements ConfigurateComponentSerializer {
    static final ConfigurateComponentSerializer INSTANCE = new Builder().build();
    private final TypeSerializerCollection serializers;
    private final ConfigurationOptions ownNodeOptions;
    @Nullable
    private final ComponentSerializer<Component, ?, String> stringSerializer;
    private final boolean serializeStringComponents;

    private ConfigurateComponentSerializerImpl(@NotNull Builder builder) {
        this.stringSerializer = builder.stringSerializer;
        this.serializeStringComponents = builder.outputStringComponents;
        this.serializers = this.makeSerializers(TypeSerializerCollection.defaults().childBuilder());
        this.ownNodeOptions = ConfigurationOptions.defaults().serializers(this.serializers).nativeTypes(UnmodifiableCollections.toSet(String.class, Integer.class, Boolean.class, Double.class, Float.class));
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull ConfigurationNode input) {
        try {
            @Nullable Component deserialized = input.get(Component.class);
            if (deserialized != null) {
                return deserialized;
            }
        }
        catch (SerializationException e) {
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException("No value present");
    }

    @Override
    @NotNull
    public ConfigurationNode serialize(@NotNull Component component) {
        BasicConfigurationNode base = BasicConfigurationNode.root(this.ownNodeOptions);
        try {
            base.set(Component.class, component);
        }
        catch (SerializationException e) {
            throw new IllegalStateException("Unable to serialize component " + component, e);
        }
        return base;
    }

    @NotNull
    private TypeSerializerCollection makeSerializers(@NotNull TypeSerializerCollection.Builder serializers) {
        return serializers.register(Book.class, BookTypeSerializer.INSTANCE).register(Title.class, TitleSerializer.INSTANCE).register(Sound.class, SoundSerializer.INSTANCE).register(SoundStop.class, SoundStopSerializer.INSTANCE).register(Component.class, new ComponentTypeSerializer(this.stringSerializer, this.serializeStringComponents)).register(KeySerializer.INSTANCE).register(DurationSerializer.INSTANCE).register(Style.class, StyleSerializer.INSTANCE).register(TextColorSerializer.INSTANCE).register(BlockNBTPosSerializer.INSTANCE).registerExact(new IndexSerializer<ClickEvent.Action>(TypeToken.get(ClickEvent.Action.class), ClickEvent.Action.NAMES)).registerExact(new IndexSerializer(new TypeToken<HoverEvent.Action<?>>(){}, HoverEvent.Action.NAMES)).registerExact(new IndexSerializer<Sound.Source>(TypeToken.get(Sound.Source.class), Sound.Source.NAMES)).registerExact(new IndexSerializer<TextDecoration>(TypeToken.get(TextDecoration.class), TextDecoration.NAMES)).registerExact(HoverEvent.ShowEntity.class, HoverEventShowEntitySerializer.INSTANCE).registerExact(HoverEvent.ShowItem.class, HoverEventShowItemSerializer.INSTANCE).build();
    }

    @Override
    @NotNull
    public TypeSerializerCollection serializers() {
        return this.serializers;
    }

    static class Builder
    implements ConfigurateComponentSerializer.Builder {
        @Nullable
        private ComponentSerializer<Component, ?, String> stringSerializer;
        private boolean outputStringComponents = false;

        Builder() {
        }

        @Override
        public @NotNull ConfigurateComponentSerializer.Builder scalarSerializer(@NotNull ComponentSerializer<Component, ?, String> stringSerializer) {
            this.stringSerializer = Objects.requireNonNull(stringSerializer, "stringSerializer");
            return this;
        }

        @Override
        public @NotNull ConfigurateComponentSerializer.Builder outputStringComponents(boolean stringComponents) {
            this.outputStringComponents = stringComponents;
            return this;
        }

        @Override
        @NotNull
        public ConfigurateComponentSerializer build() {
            return new ConfigurateComponentSerializerImpl(this);
        }
    }
}

