/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.serializer.configurate4;

import io.github.pronze.lib.configurate.serialize.ScalarSerializer;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.kyori.adventure.util.Index;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

final class IndexSerializer<T>
extends ScalarSerializer<T> {
    private final Index<String, T> idx;

    IndexSerializer(@NotNull TypeToken<T> type, @NotNull Index<String, T> idx) {
        super(type);
        this.idx = idx;
    }

    @Override
    @NotNull
    public T deserialize(@NotNull Type type, @NotNull Object obj) throws SerializationException {
        T value = this.idx.value(obj.toString());
        if (value == null) {
            throw new SerializationException("No value for key '" + obj + "' in index for type " + this.type());
        }
        return value;
    }

    @Override
    public Object serialize(@NotNull T item, @NotNull Predicate<Class<?>> typeSupported) {
        return this.idx.key(item);
    }
}

