/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.serializer.configurate4;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.ConfigurationOptions;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.serialize.TypeSerializer;
import io.github.pronze.lib.kyori.adventure.key.Key;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.event.ClickEvent;
import io.github.pronze.lib.kyori.adventure.text.event.HoverEvent;
import io.github.pronze.lib.kyori.adventure.text.format.Style;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.kyori.adventure.text.format.TextDecoration;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StyleSerializer
implements TypeSerializer<Style> {
    static final StyleSerializer INSTANCE = new StyleSerializer();
    private static final TextDecoration[] DECORATIONS = TextDecoration.values();
    static final String FONT = "font";
    static final String COLOR = "color";
    static final String INSERTION = "insertion";
    static final String CLICK_EVENT = "clickEvent";
    static final String CLICK_EVENT_ACTION = "action";
    static final String CLICK_EVENT_VALUE = "value";
    static final String HOVER_EVENT = "hoverEvent";
    static final String HOVER_EVENT_ACTION = "action";
    static final TypeToken<HoverEvent.Action<?>> HOVER_EVENT_ACTION_TYPE = new TypeToken<HoverEvent.Action<?>>(){};
    static final String HOVER_EVENT_CONTENTS = "contents";
    @Deprecated
    static final String HOVER_EVENT_VALUE = "value";

    private StyleSerializer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Style deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        ConfigurationNode hoverEvent;
        ConfigurationNode clickEvent;
        TextColor color;
        if (value.virtual()) {
            return Style.empty();
        }
        Style.Builder builder = Style.style();
        @Nullable Key font = value.node(FONT).get(Key.class);
        if (font != null) {
            builder.font(font);
        }
        if ((color = value.node(COLOR).get(TextColor.class)) != null) {
            builder.color(color);
        }
        for (TextDecoration decoration : DECORATIONS) {
            TextDecoration.State state = value.node(StyleSerializer.nonNull(TextDecoration.NAMES.key(decoration), "decoration")).get(TextDecoration.State.class);
            if (state == null) continue;
            builder.decoration(decoration, state);
        }
        @Nullable String insertion = value.node(INSERTION).getString();
        if (insertion != null) {
            builder.insertion(insertion);
        }
        if (!(clickEvent = value.node(CLICK_EVENT)).virtual()) {
            ClickEvent.Action action = StyleSerializer.nonNull(clickEvent.node("action").get(ClickEvent.Action.class), "click event action");
            builder.clickEvent(ClickEvent.clickEvent(action, StyleSerializer.nonNull(clickEvent.node("value").getString(), "click event value")));
        }
        if ((hoverEvent = value.node(HOVER_EVENT)).virtual()) return builder.build();
        HoverEvent.Action<?> action = hoverEvent.node("action").get(HOVER_EVENT_ACTION_TYPE);
        ConfigurationNode contents = hoverEvent.node(HOVER_EVENT_CONTENTS);
        if (contents.virtual()) {
            Component legacyValue = hoverEvent.node("value").get(Component.class);
            if (legacyValue == null) {
                throw new SerializationException("No modern contents or legacy value present for hover event");
            }
            if (action != HoverEvent.Action.SHOW_TEXT) throw new SerializationException("Unable to deserialize legacy hover event of type " + action);
            builder.hoverEvent(HoverEvent.showText(legacyValue));
            return builder.build();
        } else if (action == HoverEvent.Action.SHOW_TEXT) {
            builder.hoverEvent(HoverEvent.showText(StyleSerializer.nonNull(contents.get(Component.class), "hover event text contents")));
            return builder.build();
        } else if (action == HoverEvent.Action.SHOW_ENTITY) {
            builder.hoverEvent(HoverEvent.showEntity(StyleSerializer.nonNull(contents.get(HoverEvent.ShowEntity.class), "hover event show entity contents")));
            return builder.build();
        } else {
            if (action != HoverEvent.Action.SHOW_ITEM) throw new SerializationException("Unsupported hover event action " + action);
            builder.hoverEvent(HoverEvent.showItem(StyleSerializer.nonNull(contents.get(HoverEvent.ShowItem.class), "hover event show item contents")));
        }
        return builder.build();
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable Style obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            obj = Style.empty();
        }
        value.node(FONT).set(Key.class, obj.font());
        value.node(COLOR).set(TextColor.class, obj.color());
        for (TextDecoration decoration : DECORATIONS) {
            ConfigurationNode decorationNode = value.node(StyleSerializer.nonNull(TextDecoration.NAMES.key(decoration), "decoration"));
            TextDecoration.State state = obj.decoration(decoration);
            if (state == TextDecoration.State.NOT_SET) {
                decorationNode.set(null);
                continue;
            }
            decorationNode.set(state == TextDecoration.State.TRUE);
        }
        value.node(INSERTION).set(obj.insertion());
        ConfigurationNode clickNode = value.node(CLICK_EVENT);
        ClickEvent clickEvent = obj.clickEvent();
        if (clickEvent == null) {
            clickNode.set(null);
        } else {
            clickNode.node("action").set(ClickEvent.Action.class, clickEvent.action());
            clickNode.node("value").set(clickEvent.value());
        }
        ConfigurationNode hoverNode = value.node(HOVER_EVENT);
        if (obj.hoverEvent() == null) {
            hoverNode.set(null);
        } else {
            HoverEvent<?> event = obj.hoverEvent();
            hoverNode.node("action").set(HOVER_EVENT_ACTION_TYPE, event.action());
            ConfigurationNode contentsNode = hoverNode.node(HOVER_EVENT_CONTENTS);
            if (event.action() == HoverEvent.Action.SHOW_TEXT) {
                contentsNode.set(Component.class, (Component)event.value());
            } else if (event.action() == HoverEvent.Action.SHOW_ENTITY) {
                contentsNode.set(HoverEvent.ShowEntity.class, (HoverEvent.ShowEntity)event.value());
            } else if (event.action() == HoverEvent.Action.SHOW_ITEM) {
                contentsNode.set(HoverEvent.ShowItem.class, (HoverEvent.ShowItem)event.value());
            }
        }
    }

    @NotNull
    private static <T> T nonNull(@Nullable T value, @NotNull String type) throws SerializationException {
        if (value == null) {
            throw new SerializationException(type + " was null in an unexpected location");
        }
        return value;
    }

    @Override
    public Style emptyValue(Type specificType, ConfigurationOptions options) {
        return Style.empty();
    }
}

