/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.serializer.configurate4;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.serialize.TypeSerializer;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.title.Title;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TitleSerializer
implements TypeSerializer<Title> {
    static final TitleSerializer INSTANCE = new TitleSerializer();
    static final Duration KEEP = Duration.ofSeconds(-1L);
    static final String TITLE = "title";
    static final String SUBTITLE = "subtitle";
    static final String TIMES = "times";
    static final String FADE_IN = "fade-in";
    static final String STAY = "stay";
    static final String FADE_OUT = "fade-out";

    private TitleSerializer() {
    }

    @Override
    @Nullable
    public Title deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        if (value.empty()) {
            return null;
        }
        Component title = value.node(TITLE).get(Component.class, Component.empty());
        Component subtitle = value.node(SUBTITLE).get(Component.class, Component.empty());
        Duration fadeIn = value.node(TIMES, FADE_IN).get(Duration.class, KEEP);
        Duration stay = value.node(TIMES, STAY).get(Duration.class, KEEP);
        Duration fadeOut = value.node(TIMES, FADE_OUT).get(Duration.class, KEEP);
        if (!(Objects.equals(fadeIn, KEEP) && Objects.equals(stay, KEEP) && Objects.equals(fadeOut, KEEP))) {
            return Title.title(title, subtitle, Title.Times.of(fadeIn, stay, fadeOut));
        }
        return Title.title(title, subtitle);
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable Title obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(TITLE).set(Component.class, obj.title());
        value.node(SUBTITLE).set(Component.class, obj.subtitle());
        @Nullable Title.Times times = obj.times();
        value.node(TIMES, FADE_IN).set(Duration.class, times == null || times == Title.DEFAULT_TIMES ? null : times.fadeIn());
        value.node(TIMES, STAY).set(Duration.class, times == null || times == Title.DEFAULT_TIMES ? null : times.stay());
        value.node(TIMES, FADE_OUT).set(Duration.class, times == null || times == Title.DEFAULT_TIMES ? null : times.fadeOut());
    }
}

