/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.text.minimessage;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.minimessage.MiniMessage;
import io.github.pronze.lib.kyori.adventure.text.minimessage.MiniMessageImpl;
import io.github.pronze.lib.kyori.adventure.text.minimessage.Template;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.ElementNode;
import io.github.pronze.lib.kyori.adventure.text.minimessage.template.TemplateResolver;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Context {
    private final boolean strict;
    private final Appendable debugOutput;
    private ElementNode root;
    private final String originalMessage;
    private String replacedMessage;
    private final MiniMessage miniMessage;
    private final TemplateResolver templateResolver;
    private final UnaryOperator<Component> postProcessor;

    Context(boolean strict, Appendable debugOutput, ElementNode root, String originalMessage, String replacedMessage, MiniMessage miniMessage, @NotNull TemplateResolver templateResolver, UnaryOperator<Component> postProcessor) {
        this.strict = strict;
        this.debugOutput = debugOutput;
        this.root = root;
        this.originalMessage = originalMessage;
        this.replacedMessage = replacedMessage;
        this.miniMessage = miniMessage;
        this.templateResolver = templateResolver;
        this.postProcessor = postProcessor == null ? UnaryOperator.identity() : postProcessor;
    }

    public static Context of(boolean strict, String input, MiniMessage miniMessage) {
        return new Context(strict, null, null, input, null, miniMessage, TemplateResolver.empty(), null);
    }

    public static Context of(boolean strict, Appendable debugOutput, String input, MiniMessage miniMessage) {
        return new Context(strict, debugOutput, null, input, null, miniMessage, TemplateResolver.empty(), null);
    }

    public static Context of(boolean strict, String input, MiniMessageImpl miniMessage, @NotNull Template @Nullable [] templates) {
        return new Context(strict, null, null, input, null, miniMessage, templates == null ? TemplateResolver.empty() : TemplateResolver.templates(templates), null);
    }

    public static Context of(boolean strict, Appendable debugOutput, String input, MiniMessageImpl miniMessage, @NotNull Template @Nullable [] templates) {
        return new Context(strict, debugOutput, null, input, null, miniMessage, templates == null ? TemplateResolver.empty() : TemplateResolver.templates(templates), null);
    }

    public static Context of(boolean strict, Appendable debugOutput, String input, MiniMessageImpl miniMessage, TemplateResolver templateResolver) {
        return new Context(strict, debugOutput, null, input, null, miniMessage, templateResolver, null);
    }

    public static Context of(boolean strict, Appendable debugOutput, String input, MiniMessageImpl miniMessage, TemplateResolver templateResolver, UnaryOperator<Component> postProcessor) {
        return new Context(strict, debugOutput, null, input, null, miniMessage, templateResolver, postProcessor);
    }

    public void root(ElementNode root) {
        this.root = root;
    }

    public void replacedMessage(String replacedMessage) {
        this.replacedMessage = replacedMessage;
    }

    public boolean strict() {
        return this.strict;
    }

    public Appendable debugOutput() {
        return this.debugOutput;
    }

    public ElementNode tokens() {
        return this.root;
    }

    @Deprecated
    public String ogMessage() {
        return this.originalMessage();
    }

    public String originalMessage() {
        return this.originalMessage;
    }

    public String replacedMessage() {
        return this.replacedMessage;
    }

    public MiniMessage miniMessage() {
        return this.miniMessage;
    }

    @NotNull
    public TemplateResolver templateResolver() {
        return this.templateResolver;
    }

    public UnaryOperator<Component> postProcessor() {
        return this.postProcessor;
    }

    public Component parse(String message) {
        return this.miniMessage.deserialize(message, this.templateResolver);
    }
}

