/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.text.minimessage.parser;

import io.github.pronze.lib.kyori.adventure.text.minimessage.Template;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.ParsingException;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.Token;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.TokenType;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.ElementNode;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.RootNode;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.TagNode;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.TagPart;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.TemplateNode;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.TextNode;
import io.github.pronze.lib.kyori.adventure.text.minimessage.template.TemplateResolver;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Inserting;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TokenParser {
    private TokenParser() {
    }

    public static ElementNode parse(@NotNull Function<TagNode, @Nullable Transformation> transformationFactory, @NotNull BiPredicate<String, Boolean> tagNameChecker, @NotNull TemplateResolver templateResolver, @NotNull String message, boolean strict) {
        List<Token> tokens = TokenParser.tokenize(message);
        return TokenParser.buildTree(transformationFactory, tagNameChecker, templateResolver, tokens, message, strict);
    }

    public static List<Token> tokenize(String message) {
        List<Token> tokens = TokenParser.parseFirstPass(message);
        TokenParser.parseSecondPass(message, tokens);
        return tokens;
    }

    private static List<Token> parseFirstPass(String message) {
        ArrayList<Token> elements = new ArrayList<Token>();
        FirstPassState state = FirstPassState.NORMAL;
        boolean escaped = false;
        int currentTokenEnd = 0;
        int marker = -1;
        int currentStringChar = 0;
        int length = message.length();
        block15: for (int i = 0; i < length; ++i) {
            int codePoint = message.codePointAt(i);
            if (!Character.isBmpCodePoint(codePoint)) {
                ++i;
            }
            if (!escaped) {
                if (codePoint == 92 && i + 1 < message.length()) {
                    int nextCodePoint = message.codePointAt(i + 1);
                    switch (state) {
                        case NORMAL: {
                            escaped = nextCodePoint == 60;
                            break;
                        }
                        case STRING: {
                            escaped = currentStringChar == nextCodePoint;
                            break;
                        }
                    }
                    if (escaped) {
                        continue;
                    }
                }
            } else {
                escaped = false;
                continue;
            }
            switch (state) {
                case NORMAL: {
                    if (codePoint != 60) continue block15;
                    marker = i;
                    state = FirstPassState.TAG;
                    continue block15;
                }
                case TAG: {
                    switch (codePoint) {
                        case 62: {
                            if (i == marker + 1) {
                                state = FirstPassState.NORMAL;
                                break;
                            }
                            if (currentTokenEnd != marker) {
                                elements.add(new Token(currentTokenEnd, marker, TokenType.TEXT));
                            }
                            currentTokenEnd = i + 1;
                            TokenType thisType = TokenType.OPEN_TAG;
                            if (TokenParser.boundsCheck(message, marker, 1) && message.charAt(marker + 1) == '/') {
                                thisType = TokenType.CLOSE_TAG;
                            }
                            elements.add(new Token(marker, currentTokenEnd, thisType));
                            if (message.regionMatches(marker, "<pre>", 0, 5)) {
                                state = FirstPassState.PRE;
                                break;
                            }
                            state = FirstPassState.NORMAL;
                            break;
                        }
                        case 60: {
                            marker = i;
                            break;
                        }
                        case 34: 
                        case 39: {
                            state = FirstPassState.STRING;
                            currentStringChar = (char)codePoint;
                        }
                    }
                    continue block15;
                }
                case PRE: {
                    if (codePoint != 60 || !message.regionMatches(i, "</pre>", 0, 6)) continue block15;
                    elements.add(new Token(currentTokenEnd, i, TokenType.TEXT));
                    elements.add(new Token(i, i + 6, TokenType.CLOSE_TAG));
                    currentTokenEnd = (i += 5) + 1;
                    state = FirstPassState.NORMAL;
                    continue block15;
                }
                case STRING: {
                    if (codePoint != currentStringChar) continue block15;
                    state = FirstPassState.TAG;
                }
            }
        }
        if (elements.isEmpty()) {
            elements.add(new Token(0, message.length(), TokenType.TEXT));
        } else {
            int end = ((Token)elements.get(elements.size() - 1)).endIndex();
            if (end != message.length()) {
                elements.add(new Token(end, message.length(), TokenType.TEXT));
            }
        }
        return elements;
    }

    private static void parseSecondPass(String message, List<Token> tokens) {
        for (Token token : tokens) {
            TokenType type = token.type();
            if (type != TokenType.OPEN_TAG && type != TokenType.CLOSE_TAG) continue;
            int startIndex = type == TokenType.OPEN_TAG ? token.startIndex() + 1 : token.startIndex() + 2;
            int endIndex = token.endIndex() - 1;
            SecondPassState state = SecondPassState.NORMAL;
            boolean escaped = false;
            int currentStringChar = 0;
            int marker = startIndex;
            block9: for (int i = startIndex; i < endIndex; ++i) {
                int codePoint = message.codePointAt(i);
                if (!Character.isBmpCodePoint(i)) {
                    ++i;
                }
                if (!escaped) {
                    if (codePoint == 92 && i + 1 < message.length()) {
                        int nextCodePoint = message.codePointAt(i + 1);
                        switch (state) {
                            case NORMAL: {
                                escaped = nextCodePoint == 60;
                                break;
                            }
                            case STRING: {
                                boolean bl = escaped = currentStringChar == nextCodePoint;
                            }
                        }
                        if (escaped) {
                            continue;
                        }
                    }
                } else {
                    escaped = false;
                    continue;
                }
                switch (state) {
                    case NORMAL: {
                        if (codePoint == 58) {
                            if (TokenParser.boundsCheck(message, i, 2) && message.charAt(i + 1) == '/' && message.charAt(i + 2) == '/') continue block9;
                            if (marker == i) {
                                TokenParser.insert(token, new Token(i, i, TokenType.TAG_VALUE));
                                ++marker;
                                continue block9;
                            }
                            TokenParser.insert(token, new Token(marker, i, TokenType.TAG_VALUE));
                            marker = i + 1;
                            continue block9;
                        }
                        if (codePoint != 39 && codePoint != 34) continue block9;
                        state = SecondPassState.STRING;
                        currentStringChar = (char)codePoint;
                        continue block9;
                    }
                    case STRING: {
                        if (codePoint != currentStringChar) continue block9;
                        state = SecondPassState.NORMAL;
                    }
                }
            }
            if (token.childTokens() == null || token.childTokens().isEmpty()) {
                TokenParser.insert(token, new Token(startIndex, endIndex, TokenType.TAG_VALUE));
                continue;
            }
            int end = token.childTokens().get(token.childTokens().size() - 1).endIndex();
            if (end == endIndex) continue;
            TokenParser.insert(token, new Token(end + 1, endIndex, TokenType.TAG_VALUE));
        }
    }

    private static ElementNode buildTree(@NotNull Function<TagNode, @Nullable Transformation> transformationFactory, @NotNull BiPredicate<String, Boolean> tagNameChecker, @NotNull TemplateResolver templateResolver, @NotNull List<Token> tokens, @NotNull String message, boolean strict) {
        RootNode root = new RootNode(message);
        ElementNode node = root;
        for (Token token : tokens) {
            TokenType type = token.type();
            switch (type) {
                case TEXT: {
                    node.addChild(new TextNode(node, token, message));
                    break;
                }
                case OPEN_TAG: {
                    TagNode tagNode = new TagNode(node, token, message, templateResolver);
                    if (TokenParser.isReset(tagNode.name())) {
                        if (strict) {
                            throw new ParsingException("<reset> tags are not allowed when strict mode is enabled", message, token);
                        }
                        node = root;
                        break;
                    }
                    if (tagNode.name().equals("pre")) break;
                    Template template = templateResolver.resolve(tagNode.name());
                    if (template instanceof Template.StringTemplate) {
                        node.addChild(new TemplateNode(node, token, message, ((Template.StringTemplate)template).value()));
                        break;
                    }
                    if (tagNameChecker.test(tagNode.name(), true)) {
                        Transformation transformation = transformationFactory.apply(tagNode);
                        if (transformation == null) {
                            node.addChild(new TextNode(node, token, message));
                            break;
                        }
                        tagNode.transformation(transformation);
                        node.addChild(tagNode);
                        if (transformation instanceof Inserting) break;
                        node = tagNode;
                        break;
                    }
                    node.addChild(new TextNode(node, token, message));
                    break;
                }
                case CLOSE_TAG: {
                    List<Token> childTokens = token.childTokens();
                    if (childTokens.isEmpty()) {
                        throw new IllegalStateException("CLOSE_TAG token somehow has no children - the parser should not allow this. Original text: " + message);
                    }
                    ArrayList<String> closeValues = new ArrayList<String>(childTokens.size());
                    for (Token childToken : childTokens) {
                        closeValues.add(TagPart.unquoteAndEscape(message, childToken.startIndex(), childToken.endIndex()));
                    }
                    String closeTagName = (String)closeValues.get(0);
                    if (TokenParser.isReset(closeTagName) || closeTagName.equals("pre")) break;
                    if (!tagNameChecker.test(closeTagName, false)) {
                        node.addChild(new TextNode(node, token, message));
                        break;
                    }
                    ElementNode parentNode = node;
                    while (parentNode instanceof TagNode) {
                        List<TagPart> openParts = ((TagNode)parentNode).parts();
                        if (TokenParser.tagCloses(closeValues, openParts)) {
                            if (parentNode != node && strict) {
                                String msg = "Unclosed tag encountered; " + ((TagNode)node).name() + " is not closed, because " + closeValues.get(0) + " was closed first.";
                                throw new ParsingException(msg, message, parentNode.token(), node.token(), token);
                            }
                            ElementNode par = parentNode.parent();
                            if (par != null) {
                                node = par;
                                break;
                            }
                            throw new IllegalStateException("Root node matched with close tag value, this should not be possible. Original text: " + message);
                        }
                        parentNode = parentNode.parent();
                    }
                    if (parentNode != null && !(parentNode instanceof RootNode)) break;
                    node.addChild(new TextNode(node, token, message));
                }
            }
        }
        if (strict && root != node) {
            ArrayList<TagNode> openTags = new ArrayList<TagNode>();
            for (ElementNode n = node; n != null && n instanceof TagNode; n = n.parent()) {
                openTags.add((TagNode)n);
            }
            Token[] errorTokens = new Token[openTags.size()];
            StringBuilder sb = new StringBuilder("All tags must be explicitly closed while in strict mode. End of string found with open tags: ");
            int i = 0;
            ListIterator iter = openTags.listIterator(openTags.size());
            while (iter.hasPrevious()) {
                TagNode n = (TagNode)iter.previous();
                errorTokens[i++] = n.token();
                sb.append(n.name());
                if (!iter.hasPrevious()) continue;
                sb.append(", ");
            }
            throw new ParsingException(sb.toString(), message, errorTokens);
        }
        return root;
    }

    public static String resolveStringTemplates(@NotNull String message, @NotNull TemplateResolver templateResolver) {
        List<Token> tokens = TokenParser.tokenize(message);
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            TokenType type = token.type();
            switch (type) {
                case TEXT: 
                case CLOSE_TAG: {
                    sb.append(token.get(message));
                    break;
                }
                case OPEN_TAG: {
                    CharSequence name;
                    Template template;
                    if (token.childTokens() != null && token.childTokens().size() == 1 && (template = templateResolver.resolve((name = token.childTokens().get(0).get(message)).toString().toLowerCase(Locale.ROOT))) instanceof Template.StringTemplate) {
                        sb.append(((Template.StringTemplate)template).value());
                        break;
                    }
                    sb.append(token.get(message));
                }
            }
        }
        return sb.toString();
    }

    private static boolean isReset(String input) {
        return input.equalsIgnoreCase("reset") || input.equalsIgnoreCase("r");
    }

    private static boolean tagCloses(List<String> closeParts, List<TagPart> openParts) {
        if (closeParts.size() > openParts.size()) {
            return false;
        }
        if (!closeParts.get(0).equalsIgnoreCase(openParts.get(0).value())) {
            return false;
        }
        for (int i = 1; i < closeParts.size(); ++i) {
            if (closeParts.get(i).equals(openParts.get(i).value())) continue;
            return false;
        }
        return true;
    }

    private static boolean boundsCheck(String text, int index, int length) {
        return index + length < text.length();
    }

    private static void insert(Token token, Token value) {
        if (token.childTokens() == null) {
            token.childTokens(Collections.singletonList(value));
            return;
        }
        if (token.childTokens().size() == 1) {
            ArrayList<Token> list = new ArrayList<Token>(3);
            list.add(token.childTokens().get(0));
            list.add(value);
            token.childTokens(list);
        } else {
            token.childTokens().add(value);
        }
    }

    public static String unescape(String text, int startIndex, int endIndex, IntPredicate escapes) {
        int from = startIndex;
        int i = text.indexOf(92, from);
        if (i == -1 || i >= endIndex) {
            return text.substring(from, endIndex);
        }
        StringBuilder sb = new StringBuilder(endIndex - startIndex);
        while (i != -1 && i + 1 < endIndex) {
            if (escapes.test(text.codePointAt(i + 1))) {
                sb.append(text, from, i);
                if (++i >= endIndex) {
                    from = endIndex;
                    break;
                }
                int codePoint = text.codePointAt(i);
                sb.appendCodePoint(codePoint);
                i = Character.isBmpCodePoint(codePoint) ? ++i : (i += 2);
                if (i >= endIndex) {
                    from = endIndex;
                    break;
                }
            } else {
                sb.append(text, from, ++i);
            }
            from = i;
            i = text.indexOf(92, from);
        }
        sb.append(text, from, endIndex);
        return sb.toString();
    }

    static enum SecondPassState {
        NORMAL,
        STRING;

    }

    static enum FirstPassState {
        NORMAL,
        TAG,
        PRE,
        STRING;

    }
}

