/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.text.minimessage.template;

import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.kyori.adventure.text.minimessage.Template;
import io.github.pronze.lib.kyori.adventure.text.minimessage.template.DynamicTemplateResolver;
import io.github.pronze.lib.kyori.adventure.text.minimessage.template.EmptyTemplateResolver;
import io.github.pronze.lib.kyori.adventure.text.minimessage.template.FilteringTemplateResolver;
import io.github.pronze.lib.kyori.adventure.text.minimessage.template.GroupedTemplateResolver;
import io.github.pronze.lib.kyori.adventure.text.minimessage.template.MapTemplateResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TemplateResolver {
    @NotNull
    public static TemplateResolver resolving(Object ... objects) {
        int size = Objects.requireNonNull(objects, "pairs").length;
        if (size == 0) {
            return TemplateResolver.empty();
        }
        String key = null;
        HashMap<String, Template> templateMap = new HashMap<String, Template>(size);
        for (int i = 0; i < size; ++i) {
            Object obj = objects[i];
            if (key == null) {
                if (obj instanceof Template) {
                    Template template = (Template)obj;
                    templateMap.put(template.key(), template);
                    continue;
                }
                if (obj instanceof String) {
                    key = (String)obj;
                    continue;
                }
                throw new IllegalArgumentException("Argument " + i + " in pairs must be a String key or a Template, was " + obj.getClass().getName());
            }
            if (obj instanceof String) {
                templateMap.put(key, Template.template(key, (String)obj));
            } else if (obj instanceof ComponentLike) {
                templateMap.put(key, Template.template(key, (ComponentLike)obj));
            } else {
                throw new IllegalArgumentException("Argument " + i + " in pairs must be a String or ComponentLike value, was " + obj.getClass().getName());
            }
            key = null;
        }
        if (key != null) {
            throw new IllegalArgumentException("Found key \"" + key + "\" in objects that wasn't followed by a value.");
        }
        if (templateMap.isEmpty()) {
            return TemplateResolver.empty();
        }
        return new MapTemplateResolver(templateMap);
    }

    @NotNull
    public static TemplateResolver pairs(@NotNull Map<String, ?> pairs) {
        int size = Objects.requireNonNull(pairs, "pairs").size();
        if (size == 0) {
            return TemplateResolver.empty();
        }
        HashMap<String, Template> templateMap = new HashMap<String, Template>(size);
        for (Map.Entry<String, ?> entry : pairs.entrySet()) {
            String key = Objects.requireNonNull(entry.getKey(), "pairs cannot contain null keys");
            Object value = entry.getValue();
            if (value instanceof String) {
                templateMap.put(key, Template.template(key, (String)value));
                continue;
            }
            if (value instanceof ComponentLike) {
                templateMap.put(key, Template.template(key, (ComponentLike)value));
                continue;
            }
            if (value instanceof Template) {
                templateMap.put(key, (Template)value);
                continue;
            }
            throw new IllegalArgumentException("Values must be either ComponentLike or String but " + value + " was not.");
        }
        return new MapTemplateResolver(templateMap);
    }

    @NotNull
    public static TemplateResolver templates(Template ... templates) {
        if (Objects.requireNonNull(templates, "templates").length == 0) {
            return TemplateResolver.empty();
        }
        return TemplateResolver.templates(Arrays.asList(templates));
    }

    @NotNull
    public static TemplateResolver templates(@NotNull Iterable<? extends Template> templates) {
        HashMap<String, Template> templateMap = new HashMap<String, Template>();
        for (Template template : Objects.requireNonNull(templates, "templates")) {
            Objects.requireNonNull(template, "templates must not contain null elements");
            templateMap.put(template.key(), template);
        }
        if (templateMap.isEmpty()) {
            return TemplateResolver.empty();
        }
        return new MapTemplateResolver(templateMap);
    }

    @NotNull
    public static TemplateResolver combining(TemplateResolver ... templateResolvers) {
        if (Objects.requireNonNull(templateResolvers, "templateResolvers").length == 1) {
            return Objects.requireNonNull(templateResolvers[0], "templateResolvers must not contain null elements");
        }
        return new GroupedTemplateResolver(Arrays.asList(templateResolvers));
    }

    @NotNull
    public static TemplateResolver combining(@NotNull Iterable<? extends TemplateResolver> templateResolvers) {
        ArrayList<TemplateResolver> templateResolverList = new ArrayList<TemplateResolver>();
        for (TemplateResolver templateResolver : Objects.requireNonNull(templateResolvers, "templateResolvers")) {
            templateResolverList.add(Objects.requireNonNull(templateResolver, "templateResolvers cannot contain null elements"));
        }
        int size = templateResolverList.size();
        if (size == 0) {
            return TemplateResolver.empty();
        }
        if (size == 1) {
            return (TemplateResolver)templateResolverList.get(0);
        }
        return new GroupedTemplateResolver(templateResolvers);
    }

    @NotNull
    public static TemplateResolver dynamic(@NotNull Function<String, ?> resolver) {
        return new DynamicTemplateResolver(Objects.requireNonNull(resolver, "resolver"));
    }

    @NotNull
    public static TemplateResolver filtering(@NotNull TemplateResolver templateResolver, @NotNull Predicate<Template> filter) {
        return new FilteringTemplateResolver(Objects.requireNonNull(templateResolver, "templateResolver"), Objects.requireNonNull(filter, "filter"));
    }

    @NotNull
    public static TemplateResolver empty() {
        return EmptyTemplateResolver.INSTANCE;
    }

    public boolean canResolve(@NotNull String var1);

    @Nullable
    public Template resolve(@NotNull String var1);
}

