/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.inbuild;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.TextComponent;
import io.github.pronze.lib.kyori.adventure.text.flattener.ComponentFlattener;
import io.github.pronze.lib.kyori.adventure.text.format.NamedTextColor;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.ParsingException;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.ElementNode;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.TagNode;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.TagPart;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.ValueNode;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Modifying;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Transformation;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.inbuild.TemplateTransformation;
import io.github.pronze.lib.kyori.examination.ExaminableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class GradientTransformation
extends Transformation
implements Modifying {
    private int size = 0;
    private int disableApplyingColorDepth = -1;
    private int index = 0;
    private int colorIndex = 0;
    private float factorStep = 0.0f;
    private final TextColor[] colors;
    private float phase;
    private final boolean negativePhase;

    public static GradientTransformation create(String name, List<TagPart> args) {
        List<TextColor> textColors;
        float phase = 0.0f;
        if (!args.isEmpty()) {
            textColors = new ArrayList();
            for (int i = 0; i < args.size(); ++i) {
                TextColor parsedColor;
                String arg = args.get(i).value();
                if (i == args.size() - 1) {
                    try {
                        phase = Float.parseFloat(arg);
                        if (phase < -1.0f || phase > 1.0f) {
                            throw new ParsingException(String.format("Gradient phase is out of range (%s). Must be in the range [-1.0f, 1.0f] (inclusive).", Float.valueOf(phase)), args);
                        }
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((parsedColor = arg.charAt(0) == '#' ? TextColor.fromHexString(arg) : (TextColor)NamedTextColor.NAMES.value(arg.toLowerCase(Locale.ROOT))) == null) {
                    throw new ParsingException(String.format("Unable to parse a color from '%s'. Please use named colours or hex (#RRGGBB) colors.", arg), args);
                }
                textColors.add(parsedColor);
            }
            if (textColors.size() < 2) {
                throw new ParsingException("Invalid gradient, not enough colors. Gradients must have at least two colors.", args);
            }
        } else {
            textColors = Collections.emptyList();
        }
        return new GradientTransformation(phase, textColors);
    }

    private GradientTransformation(float phase, List<TextColor> colors) {
        if (phase < 0.0f) {
            this.negativePhase = true;
            this.phase = 1.0f + phase;
            Collections.reverse(colors);
        } else {
            this.negativePhase = false;
            this.phase = phase;
        }
        this.colors = colors.isEmpty() ? new TextColor[]{TextColor.color(0xFFFFFF), TextColor.color(0)} : colors.toArray(new TextColor[0]);
    }

    @Override
    public void visit(ElementNode curr) {
        TagNode tag;
        if (curr instanceof ValueNode) {
            String value = ((ValueNode)curr).value();
            this.size += value.codePointCount(0, value.length());
        } else if (curr instanceof TagNode && (tag = (TagNode)curr).transformation() instanceof TemplateTransformation) {
            ComponentFlattener.textOnly().flatten(tag.transformation().apply(), s -> this.size += s.codePointCount(0, s.length()));
        }
    }

    @Override
    public Component apply() {
        int sectorLength = this.size / (this.colors.length - 1);
        if (sectorLength < 1) {
            sectorLength = 1;
        }
        this.factorStep = 1.0f / (float)(sectorLength + this.index);
        this.phase *= (float)sectorLength;
        this.index = 0;
        return Component.empty();
    }

    @Override
    public Component apply(Component current, int depth) {
        if (this.disableApplyingColorDepth != -1 && depth > this.disableApplyingColorDepth || current.style().color() != null) {
            if (this.disableApplyingColorDepth == -1) {
                this.disableApplyingColorDepth = depth;
            }
            if (current instanceof TextComponent) {
                String content = ((TextComponent)current).content();
                int len = content.codePointCount(0, content.length());
                for (int i = 0; i < len; ++i) {
                    this.color();
                }
            }
            return current.children(Collections.emptyList());
        }
        if (current instanceof TextComponent && ((TextComponent)current).content().length() > 0) {
            TextComponent textComponent = (TextComponent)current;
            String content = textComponent.content();
            TextComponent.Builder parent = Component.text();
            int[] holder = new int[1];
            PrimitiveIterator.OfInt it = content.codePoints().iterator();
            while (it.hasNext()) {
                holder[0] = it.nextInt();
                TextComponent comp = Component.text(new String(holder, 0, 1), this.color());
                parent.append((Component)comp);
            }
            return parent.build();
        }
        return Component.empty().mergeStyle(current);
    }

    private TextColor color() {
        if (this.factorStep * (float)this.index > 1.0f) {
            ++this.colorIndex;
            this.index = 0;
        }
        int n = this.index++;
        float factor = this.factorStep * ((float)n + this.phase);
        if (factor > 1.0f) {
            factor = 1.0f - (factor - 1.0f);
        }
        if (this.negativePhase && this.colors.length % 2 != 0) {
            return TextColor.lerp(factor, this.colors[this.colorIndex + 1], this.colors[this.colorIndex]);
        }
        return TextColor.lerp(factor, this.colors[this.colorIndex], this.colors[this.colorIndex + 1]);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase), ExaminableProperty.of("colors", this.colors));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GradientTransformation that = (GradientTransformation)other;
        return this.index == that.index && this.colorIndex == that.colorIndex && Float.compare(that.factorStep, this.factorStep) == 0 && this.phase == that.phase && Arrays.equals(this.colors, that.colors);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.index, this.colorIndex, Float.valueOf(this.factorStep), Float.valueOf(this.phase));
        result = 31 * result + Arrays.hashCode(this.colors);
        return result;
    }
}

