/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.inbuild;

import io.github.pronze.lib.kyori.adventure.key.InvalidKeyException;
import io.github.pronze.lib.kyori.adventure.key.Key;
import io.github.pronze.lib.kyori.adventure.nbt.api.BinaryTagHolder;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.event.HoverEvent;
import io.github.pronze.lib.kyori.adventure.text.minimessage.Context;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.ParsingException;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.Token;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.TagPart;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Transformation;
import io.github.pronze.lib.kyori.examination.Examinable;
import io.github.pronze.lib.kyori.examination.ExaminableProperty;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class HoverTransformation
extends Transformation {
    private final HoverEvent.Action<Object> action;
    private final Object value;

    public static HoverTransformation create(Context ctx, String name, List<TagPart> args) {
        Examinable value;
        if (args.size() < 2) {
            throw new ParsingException("Doesn't know how to turn " + args + " into a hover event", args);
        }
        List<TagPart> newArgs = args.subList(1, args.size());
        HoverEvent.Action<Object> action = HoverEvent.Action.NAMES.value(args.get(0).value());
        if (action == HoverEvent.Action.SHOW_TEXT) {
            value = ctx.parse(newArgs.get(0).value());
        } else if (action == HoverEvent.Action.SHOW_ITEM) {
            value = HoverTransformation.parseShowItem(newArgs);
        } else if (action == HoverEvent.Action.SHOW_ENTITY) {
            value = HoverTransformation.parseShowEntity(newArgs, ctx);
        } else {
            throw new ParsingException("Don't know how to turn '" + args + "' into a hover event", args);
        }
        return new HoverTransformation(action, value);
    }

    private static @NotNull HoverEvent.ShowItem parseShowItem(@NotNull List<TagPart> args) {
        try {
            if (args.isEmpty()) {
                throw new ParsingException("Show item hover needs at least item id!", new Token[0]);
            }
            Key key = Key.key(args.get(0).value());
            int count = args.size() >= 2 ? Integer.parseInt(args.get(1).value()) : 1;
            if (args.size() == 3) {
                return HoverEvent.ShowItem.of(key, count, BinaryTagHolder.of(args.get(2).value()));
            }
            return HoverEvent.ShowItem.of(key, count);
        }
        catch (InvalidKeyException | NumberFormatException ex) {
            throw new ParsingException("Exception parsing show_item hover", (Throwable)ex, args);
        }
    }

    private static @NotNull HoverEvent.ShowEntity parseShowEntity(@NotNull List<TagPart> args, Context context) {
        try {
            if (args.size() < 2) {
                throw new ParsingException("Show entity hover needs at least type and uuid!", new Token[0]);
            }
            Key key = Key.key(args.get(0).value());
            UUID id = UUID.fromString(args.get(1).value());
            if (args.size() == 3) {
                Component name = context.parse(args.get(2).value());
                return HoverEvent.ShowEntity.of(key, id, name);
            }
            return HoverEvent.ShowEntity.of(key, id);
        }
        catch (InvalidKeyException | IllegalArgumentException ex) {
            throw new ParsingException("Exception parsing show_entity hover", (Throwable)ex, args);
        }
    }

    private HoverTransformation(HoverEvent.Action<Object> action, Object value) {
        this.action = action;
        this.value = value;
    }

    @Override
    public Component apply() {
        return Component.empty().hoverEvent(HoverEvent.hoverEvent(this.action, this.value));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", this.action), ExaminableProperty.of("value", this.value));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HoverTransformation that = (HoverTransformation)other;
        return Objects.equals(this.action, that.action) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.action, this.value);
    }
}

