/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.inbuild;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.ParsingException;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.node.TagPart;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Transformation;
import io.github.pronze.lib.kyori.examination.ExaminableProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class InsertionTransformation
extends Transformation {
    private final String insertion;

    public static InsertionTransformation create(String name, List<TagPart> args) {
        if (args.size() != 1) {
            throw new ParsingException("Doesn't know how to turn token with name '" + name + "' and arguments " + args + " into a insertion component", args);
        }
        return new InsertionTransformation(args.get(0).value());
    }

    private InsertionTransformation(String insertion) {
        this.insertion = insertion;
    }

    @Override
    public Component apply() {
        return Component.empty().insertion(this.insertion);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("insertion", this.insertion));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InsertionTransformation that = (InsertionTransformation)other;
        return Objects.equals(this.insertion, that.insertion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.insertion);
    }
}

