/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib;

import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.Preconditions;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<className>.+)$", replaceRule="{basePackage}.{platform}.{Platform}{className}")
public abstract class CustomPayload {
    private static CustomPayload customPayload;

    @ApiStatus.Internal
    public CustomPayload() {
        Preconditions.checkArgument(customPayload == null, "CustomPayload has been already initialized!");
        customPayload = this;
    }

    public static void registerOutgoingChannel(String channel) {
        Preconditions.checkNotNull(customPayload, "CustomPayload is not initialized yet!").registerOutgoingChannel0(channel);
    }

    public static void unregisterOutgoingChannel(String channel) {
        Preconditions.checkNotNull(customPayload, "CustomPayload is not initialized yet!").unregisterOutgoingChannel0(channel);
    }

    public static void unregisterAllOutgoingChannels() {
        Preconditions.checkNotNull(customPayload, "CustomPayload is not initialized yet!").unregisterAllOutgoingChannels0();
    }

    public static Collection<String> getRegisteredOutgoingChannels() {
        return Preconditions.checkNotNull(customPayload, "CustomPayload is not initialized yet!").getRegisteredOutgoingChannels0();
    }

    public static Registration registerIncomingChannel(String channel, BiConsumer<PlayerWrapper, byte[]> listener) {
        return Preconditions.checkNotNull(customPayload, "CustomPayload is not initialized yet!").registerIncomingChannel0(channel, listener);
    }

    public static void unregisterIncomingChannel(Registration registration) {
        Preconditions.checkNotNull(customPayload, "CustomPayload is not initialized yet!").unregisterIncomingChannel0(registration);
    }

    public static void unregisterAllIncomingChannels() {
        Preconditions.checkNotNull(customPayload, "CustomPayload is not initialized yet!").unregisterAllIncomingChannels0();
    }

    public static Collection<String> getRegisteredIncomingChannels() {
        return Preconditions.checkNotNull(customPayload, "CustomPayload is not initialized yet!").getRegisteredIncomingChannels0();
    }

    public static void send(PlayerWrapper player, String channel, byte[] payload) {
        Preconditions.checkNotNull(customPayload, "CustomPayload is not initialized yet!").send0(player, channel, payload);
    }

    public static void send(String channel, byte[] payload) {
        Preconditions.checkNotNull(customPayload, "CustomPayload is not initialized yet!").send0(channel, payload);
    }

    protected abstract void registerOutgoingChannel0(String var1);

    protected abstract void unregisterOutgoingChannel0(String var1);

    protected abstract void unregisterAllOutgoingChannels0();

    protected abstract Collection<String> getRegisteredOutgoingChannels0();

    protected abstract Registration registerIncomingChannel0(String var1, BiConsumer<PlayerWrapper, byte[]> var2);

    protected abstract void unregisterIncomingChannel0(Registration var1);

    protected abstract void unregisterAllIncomingChannels0();

    protected abstract Collection<String> getRegisteredIncomingChannels0();

    protected abstract void send0(PlayerWrapper var1, String var2, byte[] var3);

    protected abstract void send0(String var1, byte[] var2);

    public static interface Registration
    extends Wrapper {
    }
}

