/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib;

import io.github.pronze.lib.screaminglib.block.BlockDataTranslatorBuilder;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.block.BlockTypeMapper;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.item.ItemTypeMapper;
import io.github.pronze.lib.screaminglib.utils.Pair;
import io.github.pronze.lib.screaminglib.utils.Platform;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostConstruct;
import io.github.pronze.lib.screaminglib.utils.key.ComplexMappingKey;
import io.github.pronze.lib.screaminglib.utils.key.MappingKey;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import io.github.pronze.lib.screaminglib.utils.key.NumericMappingKey;
import io.github.pronze.lib.screaminglib.utils.key.StringMapMappingKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<className>.+)$", replaceRule="{basePackage}.{platform}.{Platform}{className}")
public abstract class ItemBlockIdsRemapper {
    private final ItemTypeMapper itemTypeMapper;
    private final BlockTypeMapper blockTypeMapper;
    protected Platform platform;
    protected final List<MappingFlags> mappingFlags = new ArrayList<MappingFlags>();
    public static final List<String> COLORS = List.of("WHITE", "ORANGE", "MAGENTA", "LIGHT_BLUE", "YELLOW", "LIME", "PINK", "GRAY", "LIGHT_GRAY", "CYAN", "PURPLE", "BLUE", "BROWN", "GREEN", "RED", "BLACK");
    public static final Map<Predicate<BlockTypeHolder>, Function<String, Optional<BlockTypeHolder>>> colorableBlocks = new HashMap<Predicate<BlockTypeHolder>, Function<String, Optional<BlockTypeHolder>>>();
    public static final Map<Predicate<ItemTypeHolder>, Function<String, Optional<ItemTypeHolder>>> colorableItems = new HashMap<Predicate<ItemTypeHolder>, Function<String, Optional<ItemTypeHolder>>>();

    @OnPostConstruct
    public void doMapping() {
        if (this.platform == Platform.JAVA_FLATTENING) {
            this.flatteningMapping();
        }
        if (this.platform.name().startsWith("JAVA")) {
            this.flatteningLegacyMappingJava();
            if (this.platform != Platform.JAVA_FLATTENING) {
                this.flatteningMapping();
            }
            this.javaAutoColorable();
        }
    }

    private void javaAutoColorable() {
        this.makeColorable("WOOL");
        this.makeColorable("CARPET");
        this.makeColorable("CONCRETE");
        this.makeColorable("CONCRETE_POWDER");
        this.makeColorable("TERRACOTTA");
        this.makeColorable("STAINED_GLASS", "GLASS");
        this.makeColorable("STAINED_GLASS_PANE", "GLASS_PANE");
        this.makeColorable("SHULKER_BOX");
        this.makeColorable("BANNER");
        this.makeColorable("GLAZED_TERRACOTTA");
        if (!this.mappingFlags.contains((Object)MappingFlags.NO_COLORED_BEDS)) {
            this.makeColorable("BED");
        }
    }

    private void makeColorable(String baseName) {
        this.makeColorableItem(baseName, baseName);
        this.makeColorableBlock(baseName, baseName);
    }

    private void makeColorableBlock(String baseName) {
        this.makeColorableBlock(baseName, baseName);
    }

    private void makeColorableItem(String baseName) {
        this.makeColorableItem(baseName, baseName);
    }

    private void makeColorable(String baseName, String notColoredName) {
        this.makeColorableBlock(baseName, notColoredName);
        this.makeColorableItem(baseName, notColoredName);
    }

    private void makeColorableBlock(String baseName, String notColoredName) {
        ArrayList list = new ArrayList();
        COLORS.forEach(s -> BlockTypeHolder.ofOptional(s + "_" + baseName).ifPresent(materialHolder -> {
            if (!list.contains(materialHolder)) {
                list.add(materialHolder);
            }
        }));
        BlockTypeHolder.ofOptional(notColoredName).ifPresent(materialHolder -> {
            if (!list.contains(materialHolder)) {
                list.add(materialHolder);
            }
        });
        if (!list.isEmpty()) {
            colorableBlocks.put(list::contains, s -> {
                if (COLORS.contains(s.toUpperCase())) {
                    return BlockTypeHolder.ofOptional(s.toUpperCase() + "_" + baseName);
                }
                return Optional.empty();
            });
        }
    }

    private void makeColorableItem(String baseName, String notColoredName) {
        ArrayList list = new ArrayList();
        COLORS.forEach(s -> ItemTypeHolder.ofOptional(s + "_" + baseName).ifPresent(materialHolder -> {
            if (!list.contains(materialHolder)) {
                list.add(materialHolder);
            }
        }));
        ItemTypeHolder.ofOptional(notColoredName).ifPresent(materialHolder -> {
            if (!list.contains(materialHolder)) {
                list.add(materialHolder);
            }
        });
        if (!list.isEmpty()) {
            colorableItems.put(list::contains, s -> {
                if (COLORS.contains(s.toUpperCase())) {
                    return ItemTypeHolder.ofOptional(s.toUpperCase() + "_" + baseName);
                }
                return Optional.empty();
            });
        }
    }

    private void flatteningLegacyMappingJava() {
        int i;
        int i2;
        int i3;
        int i4;
        this.f2l("AIR", 0);
        this.f2l("STONE", 1);
        this.f2l("GRANITE", "STONE", 1, 1);
        this.f2l("POLISHED_GRANITE", "STONE", 1, 2);
        this.f2l("DIORITE", "STONE", 1, 3);
        this.f2l("POLISHED_DIORITE", "STONE", 1, 4);
        this.f2l("ANDESITE", "STONE", 1, 5);
        this.f2l("POLISHED_ANDESITE", "STONE", 1, 6);
        this.f2l("GRASS_BLOCK", "GRASS", 2);
        this.f2l("DIRT", 3);
        this.f2l("COARSE_DIRT", "DIRT", 3, 1);
        this.f2l("PODZOL", "DIRT", 3, 2);
        this.f2l("COBBLESTONE", 4);
        this.f2l("OAK_PLANKS", "WOOD", 5, "PLANKS");
        this.f2l("SPRUCE_PLANKS", "WOOD", 5, 1, "PLANKS");
        this.f2l("BIRCH_PLANKS", "WOOD", 5, 2, "PLANKS");
        this.f2l("JUNGLE_PLANKS", "WOOD", 5, 3, "PLANKS");
        this.f2l("ACACIA_PLANKS", "WOOD", 5, 4, "PLANKS");
        this.f2l("DARK_OAK_PLANKS", "WOOD", 5, 5, "PLANKS");
        this.f2l("OAK_SAPLING", "SAPLING", 6);
        this.f2l("SPRUCE_SAPLING", "SAPLING", 6, 1);
        this.f2l("BIRCH_SAPLING", "SAPLING", 6, 2);
        this.f2l("JUNGLE_SAPLING", "SAPLING", 6, 3);
        this.f2l("ACACIA_SAPLING", "SAPLING", 6, 4);
        this.f2l("DARK_OAK_SAPLING", "SAPLING", 6, 5);
        this.f2lBlock("OAK_SAPLING", Map.of("stage", "1"), "SAPLING", 6, 8);
        this.f2lBlock("SPRUCE_SAPLING", Map.of("stage", "1"), "SAPLING", 6, 9);
        this.f2lBlock("BIRCH_SAPLING", Map.of("stage", "1"), "SAPLING", 6, 10);
        this.f2lBlock("JUNGLE_SAPLING", Map.of("stage", "1"), "SAPLING", 6, 11);
        this.f2lBlock("ACACIA_SAPLING", Map.of("stage", "1"), "SAPLING", 6, 12);
        this.f2lBlock("DARK_OAK_SAPLING", Map.of("stage", "1"), "SAPLING", 6, 13);
        this.f2l("BEDROCK", 7);
        this.f2lBlock("WATER", "FLOWING_WATER", 8, "WATER");
        this.f2lBlock("LAVA", "FLOWING_LAVA", 10, "LAVA");
        for (int i5 = 1; i5 <= 15; ++i5) {
            this.f2lBlock("WATER", Map.of("level", String.valueOf(i5)), "FLOWING_WATER", 10, i5, "WATER");
            this.f2lBlock("LAVA", Map.of("level", String.valueOf(i5)), "FLOWING_LAVA", 10, i5, "LAVA");
        }
        this.f2l("SAND", 12);
        this.f2l("RED_SAND", "SAND", 12, 1);
        this.f2l("GRAVEL", 13);
        this.f2l("GOLD_ORE", 14);
        this.f2l("IRON_ORE", 15);
        this.f2l("COAL_ORE", 16);
        this.f2l("OAK_LOG", "LOG", 17, 0);
        this.f2l("SPRUCE_LOG", "LOG", 17, 1);
        this.f2l("BIRCH_LOG", "LOG", 17, 2);
        this.f2l("JUNGLE_LOG", "LOG", 17, 3);
        this.f2lBlock("OAK_LOG", Map.of("axis", "x"), "LOG", 17, 4);
        this.f2lBlock("SPRUCE_LOG", Map.of("axis", "x"), "LOG", 17, 5);
        this.f2lBlock("SPRUCE_LOG", Map.of("axis", "x"), "LOG", 17, 6);
        this.f2lBlock("SPRUCE_LOG", Map.of("axis", "x"), "LOG", 17, 7);
        this.f2lBlock("OAK_LOG", Map.of("axis", "z"), "LOG", 17, 8);
        this.f2lBlock("SPRUCE_LOG", Map.of("axis", "z"), "LOG", 17, 9);
        this.f2lBlock("SPRUCE_LOG", Map.of("axis", "z"), "LOG", 17, 10);
        this.f2lBlock("SPRUCE_LOG", Map.of("axis", "z"), "LOG", 17, 11);
        this.f2l("OAK_WOOD", "LOG", 17, 12);
        this.f2l("SPRUCE_WOOD", "LOG", 17, 13);
        this.f2l("BIRCH_WOOD", "LOG", 17, 14);
        this.f2l("JUNGLE_WOOD", "LOG", 17, 15);
        this.f2l("OAK_LEAVES", "LEAVES", 18, 0);
        this.f2l("SPRUCE_LEAVES", "LEAVES", 18, 1);
        this.f2l("BIRCH_LEAVES", "LEAVES", 18, 2);
        this.f2l("JUNGLE_LEAVES", "LEAVES", 18, 3);
        this.f2lBlock("OAK_LEAVES", Map.of("persistent", "true"), 18, 4);
        this.f2lBlock("SPRUCE_LEAVES", Map.of("persistent", "true"), 18, 5);
        this.f2lBlock("BIRCH_LEAVES", Map.of("persistent", "true"), 18, 6);
        this.f2lBlock("JUNGLE_LEAVES", Map.of("persistent", "true"), 18, 7);
        this.f2l("SPONGE", 19);
        this.f2l("WET_SPONGE", "SPONGE", 19, 1);
        this.f2l("GLASS", 20);
        this.f2l("LAPIS_ORE", 21);
        this.f2l("LAPIS_BLOCK", 22);
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> faced = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 7, Map.of(0, "down", 1, "up", 2, "north", 3, "south", 4, "west", 5, "east"), "north").maskedBoolean("triggered", 8).build();
        this.f2l("DISPENSER", 23);
        this.blockTypeMapper.getBlockDataTranslators().put(mappingKey -> mappingKey.is((Object)"DISPENSER"), faced);
        this.f2l("SANDSTONE", 24);
        this.f2l("CHISELED_SANDSTONE", "SANDSTONE", 24, 1);
        this.f2l("CUT_SANDSTONE", "SANDSTONE", 24, 2);
        this.f2l("NOTE_BLOCK", 25, "NOTEBLOCK");
        this.f2lColoredToNonColoredBlock("BED", "BED", 26, "BED_BLOCK");
        this.blockTypeMapper.getBlockDataTranslators().put(mappingKey -> mappingKey.is("BED", "BED_BLOCK"), new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 3, Map.of(0, "south", 1, "west", 2, "north", 3, "east"), "north").maskedBoolean("occupied", 4).maskedBoolean("part", 8, "head", "foot").build());
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> redstoneRails = new BlockDataTranslatorBuilder().lowerBitValueSet("shape", 7, Map.of(0, "north_south", 1, "east_west", 2, "ascending_east", 3, "ascending_west", 4, "ascending_north", 5, "ascending_south"), "north_south").maskedBoolean("powered", 8).build();
        this.f2l("POWERED_RAIL", 27, "GOLDEN_RAIL");
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is("POWERED_RAIL", "GOLDEN_RAIL", "DETECTOR_RAIL", "ACTIVATOR_RAIL"), redstoneRails);
        this.f2l("DETECTOR_RAIL", 28);
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> piston = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 7, Map.of(0, "down", 1, "up", 2, "north", 3, "south", 4, "west", 5, "east"), "north").maskedBoolean("extended", 8).build();
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> pistonExtension = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 7, Map.of(0, "down", 1, "up", 2, "north", 3, "south", 4, "west", 5, "east"), "north").maskedBoolean("type", 8, "sticky", "normal").build();
        this.f2l("STICKY_PISTON", 29, "PISTON_STICKY_BASE");
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is("STICKY_PISTON", "PISTON_STICKY_BASE", "PISTON", "PISTON_BASE"), piston);
        this.f2l("COBWEB", "WEB", 30);
        this.f2l("DEAD_BUSH", 32, "DEADBUSH");
        this.f2l("DEAD_BUSH", "LONG_GRASS", 31, "TALLGRASS");
        this.f2l("GRASS", "LONG_GRASS", 31, 1, "TALLGRASS");
        this.f2l("FERN", "LONG_GRASS", 31, 2, "TALLGRASS");
        this.f2l("DEAD_BUSH", "LONG_GRASS", 31, 3, "TALLGRASS");
        this.f2l("PISTON", 33, "PISTON_BASE");
        this.f2lBlock("PISTON_HEAD", 34, "PISTON_EXTENSION");
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is("PISTON_HEAD", "PISTON_EXTENSION", "MOVING_PISTON", "PISTON_MOVING_PIECE"), pistonExtension);
        this.f2lColored("WOOL", 35);
        this.f2lBlock("MOVING_PISTON", "PISTON_EXTENSION", 36, 0, "PISTON_MOVING_PIECE");
        this.f2l("DANDELION", "YELLOW_FLOWER", 37, 0);
        this.f2l("POPPY", "RED_FLOWER", 38, "RED_ROSE");
        this.f2l("BLUE_ORCHID", "RED_FLOWER", 38, 1, "RED_ROSE");
        this.f2l("ALLIUM", "RED_FLOWER", 38, 2, "RED_ROSE");
        this.f2l("AZURE_BLUET", "RED_FLOWER", 38, 3, "RED_ROSE");
        this.f2l("RED_TULIP", "RED_FLOWER", 38, 4, "RED_ROSE");
        this.f2l("ORANGE_TULIP", "RED_FLOWER", 38, 5, "RED_ROSE");
        this.f2l("WHITE_TULIP", "RED_FLOWER", 38, 6, "RED_ROSE");
        this.f2l("PINK_TULIP", "RED_FLOWER", 38, 7, "RED_ROSE");
        this.f2l("OXEYE_DAISY", "RED_FLOWER", 38, 8, "RED_ROSE");
        this.f2l("BROWN_MUSHROOM", 39);
        this.f2l("RED_MUSHROOM", 40);
        this.f2l("GOLD_BLOCK", 41);
        this.f2l("IRON_BLOCK", 42);
        this.f2l("SMOOTH_STONE_SLAB", "STONE_SLAB", 44, 0, "STEP");
        this.f2lBlock("SMOOTH_STONE_SLAB", Map.of("type", "top"), "STONE_SLAB", 44, 8, "STEP");
        this.f2lBlock("SMOOTH_STONE_SLAB", Map.of("type", "double"), "DOUBLE_STONE_SLAB", 43, 0, "DOUBLE_STEP");
        this.f2l("SANDSTONE_SLAB", "STONE_SLAB", 44, 1, "STEP");
        this.f2lBlock("SANDSTONE_SLAB", Map.of("type", "top"), "STONE_SLAB", 44, 9, "STEP");
        this.f2lBlock("SANDSTONE_SLAB", Map.of("type", "double"), "DOUBLE_STONE_SLAB", 43, 1, "DOUBLE_STEP");
        this.f2l("PETRIFIED_OAK_SLAB", "STONE_SLAB", 44, 2, "STEP");
        this.f2lBlock("PETRIFIED_OAK_SLAB", Map.of("type", "top"), "STONE_SLAB", 44, 10, "STEP");
        this.f2lBlock("PETRIFIED_OAK_SLAB", Map.of("type", "double"), "DOUBLE_STONE_SLAB", 43, 2, "DOUBLE_STEP");
        this.f2l("COBBLESTONE_SLAB", "STONE_SLAB", 44, 3, "STEP");
        this.f2lBlock("COBBLESTONE_SLAB", Map.of("type", "top"), "STONE_SLAB", 44, 11, "STEP");
        this.f2lBlock("COBBLESTONE_SLAB", Map.of("type", "double"), "DOUBLE_STONE_SLAB", 43, 3, "DOUBLE_STEP");
        this.f2l("BRICK_SLAB", "STONE_SLAB", 44, 4, "STEP");
        this.f2lBlock("BRICK_SLAB", Map.of("type", "top"), "STONE_SLAB", 44, 12, "STEP");
        this.f2lBlock("BRICK_SLAB", Map.of("type", "double"), "DOUBLE_STONE_SLAB", 43, 4, "DOUBLE_STEP");
        this.f2l("STONE_BRICK_SLAB", "STONE_SLAB", 44, 5, "STEP");
        this.f2lBlock("STONE_BRICK_SLAB", Map.of("type", "top"), "STONE_SLAB", 44, 13, "STEP");
        this.f2lBlock("STONE_BRICK_SLAB", Map.of("type", "double"), "DOUBLE_STONE_SLAB", 43, 5, "DOUBLE_STEP");
        this.f2l("NETHER_BRICK_SLAB", "STONE_SLAB", 44, 6, "STEP");
        this.f2lBlock("NETHER_BRICK_SLAB", Map.of("type", "top"), "STONE_SLAB", 44, 14, "STEP");
        this.f2lBlock("NETHER_BRICK_SLAB", Map.of("type", "double"), "DOUBLE_STONE_SLAB", 43, 6, "DOUBLE_STEP");
        this.f2l("QUARTZ_SLAB", "STONE_SLAB", 44, 7, "STEP");
        this.f2lBlock("QUARTZ_SLAB", Map.of("type", "top"), "STONE_SLAB", 44, 15, "STEP");
        this.f2lBlock("QUARTZ_SLAB", Map.of("type", "double"), "DOUBLE_STONE_SLAB", 43, 7, "DOUBLE_STEP");
        this.f2l("BRICKS", "BRICK_BLOCK", 45, "BRICK");
        this.f2l("TNT", 46);
        this.f2l("BOOKSHELF", 47);
        this.f2l("MOSSY_COBBLESTONE", 48);
        this.f2l("OBSIDIAN", 49);
        this.f2lItem("TORCH", 50);
        this.f2lBlock("WALL_TORCH", Map.of("facing", "east"), "TORCH", 50, 1);
        this.f2lBlock("WALL_TORCH", Map.of("facing", "west"), "TORCH", 50, 2);
        this.f2lBlock("WALL_TORCH", Map.of("facing", "south"), "TORCH", 50, 3);
        this.f2lBlock("WALL_TORCH", "TORCH", 50, 4);
        this.f2lBlock("TORCH", "TORCH", 50, 5);
        this.f2lBlock("FIRE", 51);
        for (int i6 = 1; i6 <= 15; ++i6) {
            this.f2lBlock("FIRE", Map.of("age", String.valueOf(i6)), 51, i6);
        }
        this.f2l("SPAWNER", "MOB_SPAWNER", 52);
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> stairs = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 3, Map.of(0, "east", 1, "west", 2, "south", 3, "north"), "north").maskedBoolean("half", 4, "top", "bottom").build();
        this.f2l("OAK_STAIRS", "WOOD_STAIRS", 53);
        this.blockTypeMapper.getBlockDataTranslators().put(namespacedMappingKey -> namespacedMappingKey.getKey().toUpperCase().endsWith("_STAIRS"), stairs);
        this.f2lItem("CHEST", 54);
        this.f2lBlock("CHEST", "CHEST", 54, 2);
        this.f2lBlock("CHEST", Map.of("facing", "south"), 54, 3);
        this.f2lBlock("CHEST", Map.of("facing", "west"), 54, 4);
        this.f2lBlock("CHEST", Map.of("facing", "east"), 54, 5);
        this.f2lBlock("REDSTONE_WIRE", 55);
        for (i4 = 1; i4 <= 15; ++i4) {
            this.f2lBlock("REDSTONE_WIRE", Map.of("power", String.valueOf(i4)), 55, i4);
        }
        this.f2l("DIAMOND_ORE", 56);
        this.f2l("DIAMOND_BLOCK", 57);
        this.f2l("CRAFTING_TABLE", 58, "WORKBENCH");
        this.f2lBlock("WHEAT", 59, "CROPS");
        this.f2l("FARMLAND", 60, "SOIL");
        for (i4 = 1; i4 <= 7; ++i4) {
            this.f2lBlock("WHEAT", Map.of("age", String.valueOf(i4)), 59, i4, "CROPS");
            this.f2lBlock("FARMLAND", Map.of("moisture", String.valueOf(i4)), 60, i4, "SOIL");
        }
        this.f2lItem("FURNACE", 61);
        this.f2lBlock("FURNACE", "FURNACE", 61, 2);
        this.f2lBlock("FURNACE", Map.of("facing", "south"), 61, 3);
        this.f2lBlock("FURNACE", Map.of("facing", "west"), 61, 4);
        this.f2lBlock("FURNACE", Map.of("facing", "east"), 61, 5);
        this.f2lBlock("LIT_FURNACE", Map.of("lit", "true"), 62, 2, "BURNING_FURNACE");
        this.f2lBlock("LIT_FURNACE", Map.of("lit", "true", "facing", "north"), 62, 2, "BURNING_FURNACE");
        this.f2lBlock("LIT_FURNACE", Map.of("lit", "true", "facing", "south"), 62, 3, "BURNING_FURNACE");
        this.f2lBlock("LIT_FURNACE", Map.of("lit", "true", "facing", "west"), 62, 4, "BURNING_FURNACE");
        this.f2lBlock("LIT_FURNACE", Map.of("lit", "true", "facing", "east"), 62, 5, "BURNING_FURNACE");
        this.f2lBlock("OAK_SIGN", "STANDING_SIGN", 63, "SIGN_POST");
        for (i4 = 1; i4 <= 15; ++i4) {
            this.f2lBlock("OAK_SIGN", Map.of("rotation", String.valueOf(i4)), "STANDING_SIGN", 63, i4, "SIGN_POST");
        }
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> lowerDoor = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 3, Map.of(0, "east", 1, "south", 2, "west", 3, "north"), "north").maskedBoolean("open", 4).build();
        this.f2lBlock("OAK_DOOR", "WOODEN_DOOR", 64);
        this.blockTypeMapper.getBlockDataTranslators().put(namespacedMappingKey -> namespacedMappingKey.getKey().toUpperCase().endsWith("_DOOR"), lowerDoor);
        this.f2lItem("LADDER", 65);
        this.f2lBlock("LADDER", "LADDER", 65, 2);
        this.f2lBlock("LADDER", Map.of("facing", "south"), 65, 3);
        this.f2lBlock("LADDER", Map.of("facing", "west"), 65, 4);
        this.f2lBlock("LADDER", Map.of("facing", "east"), 65, 5);
        this.f2l("RAIL", 66, "RAILS");
        this.f2lBlock("RAIL", Map.of("shape", "east_west"), 66, 1, "RAILS");
        this.f2lBlock("RAIL", Map.of("shape", "ascending_east"), 66, 2, "RAILS");
        this.f2lBlock("RAIL", Map.of("shape", "ascending_west"), 66, 3, "RAILS");
        this.f2lBlock("RAIL", Map.of("shape", "ascending_north"), 66, 4, "RAILS");
        this.f2lBlock("RAIL", Map.of("shape", "ascending_south"), 66, 5, "RAILS");
        this.f2lBlock("RAIL", Map.of("shape", "south_east"), 66, 6, "RAILS");
        this.f2lBlock("RAIL", Map.of("shape", "south_west"), 66, 7, "RAILS");
        this.f2lBlock("RAIL", Map.of("shape", "north_west"), 66, 8, "RAILS");
        this.f2lBlock("RAIL", Map.of("shape", "north_east"), 66, 9, "RAILS");
        this.f2l("COBBLESTONE_STAIRS", 67, "STONE_STAIRS");
        this.f2lBlock("OAK_WALL_SIGN", "OAK_WALL_SIGN", 68);
        this.f2lBlock("OAK_WALL_SIGN", Map.of("facing", "south"), 68, 3);
        this.f2lBlock("OAK_WALL_SIGN", Map.of("facing", "west"), 68, 4);
        this.f2lBlock("OAK_WALL_SIGN", Map.of("facing", "east"), 68, 5);
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> lever = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 7, Map.of(0, "east", 1, "east", 2, "west", 3, "south", 4, "north", 5, "south", 6, "east", 7, "south"), "north").maskedBoolean("powered", 8).build();
        this.f2l("LEVER", 69);
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is((Object)"LEVER"), lever);
        this.f2l("STONE_PRESSURE_PLATE", 70, "STONE_PLATE");
        this.f2lBlock("STONE_PRESSURE_PLATE", Map.of("powered", "true"), 70, 1, "STONE_PLATE");
        this.f2lBlock("IRON_DOOR", 71, "IRON_DOOR_BLOCK");
        this.f2l("OAK_PRESSURE_PLATE", "WOODEN_PRESSURE_PLATE", 72, "WOOD_PLATE");
        this.f2lBlock("OAK_PRESSURE_PLATE", Map.of("powered", "true"), "WOODEN_PRESSURE_PLATE", 72, 1, "WOOD_PLATE");
        this.f2l("REDSTONE_ORE", 73);
        this.f2lBlock("REDSTONE_ORE", Map.of("lit", "true"), "LIT_REDSTONE_ORE", 74, 0, "GLOWING_REDSTONE_ORE");
        this.f2lBlock("WALL_REDSTONE_TORCH", Map.of("facing", "east", "lit", "false"), "UNLIT_REDSTONE_TORCH", 76, 1, "REDSTONE_TORCH_OFF");
        this.f2lBlock("WALL_REDSTONE_TORCH", Map.of("facing", "west", "lit", "false"), "UNLIT_REDSTONE_TORCH", 76, 2, "REDSTONE_TORCH_OFF");
        this.f2lBlock("WALL_REDSTONE_TORCH", Map.of("facing", "south", "lit", "false"), "UNLIT_REDSTONE_TORCH", 76, 3, "REDSTONE_TORCH_OFF");
        this.f2lBlock("WALL_REDSTONE_TORCH", Map.of("facing", "north", "lit", "false"), "UNLIT_REDSTONE_TORCH", 76, 4, "REDSTONE_TORCH_OFF");
        this.f2lBlock("WALL_REDSTONE_TORCH", Map.of("lit", "false"), "UNLIT_REDSTONE_TORCH", 76, 4, "REDSTONE_TORCH_OFF");
        this.f2lBlock("REDSTONE_TORCH", Map.of("lit", "false"), "UNLIT_REDSTONE_TORCH", 76, 5, "REDSTONE_TORCH_OFF");
        this.f2lItem("REDSTONE_TORCH", "REDSTONE_TORCH", 76, "REDSTONE_TORCH_ON");
        this.f2lBlock("WALL_REDSTONE_TORCH", Map.of("facing", "east"), "REDSTONE_TORCH", 76, 1, "REDSTONE_TORCH_ON");
        this.f2lBlock("WALL_REDSTONE_TORCH", Map.of("facing", "west"), "REDSTONE_TORCH", 76, 2, "REDSTONE_TORCH_ON");
        this.f2lBlock("WALL_REDSTONE_TORCH", Map.of("facing", "south"), "REDSTONE_TORCH", 76, 3, "REDSTONE_TORCH_ON");
        this.f2lBlock("WALL_REDSTONE_TORCH", "REDSTONE_TORCH", 76, 4, "REDSTONE_TORCH_ON");
        this.f2lBlock("REDSTONE_TORCH", "REDSTONE_TORCH", 76, 5, "REDSTONE_TORCH_ON");
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> button = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 7, Map.of(0, "north", 1, "east", 2, "west", 3, "south", 4, "north", 5, "north"), "north").maskedBoolean("powered", 8).build();
        this.f2l("STONE_BUTTON", 77);
        this.blockTypeMapper.getBlockDataTranslators().put(namespacedMappingKey -> namespacedMappingKey.getKey().toUpperCase().endsWith("_BUTTON"), button);
        this.f2l("SNOW", 78, "SNOW_LAYER");
        for (i3 = 1; i3 <= 7; ++i3) {
            this.f2lBlock("SNOW", Map.of("layers", String.valueOf(i3 + 1)), 78, i3, "SNOW_LAYER");
        }
        this.f2l("ICE", 79);
        this.f2l("SNOW_BLOCK", 80, "SNOW");
        this.f2l("CACTUS", 81);
        for (i3 = 1; i3 <= 15; ++i3) {
            this.f2lBlock("CACTUS", Map.of("age", String.valueOf(i3)), 81, i3);
        }
        this.f2l("CLAY", 82);
        this.f2lBlock("SUGAR_CANE", "REEDS", 83, "SUGAR_CANE_BLOCK");
        for (i3 = 1; i3 <= 15; ++i3) {
            this.f2lBlock("SUGAR_CANE", Map.of("age", String.valueOf(i3)), "REEDS", 83, i3, "SUGAR_CANE_BLOCK");
        }
        this.f2l("JUKEBOX", 84);
        this.f2lBlock("JUKEBOX", Map.of("has_record", "true"), 84, 1);
        this.f2l("OAK_FENCE", "FENCE", 85);
        this.f2l("CARVED_PUMPKIN", "PUMPKIN", 86);
        this.f2lBlock("CARVED_PUMPKIN", Map.of("facing", "west"), "PUMPKIN", 86, 1);
        this.f2lBlock("CARVED_PUMPKIN", Map.of("facing", "north"), "PUMPKIN", 86, 2);
        this.f2lBlock("CARVED_PUMPKIN", Map.of("facing", "east"), "PUMPKIN", 86, 3);
        this.f2l("NETHERRACK", 87);
        this.f2l("SOUL_SAND", 88);
        this.f2l("GLOWSTONE", 89);
        this.f2lBlock("NETHER_PORTAL", "PORTAL", 90);
        this.f2lBlock("NETHER_PORTAL", Map.of("axis", "x"), "PORTAL", 90, 1);
        this.f2lBlock("NETHER_PORTAL", Map.of("axis", "z"), "PORTAL", 90, 2);
        this.f2l("JACK_O_LANTERN", 91, "LIT_PUMPKIN");
        this.f2lBlock("JACK_O_LANTERN", Map.of("facing", "west"), "LIT_PUMPKIN", 91, 1);
        this.f2lBlock("JACK_O_LANTERN", Map.of("facing", "north"), "LIT_PUMPKIN", 91, 2);
        this.f2lBlock("JACK_O_LANTERN", Map.of("facing", "east"), "LIT_PUMPKIN", 91, 3);
        this.f2lBlock("CAKE", 92, "CAKE_BLOCK");
        for (i3 = 1; i3 <= 6; ++i3) {
            this.f2lBlock("CAKE", Map.of("bites", String.valueOf(i3)), 92, i3, "CAKE_BLOCK");
        }
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> repeater = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 3, Map.of(0, "north", 1, "east", 2, "south", 3, "west"), "north").lowerBitValueSet("delay", 12, Map.of(0, "1", 1, "2", 2, "3", 3, "4"), "1").build();
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is("UNPOWERED_REPEATER", "POWERED_REPEATER", "DIODE_BLOCK_OFF", "REPEATER", "DIODE_BLOCK_ON"), repeater);
        this.f2lBlock("REPEATER", "UNPOWERED_REPEATER", 93, "DIODE_BLOCK_OFF");
        this.f2lBlock("REPEATER", Map.of("powered", "true"), "POWERED_REPEATER", 94, 0, "DIODE_BLOCK_ON");
        this.f2lColored("STAINED_GLASS", 95);
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> trapdoor = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 3, Map.of(0, "south", 1, "north", 2, "east", 3, "west"), "north").maskedBoolean("open", 4).maskedBoolean("half", 8, "top", "bottom").build();
        this.blockTypeMapper.getBlockDataTranslators().put(namespacedMappingKey -> namespacedMappingKey.getKey().toUpperCase().replace("_", "").endsWith("TRAPDOOR"), trapdoor);
        this.f2l("OAK_TRAPDOOR", "TRAPDOOR", 96, "TRAP_DOOR");
        this.f2l("INFESTED_STONE", "MONSTER_EGGS", 97, 0);
        this.f2l("INFESTED_COBBLESTONE", "MONSTER_EGGS", 97, 1);
        this.f2l("INFESTED_STONE_BRICKS", "MONSTER_EGGS", 97, 2);
        this.f2l("INFESTED_MOSSY_STONE_BRICKS", "MONSTER_EGGS", 97, 3);
        this.f2l("INFESTED_CRACKED_STONE_BRICKS", "MONSTER_EGGS", 97, 4);
        this.f2l("INFESTED_CHISELED_STONE_BRICKS", "MONSTER_EGGS", 97, 5);
        this.f2l("STONE_BRICKS", "STONEBRICK", 98, 0, "SMOOTH_BRICK");
        this.f2l("MOSSY_STONE_BRICKS", "STONEBRICK", 98, 1, "SMOOTH_BRICK");
        this.f2l("CRACKED_STONE_BRICKS", "STONEBRICK", 98, 2, "SMOOTH_BRICK");
        this.f2l("CHISELED_STONE_BRICKS", "STONEBRICK", 98, 3, "SMOOTH_BRICK");
        this.f2l("BROWN_MUSHROOM_BLOCK", 99, "HUGE_MUSHROOM_1");
        this.f2l("RED_MUSHROOM_BLOCK", 100, "HUGE_MUSHROOM_2");
        this.f2l("IRON_BARS", 101, "IRON_FENCE");
        this.f2l("GLASS_PANE", 102, "THIN_GLASS");
        this.f2l("MELON", "MELON_BLOCK", 103);
        this.f2lBlock("PUMPKIN_STEM", 104);
        this.f2lBlock("MELON_STEM", 105);
        for (int i7 = 1; i7 <= 7; ++i7) {
            this.f2lBlock("PUMPKIN_STEM", Map.of("age", String.valueOf(i7)), 104, i7);
            this.f2lBlock("MELON_STEM", Map.of("age", String.valueOf(i7)), 105, i7);
        }
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> vine = new BlockDataTranslatorBuilder().maskedBoolean("south", 1).maskedBoolean("west", 2).maskedBoolean("north", 4).maskedBoolean("east", 8).build();
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is((Object)"VINE"), vine);
        this.f2l("VINE", 106);
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> gate = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 3, Map.of(0, "south", 1, "west", 2, "north", 3, "east"), "north").maskedBoolean("open", 4).build();
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.value().toUpperCase().endsWith("FENCE_GATE"), gate);
        this.f2l("OAK_FENCE_GATE", "FENCE_GATE", 107);
        this.f2l("BRICK_STAIRS", 108);
        this.f2l("STONE_BRICK_STAIRS", 109, "SMOOTH_STAIRS");
        this.f2l("MYCELIUM", 110, "MYCEL");
        this.f2l("LILY_PAD", "WATERLILY", 111, "WATER_LILY");
        this.f2l("NETHER_BRICKS", "NETHER_BRICK", 112);
        this.f2l("NETHER_BRICK_FENCE", 113, "NETHER_FENCE");
        this.f2l("NETHER_BRICK_STAIRS", 114);
        this.f2lBlock("NETHER_WART", 115, "NETHER_WARTS");
        for (int i8 = 1; i8 <= 3; ++i8) {
            this.f2lBlock("NETHER_WART", Map.of("age", String.valueOf(i8)), 115, i8, "NETHER_WARTS");
        }
        this.f2l("ENCHANTING_TABLE", 116, "ENCHANTMENT_TABLE");
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> brewing = new BlockDataTranslatorBuilder().maskedBoolean("has_bottle_0", 1).maskedBoolean("has_bottle_1", 2).maskedBoolean("has_bottle_2", 4).build();
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is((Object)"BREWING_STAND"), brewing);
        this.f2lBlock("BREWING_STAND", 117);
        this.f2lBlock("CAULDRON", 118);
        for (int i9 = 1; i9 <= 3; ++i9) {
            this.f2lBlock("WATER_CAULDRON", Map.of("level", String.valueOf(i9)), 118, i9);
        }
        this.f2lBlock("END_PORTAL", 119, "ENDER_PORTAL");
        this.f2lBlock("END_PORTAL_FRAME", 120, "ENDER_PORTAL_FRAME");
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> enderPortal = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 3, Map.of(0, "south", 1, "west", 2, "north", 3, "east"), "north").maskedBoolean("eye", 4).build();
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is("END_PORTAL_FRAME", "ENDER_PORTAL_FRAME"), enderPortal);
        this.f2l("END_STONE_BRICKS", "END_BRICKS", 121, "ENDER_STONE");
        this.f2l("DRAGON_EGG", 122);
        this.f2l("REDSTONE_LAMP", 123, "REDSTONE_LAMP_OFF");
        this.f2lBlock("REDSTONE_LAMP", Map.of("lit", "true"), "LIT_REDSTONE_LAMP", 124, 0, "REDSTONE_LAMP_ON");
        this.f2l("OAK_SLAB", "WOODEN_SLAB", 126, 0, "WOOD_STEP");
        this.f2lBlock("OAK_SLAB", Map.of("type", "top"), "WOODEN_SLAB", 126, 8, "WOOD_STEP");
        this.f2lBlock("OAK_SLAB", Map.of("type", "double"), "DOUBLE_WOODEN_SLAB", 125, 0, "WOOD_DOUBLE_STEP");
        this.f2l("SPRUCE_SLAB", "WOODEN_SLAB", 126, 1, "WOOD_STEP");
        this.f2lBlock("SPRUCE_SLAB", Map.of("type", "top"), "WOODEN_SLAB", 126, 9, "WOOD_STEP");
        this.f2lBlock("SPRUCE_SLAB", Map.of("type", "double"), "DOUBLE_WOODEN_SLAB", 125, 1, "WOOD_DOUBLE_STEP");
        this.f2l("BIRCH_SLAB", "WOODEN_SLAB", 126, 2, "WOOD_STEP");
        this.f2lBlock("BIRCH_SLAB", Map.of("type", "top"), "WOODEN_SLAB", 126, 10, "WOOD_STEP");
        this.f2lBlock("BIRCH_SLAB", Map.of("type", "double"), "DOUBLE_WOODEN_SLAB", 125, 2, "WOOD_DOUBLE_STEP");
        this.f2l("JUNGLE_SLAB", "WOODEN_SLAB", 126, 3, "WOOD_STEP");
        this.f2lBlock("JUNGLE_SLAB", Map.of("type", "top"), "WOODEN_SLAB", 126, 11, "WOOD_STEP");
        this.f2lBlock("JUNGLE_SLAB", Map.of("type", "double"), "DOUBLE_WOODEN_SLAB", 125, 3, "WOOD_DOUBLE_STEP");
        this.f2l("ACACIA_SLAB", "WOODEN_SLAB", 126, 4, "WOOD_STEP");
        this.f2lBlock("ACACIA_SLAB", Map.of("type", "top"), "WOODEN_SLAB", 126, 12, "WOOD_STEP");
        this.f2lBlock("ACACIA_SLAB", Map.of("type", "double"), "DOUBLE_WOODEN_SLAB", 125, 4, "WOOD_DOUBLE_STEP");
        this.f2l("DARK_OAK_SLAB", "WOODEN_SLAB", 126, 5, "WOOD_STEP");
        this.f2lBlock("DARK_OAK_SLAB", Map.of("type", "top"), "WOODEN_SLAB", 126, 13, "WOOD_STEP");
        this.f2lBlock("DARK_OAK_SLAB", Map.of("type", "double"), "DOUBLE_WOODEN_SLAB", 125, 5, "WOOD_DOUBLE_STEP");
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> cocoa = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 3, Map.of(0, "north", 1, "east", 2, "south", 3, "west"), "north").lowerBitValueSet("age", 12, Map.of(0, "0", 1, "1", 2, "2"), "0").build();
        this.f2lBlock("COCOA", 127);
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is((Object)"COCOA"), cocoa);
        this.f2l("SANDSTONE_STAIRS", 128);
        this.f2l("EMERALD_ORE", 129);
        this.f2lItem("ENDER_CHEST", 130);
        this.f2lBlock("ENDER_CHEST", "ENDER_CHEST", 130, 2);
        this.f2lBlock("ENDER_CHEST", Map.of("facing", "south"), 130, 3);
        this.f2lBlock("ENDER_CHEST", Map.of("facing", "west"), 130, 4);
        this.f2lBlock("ENDER_CHEST", Map.of("facing", "east"), 130, 5);
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> hook = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 3, Map.of(0, "south", 1, "west", 2, "north", 3, "east"), "north").maskedBoolean("attached", 4).maskedBoolean("powered", 8).build();
        this.f2l("TRIPWIRE_HOOK", 131);
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is((Object)"TRIPWIRE_HOOK"), hook);
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> tripwire = new BlockDataTranslatorBuilder().maskedBoolean("powered", 1).maskedBoolean("attached", 4).maskedBoolean("disarmed", 8).build();
        this.f2lBlock("TRIPWIRE", 132);
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is((Object)"TRIPWIRE"), tripwire);
        this.f2l("EMERALD_BLOCK", 133);
        this.f2l("SPRUCE_STAIRS", 134, "SPRUCE_WOOD_STAIRS");
        this.f2l("BIRCH_STAIRS", 135, "BIRCH_WOOD_STAIRS");
        this.f2l("JUNGLE_STAIRS", 136, "JUNGLE_WOOD_STAIRS");
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> command = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 7, Map.of(0, "down", 1, "up", 2, "north", 3, "south", 4, "west", 5, "east"), "north").maskedBoolean("conditional", 8).build();
        this.f2l("COMMAND_BLOCK", 137, "COMMAND");
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is("COMMAND", "COMMAND_BLOCK", "REPEATING_COMMAND_BLOCK", "CHAIN_COMMAND_BLOCK", "COMMAND_CHAIN", "COMMAND_REPEATING"), command);
        this.f2l("BEACON", 138);
        this.f2l("COBBLESTONE_WALL", 139, "COBBLE_WALL");
        this.f2l("MOSSY_COBBLESTONE_WALL", "COBBLESTONE_WALL", 139, 1, "COBBLE_WALL");
        this.f2lBlock("FLOWER_POT", 140);
        this.f2lBlock("CARROTS", 141, "CARROT");
        this.f2lBlock("POTATOES", 142, "POTATO");
        for (i2 = 1; i2 <= 7; ++i2) {
            this.f2lBlock("CARROTS", Map.of("age", String.valueOf(i2)), 141, i2, "CARROT");
            this.f2lBlock("POTATOES", Map.of("age", String.valueOf(i2)), 142, i2, "POTATO");
        }
        this.f2l("OAK_BUTTON", "WOODEN_BUTTON", 143, "WOOD_BUTTON");
        this.f2lBlock("SKELETON_SKULL", "SKULL", 144, 1);
        this.f2lBlock("SKELETON_WALL_SKULL", "SKULL", 144, 2);
        this.f2lBlock("SKELETON_WALL_SKULL", Map.of("facing", "south"), "SKULL", 144, 3);
        this.f2lBlock("SKELETON_WALL_SKULL", Map.of("facing", "west"), "SKULL", 144, 4);
        this.f2lBlock("SKELETON_WALL_SKULL", Map.of("facing", "east"), "SKULL", 144, 5);
        this.f2l("ANVIL", 145);
        this.f2l("CHIPPED_ANVIL", "ANVIL", 145, 1);
        this.f2l("DAMAGED_ANVIL", "ANVIL", 145, 2);
        this.f2lItem("TRAPPED_CHEST", 146);
        this.f2lBlock("TRAPPED_CHEST", "TRAPPED_CHEST", 146, 2);
        this.f2lBlock("TRAPPED_CHEST", Map.of("facing", "south"), 146, 3);
        this.f2lBlock("TRAPPED_CHEST", Map.of("facing", "west"), 146, 4);
        this.f2lBlock("TRAPPED_CHEST", Map.of("facing", "east"), 146, 5);
        this.f2l("LIGHT_WEIGHTED_PRESSURE_PLATE", 147, "GOLD_PLATE");
        this.f2l("HEAVY_WEIGHTED_PRESSURE_PLATE", 148, "IRON_PLATE");
        for (i2 = 1; i2 <= 15; ++i2) {
            this.f2lBlock("LIGHT_WEIGHTED_PRESSURE_PLATE", Map.of("power", String.valueOf(i2)), 147, i2, "GOLD_PLATE");
            this.f2lBlock("HEAVY_WEIGHTED_PRESSURE_PLATE", Map.of("power", String.valueOf(i2)), 148, i2, "IRON_PLATE");
        }
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> comparator = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 3, Map.of(0, "north", 1, "east", 2, "south", 3, "west"), "north").maskedBoolean("mode", 4, "subtract", "compare").maskedBoolean("powered", 8).build();
        this.blockTypeMapper.getBlockDataTranslators().put(k -> k.is("UNPOWERED_COMPARATOR", "REDSTONE_COMPARATOR_OFF", "COMPARATOR"), comparator);
        this.f2lBlock("COMPARATOR", "POWERED_COMPARATOR", 149, "REDSTONE_COMPARATOR_OFF");
        this.f2l("DAYLIGHT_DETECTOR", 151);
        for (int i10 = 1; i10 <= 15; ++i10) {
            this.f2lBlock("DAYLIGHT_DETECTOR", Map.of("power", String.valueOf(i10)), 151, i10);
        }
        this.f2l("REDSTONE_BLOCK", 152);
        this.f2l("NETHER_QUARTZ_ORE", 153, "QUARTZ_ORE");
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> hopper = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 7, Map.of(0, "down", 2, "north", 3, "south", 4, "west", 5, "east"), "north").maskedBoolean("enabled", 8).build();
        this.f2l("HOPPER", 154);
        this.blockTypeMapper.getBlockDataTranslators().put(mappingKey -> mappingKey.is((Object)"HOPPER"), hopper);
        this.f2l("QUARTZ_BLOCK", 155);
        this.f2l("CHISELED_QUARTZ_BLOCK", "QUARTZ_BLOCK", 155, 1);
        this.f2l("QUARTZ_PILLAR", "QUARTZ_BLOCK", 155, 2);
        this.f2l("QUARTZ_STAIRS", 156);
        this.f2l("ACTIVATOR_RAIL", 157);
        this.f2l("DROPPER", 158);
        this.blockTypeMapper.getBlockDataTranslators().put(mappingKey -> mappingKey.is((Object)"DROPPER"), faced);
        this.f2lColored("TERRACOTTA", "STAINED_HARDENED_CLAY", 159, "STAINED_CLAY");
        this.f2lColored("STAINED_GLASS_PANE", 160);
        this.f2l("ACACIA_LEAVES", "LEAVES2", 161, 0, "LEAVES_2");
        this.f2l("DARK_OAK_LEAVES", "LEAVES2", 161, 1, "LEAVES_2");
        this.f2lBlock("ACACIA_LEAVES", Map.of("persistent", "true"), "LEAVES2", 161, 4, "LEAVES_2");
        this.f2lBlock("DARK_OAK_LEAVES", Map.of("persistent", "true"), "LEAVES2", 161, 5, "LEAVES_2");
        this.f2l("ACACIA_LOG", "LOG2", 162, 0, "LOG_2");
        this.f2l("DARK_OAK_LOG", "LOG2", 162, 1, "LOG_2");
        this.f2lBlock("ACACIA_LOG", Map.of("axis", "x"), "LOG2", 162, 4, "LOG_2");
        this.f2lBlock("DARK_OAK_LOG", Map.of("axis", "x"), "LOG2", 162, 5, "LOG_2");
        this.f2lBlock("ACACIA_LOG", Map.of("axis", "z"), "LOG2", 162, 8, "LOG_2");
        this.f2lBlock("DARK_OAK_LOG", Map.of("axis", "z"), "LOG2", 162, 9, "LOG_2");
        this.f2l("ACACIA_WOOD", "LOG2", 162, 12, "LOG_2");
        this.f2l("DARK_OAK_WOOD", "LOG2", 162, 13, "LOG_2");
        this.f2l("ACACIA_STAIRS", 163);
        this.f2l("DARK_OAK_STAIRS", 164);
        this.f2l("SLIME_BLOCK", 165, "SLIME");
        this.f2l("BARRIER", 166);
        this.f2l("IRON_TRAPDOOR", 167);
        this.f2l("PRISMARINE", 168);
        this.f2l("PRISMARINE_BRICKS", "PRISMARINE", 168, 1);
        this.f2l("DARK_PRISMARINE", "PRISMARINE", 168, 1);
        this.f2l("SEA_LANTERN", 169);
        this.f2l("HAY_BLOCK", 170);
        this.f2lColored("CARPET", 171);
        this.f2l("TERRACOTTA", "hardened_clay", 172, "HARD_CLAY");
        this.f2l("COAL_BLOCK", 173);
        this.f2l("PACKED_ICE", 174);
        this.f2l("SUNFLOWER", "DOUBLE_PLANT", 175, 0);
        this.f2l("LILAC", "DOUBLE_PLANT", 175, 1);
        this.f2l("TALL_GRASS", "DOUBLE_PLANT", 175, 2);
        this.f2l("LARGE_FERN", "DOUBLE_PLANT", 175, 3);
        this.f2l("ROSE_BUSH", "DOUBLE_PLANT", 175, 4);
        this.f2l("PEONY", "DOUBLE_PLANT", 175, 5);
        this.f2lColoredBlock("BANNER", "STANDING_BANNER", 176);
        this.f2lColoredBlock("WALL_BANNER", 177);
        this.f2lBlock("DAYLIGHT_DETECTOR", Map.of("inverted", "true"), "DAYLIGHT_DETECTOR_INVERTED", 178, 0);
        this.f2lBlock("DAYLIGHT_DETECTOR", Map.of("inverted", "true", "power", "0"), "DAYLIGHT_DETECTOR_INVERTED", 178, 0);
        for (i = 1; i <= 15; ++i) {
            this.f2lBlock("DAYLIGHT_DETECTOR", Map.of("inverted", "true", "power", String.valueOf(i)), "DAYLIGHT_DETECTOR_INVERTED", 178, i);
        }
        this.f2l("RED_SANDSTONE", 179);
        this.f2l("CHISELED_RED_SANDSTONE", "RED_SANDSTONE", 179, 1);
        this.f2l("CUT_RED_SANDSTONE", "RED_SANDSTONE", 179, 2);
        this.f2l("RED_SANDSTONE_STAIRS", 180);
        this.f2l("SMOOTH_RED_SANDSTONE", "DOUBLE_STONE_SLAB2", 181);
        this.f2l("RED_SANDSTONE_SLAB", "STONE_SLAB2", 182);
        this.f2lBlock("RED_SANDSTONE_SLAB", Map.of("type", "top"), "STONE_SLAB2", 182, 8);
        this.f2lBlock("RED_SANDSTONE_SLAB", Map.of("type", "double"), "DOUBLE_STONE_SLAB2", 181, 0);
        this.f2l("SPRUCE_FENCE_GATE", 183);
        this.f2l("BIRCH_FENCE_GATE", 184);
        this.f2l("JUNGLE_FENCE_GATE", 185);
        this.f2l("DARK_OAK_FENCE_GATE", 186);
        this.f2l("ACACIA_FENCE_GATE", 187);
        this.f2l("SPRUCE_FENCE", 188);
        this.f2l("BIRCH_FENCE", 189);
        this.f2l("JUNGLE_FENCE", 190);
        this.f2l("DARK_OAK_FENCE", 191);
        this.f2l("ACACIA_FENCE", 192);
        this.f2lBlock("SPRUCE_DOOR", 193);
        this.f2lBlock("BIRCH_DOOR", 194);
        this.f2lBlock("JUNGLE_DOOR", 195);
        this.f2lBlock("ACACIA_DOOR", 196);
        this.f2lBlock("DARK_OAK_DOOR", 197);
        this.f2l("END_ROD", 198);
        this.f2lBlock("END_ROD", Map.of("facing", "up"), 198, 1);
        this.f2lBlock("END_ROD", Map.of("facing", "north"), 198, 2);
        this.f2lBlock("END_ROD", Map.of("facing", "south"), 198, 3);
        this.f2lBlock("END_ROD", Map.of("facing", "west"), 198, 4);
        this.f2lBlock("END_ROD", Map.of("facing", "east"), 198, 5);
        this.f2l("CHORUS_PLANT", 199);
        this.f2l("CHORUS_FLOWER", 200);
        for (i = 1; i <= 5; ++i) {
            this.f2lBlock("CHORUS_FLOWER", Map.of("age", String.valueOf(i)), 200, i);
        }
        this.f2l("PURPUR_BLOCK", 201);
        this.f2l("PURPUR_PILLAR", 202);
        this.f2l("PURPUR_STAIRS", 203);
        this.f2l("PURPUR_SLAB", 205);
        this.f2lBlock("PURPUR_SLAB", Map.of("type", "top"), "PURPUR_SLAB", 182, 8);
        this.f2lBlock("PURPUR_SLAB", Map.of("type", "double"), "PURPUR_DOUBLE_SLAB", 204, 0);
        this.f2l("END_BRICKS", 206);
        this.f2lBlock("BEETROOTS", 207, "BEETROOTS");
        for (i = 0; i <= 3; ++i) {
            this.f2lBlock("BEETROOTS", Map.of("age", String.valueOf(i)), 207, i, "BEETROOTS");
        }
        this.f2l("GRASS_PATH", 208);
        this.f2lBlock("END_GATEWAY", 209);
        this.f2l("REPEATING_COMMAND_BLOCK", 210, "COMMAND_REPEATING");
        this.f2l("CHAIN_COMMAND_BLOCK", 211, "COMMAND_CHAIN");
        this.f2l("FROSTED_ICE", 212);
        this.f2l("MAGMA_BLOCK", "MAGMA", 213);
        this.f2l("NETHER_WART_BLOCK", 214);
        this.f2l("RED_NETHER_BRICKS", "RED_NETHER_BRICK", 215);
        this.f2l("BONE_BLOCK", 216);
        this.f2l("STRUCTURE_VOID", 217);
        Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> observer = new BlockDataTranslatorBuilder().lowerBitValueSet("facing", 7, Map.of(0, "down", 1, "up", 2, "north", 3, "south", 4, "west", 5, "east"), "north").maskedBoolean("powered", 8).build();
        this.blockTypeMapper.getBlockDataTranslators().put(mappingKey -> mappingKey.is((Object)"OBSERVER"), observer);
        this.f2l("OBSERVER", 218);
        this.f2l("WHITE_SHULKER_BOX", 219);
        this.f2l("ORANGE_SHULKER_BOX", 220);
        this.f2l("MAGENTA_SHULKER_BOX", 221);
        this.f2l("LIGHT_BLUE_SHULKER_BOX", 222);
        this.f2l("YELLOW_SHULKER_BOX", 223);
        this.f2l("LIME_SHULKER_BOX", 224);
        this.f2l("PINK_SHULKER_BOX", 225);
        this.f2l("GRAY_SHULKER_BOX", 226);
        this.f2l("LIGHT_GRAY_SHULKER_BOX", "SILVER_SHULKER_BOX", 227);
        this.f2l("CYAN_SHULKER_BOX", 228);
        this.f2l("PURPLE_SHULKER_BOX", 229);
        this.f2l("BLUE_SHULKER_BOX", 230);
        this.f2l("BROWN_SHULKER_BOX", 231);
        this.f2l("GREEN_SHULKER_BOX", 232);
        this.f2l("RED_SHULKER_BOX", 233);
        this.f2l("BLACK_SHULKER_BOX", 234);
        this.f2l("WHITE_GLAZED_TERRACOTTA", 235);
        this.f2lBlock("WHITE_GLAZED_TERRACOTTA", Map.of("facing", "west"), 235, 1);
        this.f2lBlock("WHITE_GLAZED_TERRACOTTA", Map.of("facing", "north"), 235, 2);
        this.f2lBlock("WHITE_GLAZED_TERRACOTTA", Map.of("facing", "east"), 235, 3);
        this.f2l("ORANGE_GLAZED_TERRACOTTA", 236);
        this.f2lBlock("ORANGE_GLAZED_TERRACOTTA", Map.of("facing", "west"), 236, 1);
        this.f2lBlock("ORANGE_GLAZED_TERRACOTTA", Map.of("facing", "north"), 236, 2);
        this.f2lBlock("ORANGE_GLAZED_TERRACOTTA", Map.of("facing", "east"), 236, 3);
        this.f2l("MAGENTA_GLAZED_TERRACOTTA", 237);
        this.f2lBlock("MAGENTA_GLAZED_TERRACOTTA", Map.of("facing", "west"), 237, 1);
        this.f2lBlock("MAGENTA_GLAZED_TERRACOTTA", Map.of("facing", "north"), 237, 2);
        this.f2lBlock("MAGENTA_GLAZED_TERRACOTTA", Map.of("facing", "east"), 237, 3);
        this.f2l("LIGHT_BLUE_GLAZED_TERRACOTTA", 238);
        this.f2lBlock("LIGHT_BLUE_GLAZED_TERRACOTTA", Map.of("facing", "west"), 238, 1);
        this.f2lBlock("LIGHT_BLUE_GLAZED_TERRACOTTA", Map.of("facing", "north"), 238, 2);
        this.f2lBlock("LIGHT_BLUE_GLAZED_TERRACOTTA", Map.of("facing", "east"), 238, 3);
        this.f2l("YELLOW_GLAZED_TERRACOTTA", 239);
        this.f2lBlock("YELLOW_GLAZED_TERRACOTTA", Map.of("facing", "west"), 239, 1);
        this.f2lBlock("YELLOW_GLAZED_TERRACOTTA", Map.of("facing", "north"), 239, 2);
        this.f2lBlock("YELLOW_GLAZED_TERRACOTTA", Map.of("facing", "east"), 239, 3);
        this.f2l("LIME_GLAZED_TERRACOTTA", 240);
        this.f2lBlock("LIME_GLAZED_TERRACOTTA", Map.of("facing", "west"), 240, 1);
        this.f2lBlock("LIME_GLAZED_TERRACOTTA", Map.of("facing", "north"), 240, 2);
        this.f2lBlock("LIME_GLAZED_TERRACOTTA", Map.of("facing", "east"), 240, 3);
        this.f2l("PINK_GLAZED_TERRACOTTA", 241);
        this.f2lBlock("PINK_GLAZED_TERRACOTTA", Map.of("facing", "west"), 241, 1);
        this.f2lBlock("PINK_GLAZED_TERRACOTTA", Map.of("facing", "north"), 241, 2);
        this.f2lBlock("PINK_GLAZED_TERRACOTTA", Map.of("facing", "east"), 241, 3);
        this.f2l("GRAY_GLAZED_TERRACOTTA", 242);
        this.f2lBlock("LIME_GLAZED_TERRACOTTA", Map.of("facing", "west"), 242, 1);
        this.f2lBlock("LIME_GLAZED_TERRACOTTA", Map.of("facing", "north"), 242, 2);
        this.f2lBlock("LIME_GLAZED_TERRACOTTA", Map.of("facing", "east"), 242, 3);
        this.f2l("LIGHT_GRAY_GLAZED_TERRACOTTA", "SILVER_GLAZED_TERRACOTTA", 243);
        this.f2lBlock("LIGHT_GRAY_GLAZED_TERRACOTTA", Map.of("facing", "west"), "SILVER_GLAZED_TERRACOTTA", 243, 1);
        this.f2lBlock("LIGHT_GRAY_GLAZED_TERRACOTTA", Map.of("facing", "north"), "SILVER_GLAZED_TERRACOTTA", 243, 2);
        this.f2lBlock("LIGHT_GRAY_GLAZED_TERRACOTTA", Map.of("facing", "east"), "SILVER_GLAZED_TERRACOTTA", 243, 3);
        this.f2l("CYAN_GLAZED_TERRACOTTA", 244);
        this.f2lBlock("LIME_GLAZED_TERRACOTTA", Map.of("facing", "west"), 242, 1);
        this.f2lBlock("LIME_GLAZED_TERRACOTTA", Map.of("facing", "north"), 242, 2);
        this.f2lBlock("LIME_GLAZED_TERRACOTTA", Map.of("facing", "east"), 242, 3);
        this.f2l("PURPLE_GLAZED_TERRACOTTA", 245);
        this.f2lBlock("PURPLE_GLAZED_TERRACOTTA", Map.of("facing", "west"), 245, 1);
        this.f2lBlock("PURPLE_GLAZED_TERRACOTTA", Map.of("facing", "north"), 245, 2);
        this.f2lBlock("PURPLE_GLAZED_TERRACOTTA", Map.of("facing", "east"), 245, 3);
        this.f2l("BLUE_GLAZED_TERRACOTTA", 246);
        this.f2lBlock("BLUE_GLAZED_TERRACOTTA", Map.of("facing", "west"), 246, 1);
        this.f2lBlock("BLUE_GLAZED_TERRACOTTA", Map.of("facing", "north"), 246, 2);
        this.f2lBlock("BLUE_GLAZED_TERRACOTTA", Map.of("facing", "east"), 246, 3);
        this.f2l("BROWN_GLAZED_TERRACOTTA", 247);
        this.f2lBlock("BROWN_GLAZED_TERRACOTTA", Map.of("facing", "west"), 247, 1);
        this.f2lBlock("BROWN_GLAZED_TERRACOTTA", Map.of("facing", "north"), 247, 2);
        this.f2lBlock("BROWN_GLAZED_TERRACOTTA", Map.of("facing", "east"), 247, 3);
        this.f2l("GREEN_GLAZED_TERRACOTTA", 248);
        this.f2lBlock("GREEN_GLAZED_TERRACOTTA", Map.of("facing", "west"), 248, 1);
        this.f2lBlock("GREEN_GLAZED_TERRACOTTA", Map.of("facing", "north"), 248, 2);
        this.f2lBlock("GREEN_GLAZED_TERRACOTTA", Map.of("facing", "east"), 248, 3);
        this.f2l("RED_GLAZED_TERRACOTTA", 249);
        this.f2lBlock("RED_GLAZED_TERRACOTTA", Map.of("facing", "west"), 249, 1);
        this.f2lBlock("RED_GLAZED_TERRACOTTA", Map.of("facing", "north"), 249, 2);
        this.f2lBlock("RED_GLAZED_TERRACOTTA", Map.of("facing", "east"), 249, 3);
        this.f2l("BLACK_GLAZED_TERRACOTTA", 250);
        this.f2lBlock("BLACK_GLAZED_TERRACOTTA", Map.of("facing", "west"), 250, 1);
        this.f2lBlock("BLACK_GLAZED_TERRACOTTA", Map.of("facing", "north"), 250, 2);
        this.f2lBlock("BLACK_GLAZED_TERRACOTTA", Map.of("facing", "east"), 250, 3);
        this.f2lColored("CONCRETE", 251);
        this.f2lColored("CONCRETE_POWDER", 252);
        this.f2l("STRUCTURE_BLOCK", 255);
        this.f2lBlock("STRUCTURE_BLOCK", Map.of("mode", "save"), 255, 1);
        this.f2lBlock("STRUCTURE_BLOCK", Map.of("mode", "load"), 255, 2);
        this.f2lBlock("STRUCTURE_BLOCK", Map.of("mode", "corner"), 255, 3);
        this.f2lItem("IRON_SHOVEL", 256, "IRON_SPADE");
        this.f2lItem("IRON_PICKAXE", 257);
        this.f2lItem("IRON_AXE", 258);
        this.f2lItem("FLINT_AND_STEEL", 259);
        this.f2lItem("APPLE", 260);
        this.f2lItem("BOW", 261);
        this.f2lItem("ARROW", 262);
        this.f2lItem("COAL", 263);
        this.f2lItem("CHARCOAL", "COAL", 263, 1);
        this.f2lItem("DIAMOND", 264);
        this.f2lItem("IRON_INGOT", 265);
        this.f2lItem("GOLD_INGOT", 266);
        this.f2lItem("IRON_SWORD", 267);
        this.f2lItem("WOODEN_SWORD", 268, "WOOD_SWORD");
        this.f2lItem("WOODEN_SHOVEL", 269, "WOOD_SPADE");
        this.f2lItem("WOODEN_PICKAXE", 270, "WOOD_PICKAXE");
        this.f2lItem("WOODEN_AXE", 271, "WOOD_AXE");
        this.f2lItem("STONE_SWORD", 272);
        this.f2lItem("STONE_SHOVEL", 273, "STONE_SPADE");
        this.f2lItem("STONE_PICKAXE", 274);
        this.f2lItem("STONE_AXE", 275);
        this.f2lItem("DIAMOND_SWORD", 276);
        this.f2lItem("DIAMOND_SHOVEL", 277, "DIAMOND_SPADE");
        this.f2lItem("DIAMOND_PICKAXE", 278);
        this.f2lItem("DIAMOND_AXE", 279);
        this.f2lItem("STICK", 280);
        this.f2lItem("BOWL", 281);
        this.f2lItem("MUSHROOM_STEW", 282, "MUSHROOM_SOUP");
        this.f2lItem("GOLDEN_SWORD", 283, "GOLD_SWORD");
        this.f2lItem("GOLDEN_SHOVEL", 284, "GOLD_SPADE");
        this.f2lItem("GOLDEN_PICKAXE", 285, "GOLD_PICKAXE");
        this.f2lItem("GOLDEN_AXE", 286, "GOLD_AXE");
        this.f2lItem("STRING", 287);
        this.f2lItem("FEATHER", 288);
        this.f2lItem("GUNPOWDER", 289, "SULPHUR");
        this.f2lItem("WOODEN_HOE", 290, "WOOD_HOE");
        this.f2lItem("STONE_HOE", 291);
        this.f2lItem("IRON_HOE", 292);
        this.f2lItem("DIAMOND_HOE", 293);
        this.f2lItem("GOLDEN_HOE", 294, "GOLD_HOE");
        this.f2lItem("WHEAT_SEEDS", 295, "SEEDS");
        this.f2lItem("WHEAT", 296);
        this.f2lItem("BREAD", 297);
        this.f2lItem("LEATHER_HELMET", 298);
        this.f2lItem("LEATHER_CHESTPLATE", 299);
        this.f2lItem("LEATHER_LEGGINGS", 300);
        this.f2lItem("LEATHER_BOOTS", 301);
        this.f2lItem("CHAINMAIL_HELMET", 302);
        this.f2lItem("CHAINMAIL_CHESTPLATE", 303);
        this.f2lItem("CHAINMAIL_LEGGINGS", 304);
        this.f2lItem("CHAINMAIL_BOOTS", 305);
        this.f2lItem("IRON_HELMET", 306);
        this.f2lItem("IRON_CHESTPLATE", 307);
        this.f2lItem("IRON_LEGGINGS", 308);
        this.f2lItem("IRON_BOOTS", 309);
        this.f2lItem("DIAMOND_HELMET", 310);
        this.f2lItem("DIAMOND_CHESTPLATE", 311);
        this.f2lItem("DIAMOND_LEGGINGS", 312);
        this.f2lItem("DIAMOND_BOOTS", 313);
        this.f2lItem("GOLDEN_HELMET", 314, "GOLD_HELMET");
        this.f2lItem("GOLDEN_CHESTPLATE", 315, "GOLD_CHESTPLATE");
        this.f2lItem("GOLDEN_LEGGINGS", 316, "GOLD_LEGGINGS");
        this.f2lItem("GOLDEN_BOOTS", 317, "GOLD_BOOTS");
        this.f2lItem("FLINT", 318);
        this.f2lItem("PORKCHOP", 319, "PORK");
        this.f2lItem("COOKED_PORKCHOP", 320, "GRILLED_PORK");
        this.f2lItem("PAINTING", 321);
        this.f2lItem("GOLDEN_APPLE", 322);
        this.f2lItem("ENCHANTED_GOLDEN_APPLE", "GOLDEN_APPLE", 322, 1);
        this.f2lItem("OAK_SIGN", "SIGN", 323);
        this.f2lItem("OAK_DOOR", "WOODEN_DOOR", 324, "WOOD_DOOR");
        this.f2lItem("BUCKET", 325);
        this.f2lItem("WATER_BUCKET", 326);
        this.f2lItem("LAVA_BUCKET", 327);
        this.f2lItem("MINECART", 328);
        this.f2lItem("SADDLE", 329);
        this.f2lItem("IRON_DOOR", 330);
        this.f2lItem("REDSTONE", 331);
        this.f2lItem("SNOWBALL", 332, "SNOW_BALL");
        this.f2lItem("OAK_BOAT", "BOAT", 333);
        this.f2lItem("LEATHER", 334);
        this.f2lItem("MILK_BUCKET", 335);
        this.f2lItem("BRICK", 336, "CLAY_BRICK");
        this.f2lItem("CLAY_BALL", 337);
        this.f2lItem("SUGAR_CANE", 338, "REEDS");
        this.f2lItem("PAPER", 339);
        this.f2lItem("BOOK", 340);
        this.f2lItem("SLIME_BALL", 341);
        this.f2lItem("CHEST_MINECART", 342, "STORAGE_MINECART");
        this.f2lItem("FURNACE_MINECART", 343, "POWERED_MINECART");
        this.f2lItem("EGG", 344);
        this.f2lItem("COMPASS", 345);
        this.f2lItem("FISHING_ROD", 346);
        this.f2lItem("CLOCK", 347, "WATCH");
        this.f2lItem("GLOWSTONE_DUST", 348);
        this.f2lItem("COD", "FISH", 349, "RAW_FISH");
        this.f2lItem("SALMON", "FISH", 349, 1, "RAW_FISH");
        this.f2lItem("TROPICAL_FISH", "FISH", 349, 2, "RAW_FISH");
        this.f2lItem("PUFFERFISH", "FISH", 349, 3, "RAW_FISH");
        this.f2lItem("COOKED_COD", "COOKED_FISH", 350);
        this.f2lItem("COOKED_SALMON", "COOKED_FISH", 350, 1);
        this.f2lItem("INK_SACK", 351, "DYE");
        this.f2lItem("ROSE_RED", "DYE", 351, 1, "INK_SACK");
        this.f2lItem("CACTUS_GREEN", "DYE", 351, 2, "INK_SACK");
        this.f2lItem("COCOA_BEANS", "DYE", 351, 3, "INK_SACK");
        this.f2lItem("LAPIS_LAZULI", "DYE", 351, 4, "INK_SACK");
        this.f2lItem("PURPLE_DYE", "DYE", 351, 5, "INK_SACK");
        this.f2lItem("CYAN_DYE", "DYE", 351, 6, "INK_SACK");
        this.f2lItem("LIGHT_GRAY_DYE", "DYE", 351, 7, "INK_SACK");
        this.f2lItem("GRAY_DYE", "DYE", 351, 8, "INK_SACK");
        this.f2lItem("PINK_DYE", "DYE", 351, 9, "INK_SACK");
        this.f2lItem("LIME_DYE", "DYE", 351, 10, "INK_SACK");
        this.f2lItem("DANDELION_YELLOW", "DYE", 351, 11, "INK_SACK");
        this.f2lItem("LIGHT_BLUE_DYE", "DYE", 351, 12, "INK_SACK");
        this.f2lItem("MAGENTA_DYE", "DYE", 351, 13, "INK_SACK");
        this.f2lItem("ORANGE_DYE", "DYE", 351, 14, "INK_SACK");
        this.f2lItem("BONE_MEAL", "DYE", 351, 15, "INK_SACK");
        this.f2lItem("BONE", 352);
        this.f2lItem("SUGAR", 353);
        this.f2lItem("CAKE", 354);
        if (this.mappingFlags.contains((Object)MappingFlags.NO_COLORED_BEDS)) {
            this.f2lColoredToNonColoredItem("BED", 355);
        } else {
            this.f2lColoredItem("BED", 355);
        }
        this.f2lItem("REPEATER", 356, "DIODE");
        this.f2lItem("COOKIE", 357);
        this.f2lItem("FILLED_MAP", 358, "MAP");
        this.f2lItem("SHEARS", 359);
        this.f2lItem("MELON_SLICE", "MELON", 360);
        this.f2lItem("PUMPKIN_SEEDS", 361);
        this.f2lItem("MELON_SEEDS", 362);
        this.f2lItem("BEEF", 363, "RAW_BEEF");
        this.f2lItem("COOKED_BEEF", 364);
        this.f2lItem("CHICKEN", 365, "RAW_CHICKEN");
        this.f2lItem("COOKED_CHICKEN", 366);
        this.f2lItem("ROTTEN_FLESH", 367);
        this.f2lItem("ENDER_PEARL", 368);
        this.f2lItem("BLAZE_ROD", 369);
        this.f2lItem("GHAST_TEAR", 370);
        this.f2lItem("GOLD_NUGGET", 371);
        this.f2lItem("NETHER_WART", 372, "NETHER_STALK");
        this.f2lItem("POTION", 373);
        this.f2lItem("GLASS_BOTTLE", 374);
        this.f2lItem("SPIDER_EYE", 375);
        this.f2lItem("FERMENTED_SPIDER_EYE", 376);
        this.f2lItem("BLAZE_POWDER", 377);
        this.f2lItem("MAGMA_CREAM", 378);
        this.f2lItem("BREWING_STAND", "BREWING_STAND_ITEM", 379, "BREWING_STAND");
        this.f2lItem("CAULDRON", 380, "CAULDRON_ITEM");
        this.f2lItem("ENDER_EYE", 381, "EYE_OF_ENDER");
        this.f2lItem("GLISTERING_MELON_SLICE", 382, "SPECKLED_MELON");
        this.f2lItem("BAT_SPAWN_EGG", "SPAWN_EGG", 383, 65, "MONSTER_EGG");
        this.f2lItem("BLAZE_SPAWN_EGG", "SPAWN_EGG", 383, 61, "MONSTER_EGG");
        this.f2lItem("CAVE_SPIDER_SPAWN_EGG", "SPAWN_EGG", 383, 59, "MONSTER_EGG");
        this.f2lItem("CHICKEN_SPAWN_EGG", "SPAWN_EGG", 383, 93, "MONSTER_EGG");
        this.f2lItem("COW_SPAWN_EGG", "SPAWN_EGG", 383, 92, "MONSTER_EGG");
        this.f2lItem("CREEPER_SPAWN_EGG", "SPAWN_EGG", 383, 50, "MONSTER_EGG");
        this.f2lItem("DONKEY_SPAWN_EGG", "SPAWN_EGG", 383, 31, "MONSTER_EGG");
        this.f2lItem("ELDER_GUARDIAN_SPAWN_EGG", "SPAWN_EGG", 383, 4, "MONSTER_EGG");
        this.f2lItem("ENDERMAN_SPAWN_EGG", "SPAWN_EGG", 383, 58, "MONSTER_EGG");
        this.f2lItem("ENDERMITE_SPAWN_EGG", "SPAWN_EGG", 383, 67, "MONSTER_EGG");
        this.f2lItem("EVOKER_SPAWN_EGG", "SPAWN_EGG", 383, 34, "MONSTER_EGG");
        this.f2lItem("GHAST_SPAWN_EGG", "SPAWN_EGG", 383, 56, "MONSTER_EGG");
        this.f2lItem("GUARDIAN_SPAWN_EGG", "SPAWN_EGG", 383, 68, "MONSTER_EGG");
        this.f2lItem("HORSE_SPAWN_EGG", "SPAWN_EGG", 383, 100, "MONSTER_EGG");
        this.f2lItem("HUSK_SPAWN_EGG", "SPAWN_EGG", 383, 23, "MONSTER_EGG");
        this.f2lItem("LLAMA_SPAWN_EGG", "SPAWN_EGG", 383, 103, "MONSTER_EGG");
        this.f2lItem("MAGMA_CUBE_SPAWN_EGG", "SPAWN_EGG", 383, 62, "MONSTER_EGG");
        this.f2lItem("MOOSHROOM_SPAWN_EGG", "SPAWN_EGG", 383, 96, "MONSTER_EGG");
        this.f2lItem("MULE_SPAWN_EGG", "SPAWN_EGG", 383, 32, "MONSTER_EGG");
        this.f2lItem("OCELOT_SPAWN_EGG", "SPAWN_EGG", 383, 98, "MONSTER_EGG");
        this.f2lItem("PARROT_SPAWN_EGG", "SPAWN_EGG", 383, 105, "MONSTER_EGG");
        this.f2lItem("PIG_SPAWN_EGG", "SPAWN_EGG", 383, 90, "MONSTER_EGG");
        this.f2lItem("POLAR_BEAR_SPAWN_EGG", "SPAWN_EGG", 383, 102, "MONSTER_EGG");
        this.f2lItem("RABBIT_SPAWN_EGG", "SPAWN_EGG", 383, 101, "MONSTER_EGG");
        this.f2lItem("SHEEP_SPAWN_EGG", "SPAWN_EGG", 383, 91, "MONSTER_EGG");
        this.f2lItem("SHULKER_SPAWN_EGG", "SPAWN_EGG", 383, 69, "MONSTER_EGG");
        this.f2lItem("SILVERFISH_SPAWN_EGG", "SPAWN_EGG", 383, 60, "MONSTER_EGG");
        this.f2lItem("SKELETON_SPAWN_EGG", "SPAWN_EGG", 383, 51, "MONSTER_EGG");
        this.f2lItem("SKELETON_HORSE_SPAWN_EGG", "SPAWN_EGG", 383, 28, "MONSTER_EGG");
        this.f2lItem("SLIME_SPAWN_EGG", "SPAWN_EGG", 383, 55, "MONSTER_EGG");
        this.f2lItem("SPIDER_SPAWN_EGG", "SPAWN_EGG", 383, 52, "MONSTER_EGG");
        this.f2lItem("SQUID_SPAWN_EGG", "SPAWN_EGG", 383, 94, "MONSTER_EGG");
        this.f2lItem("STRAY_SPAWN_EGG", "SPAWN_EGG", 383, 6, "MONSTER_EGG");
        this.f2lItem("VEX_SPAWN_EGG", "SPAWN_EGG", 383, 35, "MONSTER_EGG");
        this.f2lItem("VILLAGER_SPAWN_EGG", "SPAWN_EGG", 383, 120, "MONSTER_EGG");
        this.f2lItem("VINDICATOR_SPAWN_EGG", "SPAWN_EGG", 383, 36, "MONSTER_EGG");
        this.f2lItem("WITCH_SPAWN_EGG", "SPAWN_EGG", 383, 66, "MONSTER_EGG");
        this.f2lItem("WITHER_SKELETON_SPAWN_EGG", "SPAWN_EGG", 383, 5, "MONSTER_EGG");
        this.f2lItem("WOLF_SPAWN_EGG", "SPAWN_EGG", 383, 95, "MONSTER_EGG");
        this.f2lItem("ZOMBIE_SPAWN_EGG", "SPAWN_EGG", 383, 54, "MONSTER_EGG");
        this.f2lItem("ZOMBIE_HORSE_SPAWN_EGG", "SPAWN_EGG", 383, 29, "MONSTER_EGG");
        this.f2lItem("ZOMBIE_PIGMAN_SPAWN_EGG", "SPAWN_EGG", 383, 57, "MONSTER_EGG");
        this.f2lItem("ZOMBIE_VILLAGER_SPAWN_EGG", "SPAWN_EGG", 383, 27, "MONSTER_EGG");
        this.f2lItem("EXPERIENCE_BOTTLE", 384, "EXP_BOTTLE");
        this.f2lItem("FIRE_CHARGE", 385, "FIREBALL");
        this.f2lItem("WRITABLE_BOOK", 386, "BOOK_AND_QUILL");
        this.f2lItem("WRITTEN_BOOK", 387);
        this.f2lItem("EMERALD", 388);
        this.f2lItem("ITEM_FRAME", 389);
        this.f2lItem("FLOWER_POT", 390, "FLOWER_POT_ITEM");
        this.f2lItem("CARROT", 391, "CARROT_ITEM");
        this.f2lItem("POTATO", 392, "POTATO_ITEM");
        this.f2lItem("BAKED_POTATO", 393);
        this.f2lItem("POISONOUS_POTATO", 394);
        this.f2lItem("MAP", "EMPTY_MAP", 395);
        this.f2lItem("GOLDEN_CARROT", 396);
        this.f2lItem("SKELETON_SKULL", "SKULL", 397, "SKULL_ITEM");
        this.f2lItem("WITHER_SKELETON_SKULL", "SKULL", 397, 1, "SKULL_ITEM");
        this.f2lItem("ZOMBIE_HEAD", "SKULL", 397, 2, "SKULL_ITEM");
        this.f2lItem("PLAYER_HEAD", "SKULL", 397, 3, "SKULL_ITEM");
        this.f2lItem("CREEPER_HEAD", "SKULL", 397, 4, "SKULL_ITEM");
        this.f2lItem("DRAGON_HEAD", "SKULL", 397, 5, "SKULL_ITEM");
        this.f2lItem("CARROT_ON_A_STICK", 398, "CARROT_STICK");
        this.f2lItem("NETHER_STAR", 399);
        this.f2lItem("PUMPKIN_PIE", 400);
        this.f2lItem("FIREWORK_ROCKET", "FIREWORKS", 401, "FIREWORK");
        this.f2lItem("FIREWORK_STAR", "FIREWORK_CHARGE", 402);
        this.f2lItem("ENCHANTED_BOOK", 403);
        this.f2lItem("COMPARATOR", 404, "REDSTONE_COMPARATOR");
        this.f2lItem("NETHER_BRICK", "NETHERBRICK", 405, "NETHER_BRICK_ITEM");
        this.f2lItem("QUARTZ", 406);
        this.f2lItem("TNT_MINECART", 407, "EXPLOSIVE_MINECART");
        this.f2lItem("HOPPER_MINECART", 408);
        this.f2lItem("PRISMARINE_SHARD", 409);
        this.f2lItem("PRISMARINE_CRYSTALS", 410);
        this.f2lItem("RABBIT", 411);
        this.f2lItem("COOKED_RABBIT", 412);
        this.f2lItem("RABBIT_STEW", 413);
        this.f2lItem("RABBIT_FOOT", 414);
        this.f2lItem("RABBIT_HIDE", 415);
        this.f2lItem("ARMOR_STAND", 416);
        this.f2lItem("IRON_HORSE_ARMOR", 417, "IRON_BARDING");
        this.f2lItem("GOLDEN_HORSE_ARMOR", 418, "GOLD_BARDING");
        this.f2lItem("DIAMOND_HORSE_ARMOR", 419, "DIAMOND_BARDING");
        this.f2lItem("LEAD", 420, "LEASH");
        this.f2lItem("NAME_TAG", 421);
        this.f2lItem("COMMAND_BLOCK_MINECART", 422, "COMMAND_MINECART");
        this.f2lItem("MUTTON", 423);
        this.f2lItem("COOKED_MUTTON", 424);
        this.f2lColoredItem("BANNER", 425);
        this.f2lItem("END_CRYSTAL", 426);
        this.f2lItem("SPRUCE_DOOR", 427, "SPRUCE_DOOR_ITEM");
        this.f2lItem("BIRCH_DOOR", 428, "BIRCH_DOOR_ITEM");
        this.f2lItem("JUNGLE_DOOR", 429, "JUNGLE_DOOR_ITEM");
        this.f2lItem("ACACIA_DOOR", 430, "ACACIA_DOOR_ITEM");
        this.f2lItem("DARK_OAK_DOOR", 431, "DARK_OAK_DOOR_ITEM");
        this.f2lItem("CHORUS_FRUIT", 432);
        this.f2lItem("POPPED_CHORUS_FRUIT", "CHORUS_FRUIT_POPPED", 433);
        this.f2lItem("BEETROOT", 434);
        this.f2lItem("BEETROOT_SEEDS", 435);
        this.f2lItem("BEETROOT_SOUP", 436);
        this.f2lItem("DRAGONS_BREATH", 437);
        this.f2lItem("SPLASH_POTION", 438);
        this.f2lItem("SPECTRAL_ARROW", 439);
        this.f2lItem("TIPPED_ARROW", 440);
        this.f2lItem("LINGERING_POTION", 441);
        this.f2lItem("SHIELD", 442);
        this.f2lItem("ELYTRA", 443);
        this.f2lItem("SPRUCE_BOAT", 444, "BOAT_SPRUCE");
        this.f2lItem("BIRCH_BOAT", 445, "BOAT_BIRCH");
        this.f2lItem("JUNGLE_BOAT", 446, "BOAT_JUNGLE");
        this.f2lItem("ACACIA_BOAT", 447, "BOAT_ACACIA");
        this.f2lItem("DARK_OAK_BOAT", 448, "BOAT_DARK_OAK");
        this.f2lItem("TOTEM_OF_UNDYING", 449, "TOTEM");
        this.f2lItem("SHULKER_SHELL", 450);
        this.f2lItem("IRON_NUGGET", 452);
        this.f2lItem("KNOWLEDGE_BOOK", 453);
        this.f2lItem("MUSIC_DISC_13", "RECORD_13", 2256, "GOLD_RECORD");
        this.f2lItem("MUSIC_DISC_CAT", "RECORD_CAT", 2257, "GREEN_RECORD");
        this.f2lItem("MUSIC_DISC_BLOCKS", "RECORD_BLOCKS", 2258, "RECORD_3");
        this.f2lItem("MUSIC_DISC_CHIRP", "RECORD_CHIRP", 2259, "RECORD_4");
        this.f2lItem("MUSIC_DISC_FAR", "RECORD_FAR", 2260, "RECORD_5");
        this.f2lItem("MUSIC_DISC_MALL", "RECORD_MALL", 2261, "RECORD_6");
        this.f2lItem("MUSIC_DISC_MELLOHI", "RECORD_MELLOHI", 2262, "RECORD_7");
        this.f2lItem("MUSIC_DISC_STAL", "RECORD_STAL", 2263, "RECORD_8");
        this.f2lItem("MUSIC_DISC_STRAD", "RECORD_STRAD", 2264, "RECORD_9");
        this.f2lItem("MUSIC_DISC_WARD", "RECORD_WARD", 2265, "RECORD_10");
        this.f2lItem("MUSIC_DISC_11", "RECORD_11", 2266);
        this.f2lItem("MUSIC_DISC_WAIT", "RECORD_WAIT", 2267, "RECORD_12");
    }

    private void flatteningMapping() {
        this.mapAliasItem("ZOMBIFIED_PIGLIN_SPAWN_EGG", "ZOMBIE_PIGMAN_SPAWN_EGG");
        this.mapAlias("SMOOTH_STONE_SLAB", "STONE_SLAB");
        this.mapAliasItem("GREEN_DYE", "CACTUS_GREEN");
        this.mapAliasItem("YELLOW_DYE", "DANDELION_YELLOW");
        this.mapAliasItem("RED_DYE", "ROSE_RED");
        this.mapAlias("OAK_SIGN", "SIGN");
        this.mapAlias("BIRCH_SIGN", "SIGN");
        this.mapAlias("DARK_OAK_SIGN", "SIGN");
        this.mapAlias("JUNGLE_SIGN", "SIGN");
        this.mapAlias("SPRUCE_SIGN", "SIGN");
        this.mapAlias("ACACIA_SIGN", "SIGN");
        this.mapAlias("OAK_WALL_SIGN", "SIGN");
        this.mapAlias("BIRCH_WALL_SIGN", "SIGN");
        this.mapAlias("BIRCH_WALL_SIGN", "SIGN");
        this.mapAlias("DARK_OAK_WALL_SIGN", "SIGN");
        this.mapAlias("JUNGLE_WALL_SIGN", "SIGN");
        this.mapAlias("SPRUCE_WALL_SIGN", "SIGN");
        this.mapAlias("ACACIA_WALL_SIGN", "SIGN");
        this.mapAlias("DIRT_PATH", "GRASS_PATH");
        this.mapAlias("WATER_CAULDRON", "CAULDRON");
    }

    private void mapAlias(String mappingKey, String alias) {
        this.itemTypeMapper.mapAlias(mappingKey, alias);
        this.blockTypeMapper.mapAlias(mappingKey, alias);
    }

    private void mapAliasItem(String mappingKey, String alias) {
        this.itemTypeMapper.mapAlias(mappingKey, alias);
    }

    private void mapAliasBlock(String mappingKey, String alias) {
        this.blockTypeMapper.mapAlias(mappingKey, alias);
    }

    private void f2lColored(String material, int legacyId) {
        this.f2lColored(material, material, legacyId);
    }

    private void f2lColoredBlock(String material, int legacyId) {
        this.f2lColoredBlock(material, material, legacyId);
    }

    private void f2lColoredItem(String material, int legacyId) {
        this.f2lColoredItem(material, material, legacyId);
    }

    private void f2lColored(String flatteningMaterialSuffix, String legacyMaterial, int legacyId) {
        this.f2lColored(flatteningMaterialSuffix, legacyMaterial, legacyId, null);
    }

    private void f2lColoredBlock(String flatteningMaterialSuffix, String legacyMaterial, int legacyId) {
        this.f2lColoredBlock(flatteningMaterialSuffix, legacyMaterial, legacyId, null);
    }

    private void f2lColoredItem(String flatteningMaterialSuffix, String legacyMaterial, int legacyId) {
        this.f2lColoredItem(flatteningMaterialSuffix, legacyMaterial, legacyId, null);
    }

    private void f2lColored(String flatteningMaterialSuffix, String legacyMaterial, int legacyId, String alternativeLegacyName) {
        this.f2lColoredBlock(flatteningMaterialSuffix, legacyMaterial, legacyId, alternativeLegacyName);
        this.f2lColoredItem(flatteningMaterialSuffix, legacyMaterial, legacyId, alternativeLegacyName);
    }

    private void f2lColoredItem(String flatteningMaterialSuffix, String legacyMaterial, int legacyId, String alternativeLegacyName) {
        if (flatteningMaterialSuffix == null || legacyMaterial == null) {
            throw new IllegalArgumentException("Both materials mustn't be null!");
        }
        for (int i = 0; i <= 15; ++i) {
            this.f2lItem(COLORS.get(i) + "_" + flatteningMaterialSuffix, legacyMaterial, legacyId, i, alternativeLegacyName);
        }
    }

    private void f2lColoredBlock(String flatteningMaterialSuffix, String legacyMaterial, int legacyId, String alternativeLegacyName) {
        if (flatteningMaterialSuffix == null || legacyMaterial == null) {
            throw new IllegalArgumentException("Both materials mustn't be null!");
        }
        for (int i = 0; i <= 15; ++i) {
            this.f2lBlock(COLORS.get(i) + "_" + flatteningMaterialSuffix, legacyMaterial, legacyId, i, alternativeLegacyName);
        }
    }

    private void f2lColoredToNonColored(String material, int legacyId) {
        this.f2lColoredToNonColored(material, material, legacyId);
    }

    private void f2lColoredToNonColoredBlock(String material, int legacyId) {
        this.f2lColoredToNonColoredBlock(material, material, legacyId);
    }

    private void f2lColoredToNonColoredItem(String material, int legacyId) {
        this.f2lColoredToNonColoredItem(material, material, legacyId);
    }

    private void f2lColoredToNonColored(String flatteningMaterialSuffix, String legacyMaterial, int legacyId) {
        this.f2lColoredToNonColored(flatteningMaterialSuffix, legacyMaterial, legacyId, null);
    }

    private void f2lColoredToNonColoredBlock(String flatteningMaterialSuffix, String legacyMaterial, int legacyId) {
        this.f2lColoredToNonColoredBlock(flatteningMaterialSuffix, legacyMaterial, legacyId, null);
    }

    private void f2lColoredToNonColoredBlock(String flatteningMaterialSuffix, Map<String, String> state, String legacyMaterial, int legacyId, int data) {
        this.f2lColoredToNonColoredBlock(flatteningMaterialSuffix, state, legacyMaterial, legacyId, data, null);
    }

    private void f2lColoredToNonColoredItem(String flatteningMaterialSuffix, String legacyMaterial, int legacyId) {
        this.f2lColoredToNonColoredItem(flatteningMaterialSuffix, legacyMaterial, legacyId, null);
    }

    private void f2lColoredToNonColored(String flatteningMaterialSuffix, String legacyMaterial, int legacyId, String alternativeLegacyName) {
        this.f2lColoredToNonColoredBlock(flatteningMaterialSuffix, legacyMaterial, legacyId, alternativeLegacyName);
        this.f2lColoredToNonColoredItem(flatteningMaterialSuffix, legacyMaterial, legacyId, alternativeLegacyName);
    }

    private void f2lColoredToNonColoredBlock(String flatteningMaterialSuffix, String legacyMaterial, int legacyId, int data) {
        this.f2lColoredToNonColoredBlock(flatteningMaterialSuffix, legacyMaterial, legacyId, data, null);
    }

    private void f2lColoredToNonColoredBlock(String flatteningMaterialSuffix, String legacyMaterial, int legacyId, String alternativeLegacyName) {
        this.f2lColoredToNonColoredBlock(flatteningMaterialSuffix, legacyMaterial, legacyId, 0, alternativeLegacyName);
    }

    private void f2lColoredToNonColoredBlock(String flatteningMaterialSuffix, String legacyMaterial, int legacyId, int data, String alternativeLegacyName) {
        if (flatteningMaterialSuffix == null || legacyMaterial == null) {
            throw new IllegalArgumentException("Both materials mustn't be null!");
        }
        COLORS.forEach(s -> this.f2lBlock(s + "_" + flatteningMaterialSuffix, legacyMaterial, legacyId, data, alternativeLegacyName));
    }

    private void f2lColoredToNonColoredBlock(String flatteningMaterialSuffix, Map<String, String> state, String legacyMaterial, int legacyId, int data, String alternativeLegacyName) {
        if (flatteningMaterialSuffix == null || legacyMaterial == null) {
            throw new IllegalArgumentException("Both materials mustn't be null!");
        }
        COLORS.forEach(s -> this.f2lBlock(s + "_" + flatteningMaterialSuffix, state, legacyMaterial, legacyId, data, alternativeLegacyName));
    }

    private void f2lColoredToNonColoredItem(String flatteningMaterialSuffix, String legacyMaterial, int legacyId, String alternativeLegacyName) {
        if (flatteningMaterialSuffix == null || legacyMaterial == null) {
            throw new IllegalArgumentException("Both materials mustn't be null!");
        }
        COLORS.forEach(s -> this.f2lItem(s + "_" + flatteningMaterialSuffix, legacyMaterial, legacyId, alternativeLegacyName));
    }

    private void f2l(String material, int legacyId) {
        this.f2l(material, material, legacyId);
    }

    private void f2lItem(String material, int legacyId) {
        this.f2lItem(material, material, legacyId);
    }

    private void f2lBlock(String material, int legacyId) {
        this.f2lBlock(material, material, legacyId);
    }

    private void f2l(String material, int legacyId, String alternativeLegacyName) {
        this.f2l(material, material, legacyId, alternativeLegacyName);
    }

    private void f2lItem(String material, int legacyId, String alternativeLegacyName) {
        this.f2lItem(material, material, legacyId, alternativeLegacyName);
    }

    private void f2lBlock(String material, int legacyId, String alternativeLegacyName) {
        this.f2lBlock(material, material, legacyId, alternativeLegacyName);
    }

    private void f2l(String flatteningMaterial, String legacyMaterial, int legacyId) {
        this.f2l(flatteningMaterial, legacyMaterial, legacyId, 0);
    }

    private void f2lItem(String flatteningMaterial, String legacyMaterial, int legacyId) {
        this.f2lItem(flatteningMaterial, legacyMaterial, legacyId, 0);
    }

    private void f2lBlock(String flatteningMaterial, String legacyMaterial, int legacyId) {
        this.f2lBlock(flatteningMaterial, legacyMaterial, legacyId, 0);
    }

    private void f2l(String flatteningMaterial, String legacyMaterial, int legacyId, String alternativeLegacyName) {
        this.f2l(flatteningMaterial, legacyMaterial, legacyId, 0, alternativeLegacyName);
    }

    private void f2lItem(String flatteningMaterial, String legacyMaterial, int legacyId, String alternativeLegacyName) {
        this.f2lItem(flatteningMaterial, legacyMaterial, legacyId, 0, alternativeLegacyName);
    }

    private void f2lBlock(String flatteningMaterial, String legacyMaterial, int legacyId, String alternativeLegacyName) {
        this.f2lBlock(flatteningMaterial, legacyMaterial, legacyId, 0, alternativeLegacyName);
    }

    private void f2l(String flatteningMaterial, String legacyMaterial, int legacyId, int data) {
        this.f2l(flatteningMaterial, legacyMaterial, legacyId, data, null);
    }

    private void f2lItem(String flatteningMaterial, String legacyMaterial, int legacyId, int data) {
        this.f2lItem(flatteningMaterial, legacyMaterial, legacyId, data, null);
    }

    private void f2lBlock(String flatteningMaterial, String legacyMaterial, int legacyId, int data) {
        this.f2lBlock(flatteningMaterial, legacyMaterial, legacyId, data, null);
    }

    private void f2l(String flatteningMaterial, String legacyMaterial, int legacyId, int data, String alternativeLegacyName) {
        this.f2lBlock(flatteningMaterial, legacyMaterial, legacyId, data, alternativeLegacyName);
        this.f2lItem(flatteningMaterial, legacyMaterial, legacyId, data, alternativeLegacyName);
    }

    private void f2lItem(String flatteningMaterial, String legacyMaterial, int legacyId, int data, String alternativeLegacyName) {
        if (flatteningMaterial == null || legacyMaterial == null) {
            throw new IllegalArgumentException("Both flattening and legacy materials mustn't be null!");
        }
        NamespacedMappingKey flatteningMaterialNamespaced = NamespacedMappingKey.of(flatteningMaterial);
        NamespacedMappingKey legacyMaterialNamespaced = NamespacedMappingKey.of(legacyMaterial);
        NamespacedMappingKey alternativeLegacyNamespaced = alternativeLegacyName != null && !alternativeLegacyName.equalsIgnoreCase(legacyMaterial) ? NamespacedMappingKey.of(alternativeLegacyName) : null;
        Map<MappingKey, ItemTypeHolder> mapping = this.itemTypeMapper.getUNSAFE_mapping();
        ItemTypeHolder holder = null;
        if (this.platform.isUsingLegacyNames() && (mapping.containsKey(legacyMaterialNamespaced) || alternativeLegacyNamespaced != null && mapping.containsKey(alternativeLegacyNamespaced))) {
            if (mapping.containsKey(legacyMaterialNamespaced)) {
                holder = mapping.get(legacyMaterialNamespaced).withForcedDurability((short)data);
                if (!mapping.containsKey(flatteningMaterialNamespaced) && !flatteningMaterialNamespaced.equals(legacyMaterialNamespaced)) {
                    mapping.put(flatteningMaterialNamespaced, holder);
                }
                if (data == 0 && alternativeLegacyNamespaced != null && !mapping.containsKey(alternativeLegacyNamespaced)) {
                    mapping.put(alternativeLegacyNamespaced, holder);
                }
                if (alternativeLegacyNamespaced != null && !mapping.containsKey(ComplexMappingKey.of(alternativeLegacyNamespaced, NumericMappingKey.of(data)))) {
                    mapping.put(ComplexMappingKey.of(alternativeLegacyNamespaced, NumericMappingKey.of(data)), holder);
                }
            } else if (alternativeLegacyNamespaced != null && mapping.containsKey(alternativeLegacyNamespaced)) {
                holder = mapping.get(alternativeLegacyNamespaced).withForcedDurability((short)data);
                if (!mapping.containsKey(flatteningMaterialNamespaced) && !flatteningMaterialNamespaced.equals(legacyMaterialNamespaced)) {
                    mapping.put(flatteningMaterialNamespaced, holder);
                }
                if (data == 0 && !mapping.containsKey(legacyMaterialNamespaced)) {
                    mapping.put(legacyMaterialNamespaced, holder);
                }
                if (!mapping.containsKey(ComplexMappingKey.of(legacyMaterialNamespaced, NumericMappingKey.of(data)))) {
                    mapping.put(ComplexMappingKey.of(legacyMaterialNamespaced, NumericMappingKey.of(data)), holder);
                }
            }
        } else if (!this.platform.isUsingLegacyNames() && mapping.containsKey(flatteningMaterialNamespaced)) {
            holder = mapping.get(flatteningMaterialNamespaced);
            if (data == 0 && !mapping.containsKey(legacyMaterialNamespaced) && !flatteningMaterialNamespaced.equals(legacyMaterialNamespaced)) {
                mapping.put(legacyMaterialNamespaced, holder);
            }
            if (!mapping.containsKey(ComplexMappingKey.of(legacyMaterialNamespaced, NumericMappingKey.of(data)))) {
                mapping.put(ComplexMappingKey.of(legacyMaterialNamespaced, NumericMappingKey.of(data)), holder);
            }
            if (data == 0 && alternativeLegacyNamespaced != null && !mapping.containsKey(alternativeLegacyNamespaced) && !flatteningMaterialNamespaced.equals(alternativeLegacyNamespaced)) {
                mapping.put(alternativeLegacyNamespaced, holder);
            }
            if (alternativeLegacyNamespaced != null && !mapping.containsKey(ComplexMappingKey.of(alternativeLegacyNamespaced, NumericMappingKey.of(data)))) {
                mapping.put(ComplexMappingKey.of(alternativeLegacyNamespaced, NumericMappingKey.of(data)), holder);
            }
        }
        if (holder != null) {
            ComplexMappingKey legacyIdDataKey;
            NumericMappingKey legacyIdKey = NumericMappingKey.of(legacyId);
            if (!mapping.containsKey(legacyIdKey) && data == 0) {
                mapping.put(legacyIdKey, holder);
            }
            if (!mapping.containsKey(legacyIdDataKey = ComplexMappingKey.of(legacyIdKey, NumericMappingKey.of(data)))) {
                mapping.put(legacyIdDataKey, holder);
            }
        }
    }

    private void f2lBlock(String flatteningMaterial, String legacyMaterial, int legacyId, int data, String alternativeLegacyName) {
        if (flatteningMaterial == null || legacyMaterial == null) {
            throw new IllegalArgumentException("Both flattening and legacy materials mustn't be null!");
        }
        NamespacedMappingKey flatteningMaterialNamespaced = NamespacedMappingKey.of(flatteningMaterial);
        NamespacedMappingKey legacyMaterialNamespaced = NamespacedMappingKey.of(legacyMaterial);
        NamespacedMappingKey alternativeLegacyNamespaced = alternativeLegacyName != null && !alternativeLegacyName.equalsIgnoreCase(legacyMaterial) ? NamespacedMappingKey.of(alternativeLegacyName) : null;
        Map<MappingKey, BlockTypeHolder> mapping = this.blockTypeMapper.getUNSAFE_mapping();
        BlockTypeHolder holder = null;
        if (this.platform.isUsingLegacyNames() && (mapping.containsKey(legacyMaterialNamespaced) || alternativeLegacyNamespaced != null && mapping.containsKey(alternativeLegacyNamespaced))) {
            if (mapping.containsKey(legacyMaterialNamespaced)) {
                holder = mapping.get(legacyMaterialNamespaced).withLegacyData((byte)data);
                if (!mapping.containsKey(flatteningMaterialNamespaced) && !flatteningMaterialNamespaced.equals(legacyMaterialNamespaced)) {
                    mapping.put(flatteningMaterialNamespaced, holder);
                }
                if (data == 0 && alternativeLegacyNamespaced != null && !mapping.containsKey(alternativeLegacyNamespaced)) {
                    mapping.put(alternativeLegacyNamespaced, holder);
                }
                if (alternativeLegacyNamespaced != null && !mapping.containsKey(ComplexMappingKey.of(alternativeLegacyNamespaced, NumericMappingKey.of(data)))) {
                    mapping.put(ComplexMappingKey.of(alternativeLegacyNamespaced, NumericMappingKey.of(data)), holder);
                }
            } else if (alternativeLegacyNamespaced != null && mapping.containsKey(alternativeLegacyNamespaced)) {
                holder = mapping.get(alternativeLegacyNamespaced).withLegacyData((byte)data);
                if (!mapping.containsKey(flatteningMaterialNamespaced) && !flatteningMaterialNamespaced.equals(legacyMaterialNamespaced)) {
                    mapping.put(flatteningMaterialNamespaced, holder);
                }
                if (data == 0 && !mapping.containsKey(legacyMaterialNamespaced)) {
                    mapping.put(legacyMaterialNamespaced, holder);
                }
                if (!mapping.containsKey(ComplexMappingKey.of(legacyMaterialNamespaced, NumericMappingKey.of(data)))) {
                    mapping.put(ComplexMappingKey.of(legacyMaterialNamespaced, NumericMappingKey.of(data)), holder);
                }
            }
        } else if (!this.platform.isUsingLegacyNames() && mapping.containsKey(flatteningMaterialNamespaced)) {
            holder = mapping.get(flatteningMaterialNamespaced);
            if (data == 0 && !mapping.containsKey(legacyMaterialNamespaced) && !flatteningMaterialNamespaced.equals(legacyMaterialNamespaced)) {
                mapping.put(legacyMaterialNamespaced, holder);
            }
            if (!mapping.containsKey(ComplexMappingKey.of(legacyMaterialNamespaced, NumericMappingKey.of(data)))) {
                mapping.put(ComplexMappingKey.of(legacyMaterialNamespaced, NumericMappingKey.of(data)), holder);
            }
            if (data == 0 && alternativeLegacyNamespaced != null && !mapping.containsKey(alternativeLegacyNamespaced) && !flatteningMaterialNamespaced.equals(alternativeLegacyNamespaced)) {
                mapping.put(alternativeLegacyNamespaced, holder);
            }
            if (alternativeLegacyNamespaced != null && !mapping.containsKey(ComplexMappingKey.of(alternativeLegacyNamespaced, NumericMappingKey.of(data)))) {
                mapping.put(ComplexMappingKey.of(alternativeLegacyNamespaced, NumericMappingKey.of(data)), holder);
            }
        }
        if (holder != null) {
            ComplexMappingKey legacyIdDataKey;
            NumericMappingKey legacyIdKey = NumericMappingKey.of(legacyId);
            if (!mapping.containsKey(legacyIdKey) && data == 0) {
                mapping.put(legacyIdKey, holder);
            }
            if (!mapping.containsKey(legacyIdDataKey = ComplexMappingKey.of(legacyIdKey, NumericMappingKey.of(data)))) {
                mapping.put(legacyIdDataKey, holder);
            }
        }
    }

    private void f2lBlock(String flatteningMaterial, Map<String, String> state, int legacyId) {
        this.f2lBlock(flatteningMaterial, state, legacyId, 0);
    }

    private void f2lBlock(String flatteningMaterial, Map<String, String> state, int legacyId, String alternativeLegacyName) {
        this.f2lBlock(flatteningMaterial, state, legacyId, 0, alternativeLegacyName);
    }

    private void f2lBlock(String flatteningMaterial, Map<String, String> state, int legacyId, int data) {
        this.f2lBlock(flatteningMaterial, state, legacyId, data, null);
    }

    private void f2lBlock(String flatteningMaterial, Map<String, String> state, int legacyId, int data, String alternativeLegacyName) {
        this.f2lBlock(flatteningMaterial, state, flatteningMaterial, legacyId, data, alternativeLegacyName);
    }

    private void f2lBlock(String flatteningMaterial, Map<String, String> state, String legacyMaterial, int legacyId, int data) {
        this.f2lBlock(flatteningMaterial, state, legacyMaterial, legacyId, data, null);
    }

    private void f2lBlock(String flatteningMaterial, Map<String, String> state, String legacyMaterial, int legacyId, int data, String alternativeLegacyName) {
        if (flatteningMaterial == null || legacyMaterial == null) {
            throw new IllegalArgumentException("Both flattening and legacy materials mustn't be null!");
        }
        NamespacedMappingKey flatteningMaterialNamespaced = NamespacedMappingKey.of(flatteningMaterial);
        NamespacedMappingKey legacyMaterialNamespaced = NamespacedMappingKey.of(legacyMaterial);
        NamespacedMappingKey alternativeLegacyNamespaced = alternativeLegacyName != null && !alternativeLegacyName.equalsIgnoreCase(legacyMaterial) ? NamespacedMappingKey.of(alternativeLegacyName) : null;
        StringMapMappingKey stateNamespaced = StringMapMappingKey.of(state);
        ComplexMappingKey completeFlatteningMaterialNamespaced = ComplexMappingKey.of(flatteningMaterialNamespaced, stateNamespaced);
        Map<MappingKey, BlockTypeHolder> mapping = this.blockTypeMapper.getUNSAFE_mapping();
        BlockTypeHolder holder = null;
        if (this.platform.isUsingLegacyNames() && (mapping.containsKey(legacyMaterialNamespaced) || alternativeLegacyNamespaced != null && mapping.containsKey(alternativeLegacyNamespaced))) {
            if (mapping.containsKey(legacyMaterialNamespaced)) {
                holder = mapping.get(legacyMaterialNamespaced).withLegacyData((byte)data);
                if (!mapping.containsKey(completeFlatteningMaterialNamespaced)) {
                    mapping.put(completeFlatteningMaterialNamespaced, holder);
                }
                if (data == 0 && alternativeLegacyNamespaced != null && !mapping.containsKey(alternativeLegacyNamespaced)) {
                    mapping.put(alternativeLegacyNamespaced, holder);
                }
                if (alternativeLegacyNamespaced != null && !mapping.containsKey(ComplexMappingKey.of(alternativeLegacyNamespaced, NumericMappingKey.of(data)))) {
                    mapping.put(ComplexMappingKey.of(alternativeLegacyNamespaced, NumericMappingKey.of(data)), holder);
                }
            } else if (alternativeLegacyNamespaced != null && mapping.containsKey(alternativeLegacyNamespaced)) {
                holder = mapping.get(alternativeLegacyNamespaced).withLegacyData((byte)data);
                if (!mapping.containsKey(completeFlatteningMaterialNamespaced)) {
                    mapping.put(completeFlatteningMaterialNamespaced, holder);
                }
                if (data == 0 && !mapping.containsKey(legacyMaterialNamespaced)) {
                    mapping.put(legacyMaterialNamespaced, holder);
                }
                if (!mapping.containsKey(ComplexMappingKey.of(legacyMaterialNamespaced, NumericMappingKey.of(data)))) {
                    mapping.put(ComplexMappingKey.of(legacyMaterialNamespaced, NumericMappingKey.of(data)), holder);
                }
            }
        } else if (!this.platform.isUsingLegacyNames() && mapping.containsKey(flatteningMaterialNamespaced)) {
            holder = mapping.get(flatteningMaterialNamespaced).withFlatteningData(state);
            if (data == 0 && !mapping.containsKey(legacyMaterialNamespaced) && !flatteningMaterialNamespaced.equals(legacyMaterialNamespaced)) {
                mapping.put(legacyMaterialNamespaced, holder);
            }
            if (!mapping.containsKey(ComplexMappingKey.of(legacyMaterialNamespaced, NumericMappingKey.of(data)))) {
                mapping.put(ComplexMappingKey.of(legacyMaterialNamespaced, NumericMappingKey.of(data)), holder);
            }
            if (data == 0 && alternativeLegacyNamespaced != null && !mapping.containsKey(alternativeLegacyNamespaced) && !flatteningMaterialNamespaced.equals(alternativeLegacyNamespaced)) {
                mapping.put(alternativeLegacyNamespaced, holder);
            }
            if (alternativeLegacyNamespaced != null && !mapping.containsKey(ComplexMappingKey.of(alternativeLegacyNamespaced, NumericMappingKey.of(data)))) {
                mapping.put(ComplexMappingKey.of(alternativeLegacyNamespaced, NumericMappingKey.of(data)), holder);
            }
        }
        if (holder != null) {
            ComplexMappingKey legacyIdDataKey;
            NumericMappingKey legacyIdKey = NumericMappingKey.of(legacyId);
            if (!mapping.containsKey(legacyIdKey) && data == 0) {
                mapping.put(legacyIdKey, holder);
            }
            if (!mapping.containsKey(legacyIdDataKey = ComplexMappingKey.of(legacyIdKey, NumericMappingKey.of(data)))) {
                mapping.put(legacyIdDataKey, holder);
            }
        }
    }

    public ItemBlockIdsRemapper(ItemTypeMapper itemTypeMapper, BlockTypeMapper blockTypeMapper) {
        this.itemTypeMapper = itemTypeMapper;
        this.blockTypeMapper = blockTypeMapper;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public static enum MappingFlags {
        NO_COLORED_BEDS;

    }
}

