/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib;

import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.Preconditions;
import io.github.pronze.lib.screaminglib.utils.ProxyType;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.world.WorldHolder;
import io.netty.channel.ChannelFuture;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<className>.+)$", replaceRule="{basePackage}.{platform}.{Platform}{className}")
public abstract class Server {
    private static Server server;
    private static Integer PROTOCOL_VERSION;

    @ApiStatus.Internal
    public Server() {
        Preconditions.checkArgument(server == null, "Server has been already initialized!");
        server = this;
    }

    public static boolean isServerThread() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").isServerThread0();
    }

    public static String getVersion() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getVersion0();
    }

    public static String getServerSoftwareVersion() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getServerSoftwareVersion0();
    }

    public static boolean isVersion(int major, int minor) {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").isVersion0(major, minor);
    }

    public static boolean isVersion(int major, int minor, int patch) {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").isVersion0(major, minor, patch);
    }

    public static List<PlayerWrapper> getConnectedPlayers() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getConnectedPlayers0();
    }

    public static List<WorldHolder> getWorlds() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getWorlds0();
    }

    public static List<PlayerWrapper> getConnectedPlayersFromWorld(@NotNull WorldHolder world) {
        Preconditions.checkNotNull(server, "Server has not yet been initialized!");
        Preconditions.checkNotNull(world, "Invalid world provided!");
        return server.getConnectedPlayersFromWorld0(world);
    }

    public static void runSynchronously(@NotNull Runnable task) {
        Preconditions.checkNotNull(server, "Server has not yet been initialized!");
        Preconditions.checkNotNull(task, "Invalid task provided!");
        server.runSynchronously0(task);
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static String UNSAFE_normalizeSoundKey(String s) {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").UNSAFE_normalizeSoundKey0(s);
    }

    public static void shutdown() {
        Preconditions.checkNotNull(server, "Server has not yet been initialized!").shutdown0();
    }

    public static ProxyType getProxyType() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getProxyType0();
    }

    public static Integer getProtocolVersion() {
        if (PROTOCOL_VERSION == null) {
            PROTOCOL_VERSION = Preconditions.checkNotNull(server, "Server has not yet been initialized!").getProtocolVersion0();
        }
        return PROTOCOL_VERSION;
    }

    @ApiStatus.Experimental
    public static void UNSAFE_earlyInitializeLegacySupportAndIgnoreItsUsage() {
        Preconditions.checkNotNull(server, "Server has not yet been initialized!").UNSAFE_earlyInitializeLegacySupportAndIgnoreItsUsage0();
    }

    public abstract String getVersion0();

    public abstract String getServerSoftwareVersion0();

    public static List<ChannelFuture> getConnections() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getConnections0();
    }

    public abstract boolean isVersion0(int var1, int var2);

    public abstract boolean isVersion0(int var1, int var2, int var3);

    public abstract boolean isServerThread0();

    public abstract List<PlayerWrapper> getConnectedPlayers0();

    public abstract List<PlayerWrapper> getConnectedPlayersFromWorld0(WorldHolder var1);

    public abstract List<WorldHolder> getWorlds0();

    public abstract void runSynchronously0(Runnable var1);

    public abstract List<ChannelFuture> getConnections0();

    public abstract void shutdown0();

    public abstract ProxyType getProxyType0();

    public abstract Integer getProtocolVersion0();

    public String UNSAFE_normalizeSoundKey0(String s) {
        return s;
    }

    @ApiStatus.OverrideOnly
    public void UNSAFE_earlyInitializeLegacySupportAndIgnoreItsUsage0() {
    }

    static {
        PROTOCOL_VERSION = null;
    }
}

