/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.attribute;

import io.github.pronze.lib.configurate.BasicConfigurationNode;
import io.github.pronze.lib.configurate.ConfigurateException;
import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.attribute.AttributeHolder;
import io.github.pronze.lib.screaminglib.attribute.AttributeModifierHolder;
import io.github.pronze.lib.screaminglib.attribute.AttributeTypeHolder;
import io.github.pronze.lib.screaminglib.attribute.AttributeTypeMapping;
import io.github.pronze.lib.screaminglib.attribute.ItemAttributeHolder;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotMapping;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ServiceDependencies;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
@ServiceDependencies(dependsOn={AttributeTypeMapping.class, EquipmentSlotMapping.class})
public abstract class AttributeMapping {
    private static AttributeMapping attributeMapping;
    private static final Function<ConfigurationNode, AttributeModifierHolder> CONFIGURATE_LOAD_MODIFIER;
    private static final Function<ConfigurationNode, ItemAttributeHolder> CONFIGURATE_LOAD_ITEM;
    protected final BidirectionalConverter<AttributeModifierHolder> attributeModifierConverter = BidirectionalConverter.build().registerP2W(ConfigurationNode.class, CONFIGURATE_LOAD_MODIFIER).registerP2W(Map.class, map -> {
        try {
            return CONFIGURATE_LOAD_MODIFIER.apply(BasicConfigurationNode.root().set(map));
        }
        catch (ConfigurateException ignored) {
            return null;
        }
    }).registerP2W(AttributeModifierHolder.class, e -> e);
    protected final BidirectionalConverter<ItemAttributeHolder> itemAttributeConverter = BidirectionalConverter.build().registerP2W(ConfigurationNode.class, CONFIGURATE_LOAD_ITEM).registerP2W(Map.class, map -> {
        try {
            return CONFIGURATE_LOAD_ITEM.apply(BasicConfigurationNode.root().set(map));
        }
        catch (ConfigurateException ignored) {
            return null;
        }
    }).registerP2W(ItemAttributeHolder.class, e -> e);

    @ApiStatus.Internal
    public AttributeMapping() {
        if (attributeMapping != null) {
            throw new UnsupportedOperationException("AttributeMapping is already initialized.");
        }
        attributeMapping = this;
    }

    public static Optional<AttributeHolder> wrapAttribute(Object attribute) {
        if (attributeMapping == null) {
            throw new UnsupportedOperationException("AttributeMapping is not initialized yet.");
        }
        return attributeMapping.wrapAttribute0(attribute);
    }

    protected abstract Optional<AttributeHolder> wrapAttribute0(Object var1);

    public static Optional<AttributeModifierHolder> wrapAttributeModifier(Object attributeModifier) {
        if (attributeMapping == null) {
            throw new UnsupportedOperationException("AttributeMapping is not initialized yet.");
        }
        return AttributeMapping.attributeMapping.attributeModifierConverter.convertOptional(attributeModifier);
    }

    public static Optional<ItemAttributeHolder> wrapItemAttribute(Object attribute) {
        if (attributeMapping == null) {
            throw new UnsupportedOperationException("AttributeMapping is not initialized yet.");
        }
        return AttributeMapping.attributeMapping.itemAttributeConverter.convertOptional(attribute);
    }

    public static <T> T convertItemAttributeHolder(ItemAttributeHolder holder, Class<T> newType) {
        if (attributeMapping == null) {
            throw new UnsupportedOperationException("AttributeMapping is not initialized yet.");
        }
        return AttributeMapping.attributeMapping.itemAttributeConverter.convert(holder, newType);
    }

    public static <T> T convertAttributeModifierHolder(AttributeModifierHolder holder, Class<T> newType) {
        if (attributeMapping == null) {
            throw new UnsupportedOperationException("AttributeMapping is not initialized yet.");
        }
        return AttributeMapping.attributeMapping.attributeModifierConverter.convert(holder, newType);
    }

    static {
        CONFIGURATE_LOAD_MODIFIER = node -> {
            ConfigurationNode uuid = node.node("uuid");
            ConfigurationNode name = node.node("name");
            ConfigurationNode amount = node.node("amount");
            ConfigurationNode operation = node.node("operation");
            try {
                return new AttributeModifierHolder(uuid.get(UUID.class, UUID::randomUUID), name.getString(""), amount.getDouble(), operation.get(AttributeModifierHolder.Operation.class));
            }
            catch (SerializationException e) {
                e.printStackTrace();
                return null;
            }
        };
        CONFIGURATE_LOAD_ITEM = node -> {
            ConfigurationNode type = node.node("type");
            ConfigurationNode uuid = node.node("uuid");
            ConfigurationNode name = node.node("name");
            ConfigurationNode amount = node.node("amount");
            ConfigurationNode operation = node.node("operation");
            ConfigurationNode slot = node.node("slot");
            Optional<AttributeTypeHolder> typeOpt = AttributeTypeMapping.resolve(type.raw());
            if (typeOpt.isEmpty()) {
                return null;
            }
            try {
                return new ItemAttributeHolder(typeOpt.get(), uuid.get(UUID.class, UUID::randomUUID), name.getString(""), amount.getDouble(), operation.get(AttributeModifierHolder.Operation.class), EquipmentSlotMapping.resolve(slot.raw()).orElse(null));
            }
            catch (SerializationException e) {
                e.printStackTrace();
                return null;
            }
        };
    }
}

