/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.block;

import io.github.pronze.lib.screaminglib.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class BlockDataTranslatorBuilder {
    private final List<DataEntry> entries = new ArrayList<DataEntry>();

    public BlockDataTranslatorBuilder lowerBitValueSet(String name, int mask, Map<Integer, String> values, String defaultValue) {
        values.forEach((aByte, value) -> this.entries.add(new DataEntry(b -> (byte)(b & ~mask | aByte), b -> (b & mask) == aByte, name, (String)value, s -> s == null && defaultValue.equals(value) || value.equalsIgnoreCase((String)s))));
        return this;
    }

    public BlockDataTranslatorBuilder maskedBoolean(String name, int mask) {
        return this.maskedBoolean(name, mask, "true", "false");
    }

    public BlockDataTranslatorBuilder maskedBoolean(String name, int mask, String trueString, String falseString) {
        this.entries.add(new DataEntry(b -> (byte)(b | mask), b -> (b & mask) == mask, name, trueString, trueString::equalsIgnoreCase));
        this.entries.add(new DataEntry(b -> (byte)(b & ~mask), b -> (b & mask) != mask, name, falseString, s -> !trueString.equalsIgnoreCase((String)s)));
        return this;
    }

    public Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>> build() {
        Function<Byte, Map> toFlattening = b -> {
            HashMap<String, String> map = new HashMap<String, String>();
            for (DataEntry entry : this.entries) {
                if (!entry.predicate.test((Byte)b)) continue;
                map.put(entry.flatteningName, entry.flatteningValue);
            }
            return map;
        };
        Function<Map, Byte> toLegacy = map -> {
            byte data = 0;
            for (DataEntry entry : this.entries) {
                if (!entry.flatteningPredicate.test((String)map.get(entry.flatteningName))) continue;
                data = entry.maskFunction.apply(data);
            }
            return data;
        };
        return Pair.of(toFlattening, toLegacy);
    }

    public static class DataEntry {
        public Function<Byte, Byte> maskFunction;
        public Predicate<Byte> predicate;
        public String flatteningName;
        public String flatteningValue;
        public Predicate<@Nullable String> flatteningPredicate;

        public Function<Byte, Byte> maskFunction() {
            return this.maskFunction;
        }

        public Predicate<Byte> predicate() {
            return this.predicate;
        }

        public String flatteningName() {
            return this.flatteningName;
        }

        public String flatteningValue() {
            return this.flatteningValue;
        }

        public Predicate<@Nullable String> flatteningPredicate() {
            return this.flatteningPredicate;
        }

        public DataEntry maskFunction(Function<Byte, Byte> maskFunction) {
            this.maskFunction = maskFunction;
            return this;
        }

        public DataEntry predicate(Predicate<Byte> predicate) {
            this.predicate = predicate;
            return this;
        }

        public DataEntry flatteningName(String flatteningName) {
            this.flatteningName = flatteningName;
            return this;
        }

        public DataEntry flatteningValue(String flatteningValue) {
            this.flatteningValue = flatteningValue;
            return this;
        }

        public DataEntry flatteningPredicate(Predicate<@Nullable String> flatteningPredicate) {
            this.flatteningPredicate = flatteningPredicate;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataEntry)) {
                return false;
            }
            DataEntry other = (DataEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Function<Byte, Byte> this$maskFunction = this.maskFunction();
            Function<Byte, Byte> other$maskFunction = other.maskFunction();
            if (this$maskFunction == null ? other$maskFunction != null : !this$maskFunction.equals(other$maskFunction)) {
                return false;
            }
            Predicate<Byte> this$predicate = this.predicate();
            Predicate<Byte> other$predicate = other.predicate();
            if (this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate)) {
                return false;
            }
            String this$flatteningName = this.flatteningName();
            String other$flatteningName = other.flatteningName();
            if (this$flatteningName == null ? other$flatteningName != null : !this$flatteningName.equals(other$flatteningName)) {
                return false;
            }
            String this$flatteningValue = this.flatteningValue();
            String other$flatteningValue = other.flatteningValue();
            if (this$flatteningValue == null ? other$flatteningValue != null : !this$flatteningValue.equals(other$flatteningValue)) {
                return false;
            }
            Predicate<String> this$flatteningPredicate = this.flatteningPredicate();
            Predicate<String> other$flatteningPredicate = other.flatteningPredicate();
            return !(this$flatteningPredicate == null ? other$flatteningPredicate != null : !this$flatteningPredicate.equals(other$flatteningPredicate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Function<Byte, Byte> $maskFunction = this.maskFunction();
            result = result * 59 + ($maskFunction == null ? 43 : $maskFunction.hashCode());
            Predicate<Byte> $predicate = this.predicate();
            result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
            String $flatteningName = this.flatteningName();
            result = result * 59 + ($flatteningName == null ? 43 : $flatteningName.hashCode());
            String $flatteningValue = this.flatteningValue();
            result = result * 59 + ($flatteningValue == null ? 43 : $flatteningValue.hashCode());
            Predicate<String> $flatteningPredicate = this.flatteningPredicate();
            result = result * 59 + ($flatteningPredicate == null ? 43 : $flatteningPredicate.hashCode());
            return result;
        }

        public String toString() {
            return "BlockDataTranslatorBuilder.DataEntry(maskFunction=" + this.maskFunction() + ", predicate=" + this.predicate() + ", flatteningName=" + this.flatteningName() + ", flatteningValue=" + this.flatteningValue() + ", flatteningPredicate=" + this.flatteningPredicate() + ")";
        }

        public DataEntry() {
        }

        public DataEntry(Function<Byte, Byte> maskFunction, Predicate<Byte> predicate, String flatteningName, String flatteningValue, Predicate<@Nullable String> flatteningPredicate) {
            this.maskFunction = maskFunction;
            this.predicate = predicate;
            this.flatteningName = flatteningName;
            this.flatteningValue = flatteningValue;
            this.flatteningPredicate = flatteningPredicate;
        }
    }
}

