/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.block;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.block.BlockTypeMapper;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.Preconditions;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ServiceDependencies;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
@ServiceDependencies(dependsOn={LocationMapper.class, BlockTypeMapper.class})
public abstract class BlockMapper {
    protected BidirectionalConverter<BlockHolder> converter = BidirectionalConverter.build().registerP2W(BlockHolder.class, e -> e);
    private static BlockMapper mapping;

    @ApiStatus.Internal
    public BlockMapper() {
        Preconditions.checkArgument(mapping == null, "BlockMapper is already initialized!");
        mapping = this;
    }

    public static Optional<BlockHolder> resolve(Object obj) {
        return Preconditions.checkNotNull(BlockMapper.mapping, (Object)"BlockMapper is not initialized yet!").converter.convertOptional(obj);
    }

    public static <T> BlockHolder wrapBlock(T block) {
        return Preconditions.checkNotNull(BlockMapper.mapping, (Object)"BlockMapper is not initialized yet!").converter.convert(block);
    }

    public static <T> T convert(BlockHolder holder, Class<T> newType) {
        return Preconditions.checkNotNull(BlockMapper.mapping, (Object)"BlockMapper is not initialized yet!").converter.convert(holder, newType);
    }

    public static BlockHolder getBlockAt(LocationHolder location) {
        return Preconditions.checkNotNull(mapping, "BlockMapper is not initialized yet!").getBlockAt0(location);
    }

    public static void setBlockAt(LocationHolder location, BlockTypeHolder material, boolean ignorePhysics) {
        Preconditions.checkNotNull(mapping, "BlockMapper is not initialized yet!").setBlockAt0(location, material, ignorePhysics);
    }

    public static void breakNaturally(LocationHolder location) {
        Preconditions.checkNotNull(mapping, "BlockMapper is not initialized yet!").breakNaturally0(location);
    }

    protected abstract BlockHolder getBlockAt0(LocationHolder var1);

    protected abstract void setBlockAt0(LocationHolder var1, BlockTypeHolder var2, boolean var3);

    protected abstract void breakNaturally0(LocationHolder var1);
}

