/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.block;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.ItemBlockIdsRemapper;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.configurate.BlockTypeHolderSerializer;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.Pair;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.key.ComplexMappingKey;
import io.github.pronze.lib.screaminglib.utils.key.MappingKey;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import io.github.pronze.lib.screaminglib.utils.key.NumericMappingKey;
import io.github.pronze.lib.screaminglib.utils.key.StringMapMappingKey;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
public abstract class BlockTypeMapper
extends AbstractTypeMapper<BlockTypeHolder> {
    private static final Pattern RESOLUTION_PATTERN = Pattern.compile("^(((?<namespaced>(?:([A-Za-z][A-Za-z0-9_.\\-]*):)?[A-Za-z][A-Za-z0-9_.\\-/ ]*)(?<blockState>:\\d*|\\[[^]]*])?)|((?<id>\\d+)(?::)?(?<data>\\d+)?))$");
    protected final Map<Predicate<NamespacedMappingKey>, Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>>> blockDataTranslators = new HashMap<Predicate<NamespacedMappingKey>, Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>>>();
    protected BidirectionalConverter<BlockTypeHolder> blockTypeConverter = BidirectionalConverter.build().registerP2W(BlockTypeHolder.class, i -> i).registerP2W(ConfigurationNode.class, node -> {
        try {
            return BlockTypeHolderSerializer.INSTANCE.deserialize((Type)((Object)BlockTypeMapper.class), (ConfigurationNode)node);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
            return null;
        }
    });
    private static BlockTypeMapper blockTypeMapper;
    private static BlockTypeHolder cachedAir;

    @ApiStatus.Internal
    public BlockTypeMapper() {
        if (blockTypeMapper != null) {
            throw new UnsupportedOperationException("BlockTypeMapper is already initialized.");
        }
        blockTypeMapper = this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.BLOCK)
    @OfMethodAlternative(value=BlockTypeHolder.class, methodName="ofOptional")
    public static Optional<BlockTypeHolder> resolve(Object materialObject) {
        if (blockTypeMapper == null) {
            throw new UnsupportedOperationException("BlockTypeMapper is not initialized yet.");
        }
        if (materialObject == null) {
            return Optional.empty();
        }
        return BlockTypeMapper.blockTypeMapper.blockTypeConverter.convertOptional(materialObject).or(() -> {
            String material = materialObject.toString().trim();
            Matcher matcher = RESOLUTION_PATTERN.matcher(material);
            if (matcher.matches()) {
                if (matcher.group("namespaced") != null) {
                    BlockTypeHolder holder;
                    Object newData;
                    Object flatteningData;
                    Integer data;
                    NamespacedMappingKey namespaced;
                    block30: {
                        namespaced = NamespacedMappingKey.of(matcher.group("namespaced"));
                        data = null;
                        flatteningData = null;
                        String blockState = matcher.group("blockState");
                        if (blockState != null) {
                            try {
                                data = Integer.parseInt(blockState);
                            }
                            catch (NumberFormatException ignored) {
                                if (!blockState.startsWith("[") || !blockState.endsWith("]")) break block30;
                                Map<String, String> map = blockTypeMapper.getDataFromString(blockState.toLowerCase());
                                if (map.containsKey("legacy_data") && map.size() == 1) {
                                    try {
                                        data = Integer.parseInt(map.get("legacy_data"));
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                }
                                flatteningData = map;
                            }
                        }
                    }
                    if (flatteningData != null && blockTypeMapper.isLegacy()) {
                        Map<String, String> finalFlatteningData = flatteningData;
                        newData = BlockTypeMapper.blockTypeMapper.blockDataTranslators.entrySet().stream().filter(predicatePairEntry -> ((Predicate)predicatePairEntry.getKey()).test(namespaced)).findFirst().map(predicatePairEntry -> (Byte)((Function)((Pair)predicatePairEntry.getValue()).second()).apply(finalFlatteningData)).orElse(null);
                        if (newData != null) {
                            flatteningData = null;
                            data = ((Byte)newData).intValue();
                        }
                    } else if (data != null && !blockTypeMapper.isLegacy()) {
                        Integer finalData = data;
                        newData = BlockTypeMapper.blockTypeMapper.blockDataTranslators.entrySet().stream().filter(predicatePairEntry -> ((Predicate)predicatePairEntry.getKey()).test(namespaced)).findFirst().map(predicatePairEntry -> (Map)((Function)((Pair)predicatePairEntry.getValue()).first()).apply(finalData.byteValue())).orElse(null);
                        if (newData != null) {
                            data = null;
                            flatteningData = newData;
                        }
                    }
                    if (data != null) {
                        ComplexMappingKey namespacedDurability = ComplexMappingKey.of(namespaced, NumericMappingKey.of(data));
                        if (BlockTypeMapper.blockTypeMapper.mapping.containsKey(namespacedDurability)) {
                            return Optional.of(blockTypeMapper.normalize((BlockTypeHolder)BlockTypeMapper.blockTypeMapper.mapping.get(namespacedDurability)));
                        }
                        if (BlockTypeMapper.blockTypeMapper.mapping.containsKey(namespaced)) {
                            holder = (BlockTypeHolder)BlockTypeMapper.blockTypeMapper.mapping.get(namespaced);
                            return Optional.of(blockTypeMapper.normalize(holder.withLegacyData(data.byteValue())));
                        }
                    } else if (flatteningData != null) {
                        ComplexMappingKey namespacedFlattening = ComplexMappingKey.of(namespaced, StringMapMappingKey.of(flatteningData));
                        if (BlockTypeMapper.blockTypeMapper.mapping.containsKey(namespacedFlattening)) {
                            return Optional.of(blockTypeMapper.normalize((BlockTypeHolder)BlockTypeMapper.blockTypeMapper.mapping.get(namespacedFlattening)));
                        }
                        if (BlockTypeMapper.blockTypeMapper.mapping.containsKey(namespaced)) {
                            holder = (BlockTypeHolder)BlockTypeMapper.blockTypeMapper.mapping.get(namespaced);
                            return Optional.of(blockTypeMapper.normalize(holder.withFlatteningData((Map<String, String>)flatteningData)));
                        }
                    } else if (BlockTypeMapper.blockTypeMapper.mapping.containsKey(namespaced)) {
                        return Optional.of(blockTypeMapper.normalize((BlockTypeHolder)BlockTypeMapper.blockTypeMapper.mapping.get(namespaced)));
                    }
                } else if (matcher.group("id") != null) {
                    try {
                        int id = Integer.parseInt(matcher.group("id"));
                        int data = 0;
                        try {
                            data = Integer.parseInt(matcher.group("data"));
                        }
                        catch (NumberFormatException flatteningData) {
                            // empty catch block
                        }
                        ComplexMappingKey keyWithData = ComplexMappingKey.of(NumericMappingKey.of(id), NumericMappingKey.of(data));
                        NumericMappingKey key = NumericMappingKey.of(id);
                        if (BlockTypeMapper.blockTypeMapper.mapping.containsKey(keyWithData)) {
                            return Optional.of(blockTypeMapper.normalize((BlockTypeHolder)BlockTypeMapper.blockTypeMapper.mapping.get(keyWithData)));
                        }
                        if (BlockTypeMapper.blockTypeMapper.mapping.containsKey(key)) {
                            BlockTypeHolder holder = (BlockTypeHolder)BlockTypeMapper.blockTypeMapper.mapping.get(key);
                            return Optional.of(blockTypeMapper.normalize(holder.withLegacyData((byte)data)));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return Optional.empty();
        });
    }

    @OfMethodAlternative(value=BlockTypeHolder.class, methodName="all")
    public static List<BlockTypeHolder> getValues() {
        if (blockTypeMapper == null) {
            throw new UnsupportedOperationException("BlockTypeMapper is not initialized yet.");
        }
        return Collections.unmodifiableList(BlockTypeMapper.blockTypeMapper.values);
    }

    public static BlockTypeHolder colorize(BlockTypeHolder holder, String color) {
        if (blockTypeMapper == null) {
            throw new UnsupportedOperationException("BlockTypeMapper is not initialized yet.");
        }
        return ItemBlockIdsRemapper.colorableBlocks.entrySet().stream().filter(c -> ((Predicate)c.getKey()).test(holder)).map(Map.Entry::getValue).findFirst().flatMap(fun -> (Optional)fun.apply(color)).orElse(holder);
    }

    @OfMethodAlternative(value=BlockTypeHolder.class, methodName="air")
    public static BlockTypeHolder getCachedAir() {
        if (cachedAir == null) {
            cachedAir = BlockTypeMapper.resolve("minecraft:air").orElseThrow();
        }
        return cachedAir;
    }

    public Map<MappingKey, BlockTypeHolder> getUNSAFE_mapping() {
        return this.mapping;
    }

    @Override
    public void mapAlias(String mappingKey, String alias) {
        super.mapAlias(mappingKey, alias);
    }

    protected abstract Map<String, String> getDataFromString(String var1);

    protected abstract BlockTypeHolder normalize(BlockTypeHolder var1);

    protected abstract boolean isLegacy();

    public Map<Predicate<NamespacedMappingKey>, Pair<Function<Byte, Map<String, String>>, Function<Map<String, String>, Byte>>> getBlockDataTranslators() {
        return this.blockDataTranslators;
    }
}

